block('b-time-targeting-scale-board').elem('day')(

    def().match(function() {
        return this.position === 7;
    })(function() {
        return applyNext({
            'ctx.mix': u._.extend({}, this.elemMods, { elem: 'trailer-day' })
        });
    }),

    content()(function() {

        var ctx = this.ctx,
            hours = u['b-time-targeting'].FULL_HOUR_CODES.map(function(hourCode) {
                var lvl = this.ctx.value[hourCode] || 0;

                return {
                    elem: 'hour',
                    elemMods: {
                        level: lvl,
                        code: hourCode,
                        day: this.position
                    },
                    attrs: {
                        title: lvl + '%',
                        unselectable: 'on'
                    },
                    content: lvl
                }
            }, this);

        return [
            {
                elem: 'day-label',
                content: ctx.label
            },
            {
                block: 'checkbox',
                mods: {
                    theme: 'normal',
                    size: 's',
                    checked: ctx.isFull ? 'yes' : ''
                },
                js: { day: this.position },
                mix: [{
                    block: 'b-time-targeting-scale-board',
                    elem: 'day-checkbox'
                }]
            },
            hours
        ];
    })
);
