/**
 * Генерируется при клике на значение шкалы.
 *
 * @event b-time-targeting-toolbar#change
 * @param {Number} value
 */

BEM.DOM.decl('b-time-targeting-scale', {

    onSetMod: {
        js: function() {
            this._items = {};
        },

        visible: function(modName, modVal) {
            var events = 'pointerclick mouseenter mouseleave';

            this[modVal == 'yes' ? 'bindTo' : 'unbindFrom']('item', events, this._onScalePoint);
        }
    },

    /**
     * Устанавливает уровень цены клика.
     *
     * @param {Number} level Уровень цены клика.
     * @param {Boolean} [isSilent=false] Флаг позволяющий не триггерить событие.
     */
    setLevel: function(level, isSilent) {
        this
            .setMod(this.elem('brush'), 'level', level)
            .delMod(this.elem('item'), 'selected')
            .setMod(this._getItemByLevel(level), 'selected', 'yes');

        isSilent || this.trigger('change', +level);
    },

    /**
     * Получает элемент point уровня цены из объекта события.
     *
     * @param {Event} event Объект события.
     * @returns {jQuery}
     * @private
     */
    _getPointByEvent: function(event) {
        return this.findElem($(event.currentTarget), 'point');
    },

    /**
     * Получает элемент item уровня цены клика по уровню цены.
     *
     * @param {Number} level Уровень цены клика.
     * @returns {jQuery}
     * @private
     */
    _getItemByLevel: function(level) {
        return this._items[level] ||
            (this._items[level] = this.findElem(this.elem('point', 'level', level).parent(), 'item'));
    },

    /**
     * Обрабатывает события элемента point уровня цены.
     *
     * @param {Event} event Объект события.
     * @private
     */
    _onScalePoint: function(event) {
        event.type === 'pointerclick' ?
            this.setLevel(this.getMod(this._getPointByEvent(event), 'level')) :
            this.toggleMod($(event.currentTarget), 'hovered', 'yes', '');
    }

}, {
    live: true
});
