block('b-time-targeting-timezone')(

    def()(function() {
        var getOptions = function(data, value) {
                return data.map(function(item) {
                    var option = {
                        elem: 'option',
                        attrs: { value: item.value },
                        content: item.content
                    };

                    item.value == value && (option.attrs.selected = 'selected');

                    return option;
                });
            },
            data = this.ctx.data;

        return applyNext({
            _timezoneOptions: getOptions(data.timezoneData[data.timezoneRegionId], data.timezoneId),
            _timezoneRegionsOptions: getOptions(data.timezoneRegionsData, data.timezoneRegionId)
        });
    }),

    js()(function() {
        return {
            timezoneData: this.ctx.data.timezoneData,
            regionsData: this.ctx.data.timezoneRegionsData
        };
    }),

    content()(function() {
        return [
            {
                elem: 'label',
                content: iget2('b-time-targeting-timezone', 'chasovoy-poyas', 'Часовой пояс:')
            },
            {
                elem: 'select',
                text: this.ctx.data.timezoneRegionText,
                type: 'regions',
                name: 'timezone-regions',
                options: this._timezoneRegionsOptions
            },
            {
                elem: 'arrow',
                content: ' &rarr; '
            },
            {
                elem: 'select',
                text: this.ctx.data.timezoneText,
                type: 'timezones',
                name: 'timezone-zones',
                options: this._timezoneOptions
            },
            {
                elem: 'timezone-hint',
                content: iget2(
                    'b-time-targeting-timezone',
                    'vybrannaya-strana-budet-uchityvatsya',
                    'Выбранная страна будет учитываться в настройке учета праздничных дней'
                )
            }
        ];
    }),

    elem('label').tag()('span'),

    elem('arrow').tag()('span'),

    elem('select').def()(function() {

        return applyCtx({
            block: 'select',
            mods: {
                theme: 'normal',
                size: 's',
                name: this.ctx.name
            },
            mix: {
                block: 'b-time-targeting-timezone',
                elem: this.ctx.type
            },
            js: true,
            content: [
                {
                    block: 'button',
                    mods: { theme: 'normal', size: 's' },
                    content: this.ctx.text
                },
                {
                    elem: 'control',
                    content: this.ctx.options
                }
            ]
        });
    })
);
