BEM.DOM.decl('b-time-targeting-timezone', {
    /**
     * Генерируется при изменении значения временной зоны.
     *
     * @event b-time-targeting-timezon#change
     * @param {Object} data
     * @param {Number} data.id Id временной зоны.
     * @param {String} data.text Текст временной зоны.
     */
    onSetMod: {
        js: function() {
            this._selects = {};
        }
    },

    /**
     * Устанавливает таймзону.
     * @param {String} regionId
     * @param {String} timezoneId
     */
    setTimezone: function(regionId, timezoneId) {
        this._getSelect('regions').val(regionId);
        this._getSelect('timezones').val(timezoneId);
    },
    /**
     * Обрабатывает изменение региона.
     * @private
     */
    _onRegionsChange: function() {
        this._getSelect('timezones').setOptions(this.params.timezoneData[this._getSelect('regions').val()]);
        // событие на установку опций отменяется, поэтому триггерим событие вручную
        this._onTimezonesChange();
    },

    /**
     * Получает селект по имени элемента.
     *
     * @param {String} name Имя селекта.
     * @returns {BEM}
     * @private
     */
    _getSelect: function(name) {
        return this._selects[name] || (this._selects[name] = this.findBlockOn(this.elem(name), 'select'));
    },

    /**
     * Получает текст таймзоны.
     *
     * @returns {BEM}
     * @private
     */
    _getTimezoneText: function() {
        return this._getSelect('timezones').getSelectedOptionText();
    },

    /**
     * Обрабатывает изменение таймзоны.
     *
     * @private
     */
    _onTimezonesChange: function() {
        this.trigger('change', {
            id: this._getSelect('timezones').val(),
            text: this._getTimezoneText(),
            region: this._getSelect('regions').val()
        });
    },

    /**
     * Обработчик изменения селекта
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onSelectChange: function(e, data) {
        var block = e.block,
            domElem = block.domElem;

        if (this.elem('regions').is(domElem)) {
            this._selects.regions || (this._selects.regions = block);

            this._onRegionsChange(e, data);
        } else if (this.elem('timezones').is(domElem)) {
            this._selects.timezones || (this._selects.timezones = block);

            this._onTimezonesChange(e, data);
        }
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('change', 'select', function(e, data) {
            this._onSelectChange(e, data);
        });
    }

});
