describe('b-time-targeting-timezone', function() {
    var scope = {}; // хак что-бы обмануть jshint

    /* jshint ignore:start */
    scope.data = JSON.parse('{"timezoneData":{"russia":[{"item":"option","value":"131","content":"Калининград (MSK -01:00)","selected":false},{"item":"option","value":"130","content":"Москва","selected":true},{"item":"option","value":"133","content":"Екатеринбург (MSK +02:00)","selected":false},{"item":"option","value":"270","content":"Омск (MSK +03:00)","selected":false},{"item":"option","value":"134","content":"Красноярск (MSK +04:00)","selected":false},{"item":"option","value":"135","content":"Иркутск (MSK +05:00)","selected":false},{"item":"option","value":"137","content":"Якутск (MSK +06:00)","selected":false},{"item":"option","value":"138","content":"Владивосток (MSK +07:00)","selected":false},{"item":"option","value":"140","content":"Магадан (MSK +08:00)","selected":false}],"cis":[{"item":"option","value":"166","content":"Абхазия (MSK +00:00, GMT +04:00)","selected":false},{"item":"option","value":"98","content":"Азербайджан (MSK +01:00, GMT +05:00)","selected":false},{"item":"option","value":"13","content":"Армения (MSK +01:00, GMT +05:00)","selected":false},{"item":"option","value":"149","content":"Беларусь (MSK -01:00, GMT +03:00)","selected":false},{"item":"option","value":"120","content":"Казахстан, Актобе (MSK +01:00, GMT +05:00)","selected":false},{"item":"option","value":"119","content":"Казахстан, Алматы (MSK +02:00, GMT +06:00)","selected":false},{"item":"option","value":"4","content":"Киргизия (MSK +02:00, GMT +06:00)","selected":false},{"item":"option","value":"243","content":"Молдова (MSK -01:00, GMT +03:00)","selected":false},{"item":"option","value":"147","content":"Таджикистан (MSK +01:00, GMT +05:00)","selected":false},{"item":"option","value":"3","content":"Туркмения (MSK +01:00, GMT +05:00)","selected":false},{"item":"option","value":"178","content":"Узбекистан (MSK +01:00, GMT +05:00)","selected":false},{"item":"option","value":"61","content":"Украина (MSK -01:00, GMT +03:00)","selected":false},{"item":"option","value":"81","content":"Южная Осетия (MSK +00:00, GMT +04:00)","selected":false}],"world":[{"item":"option","value":"278","content":"Австралия, Брисбен (GMT +10:00)","selected":false},{"item":"option","value":"93","content":"Австралия, Остров Рождества (GMT +07:00)","selected":false},{"item":"option","value":"94","content":"Австралия, Перт (GMT +08:00)","selected":false},{"item":"option","value":"91","content":"Австралия, Сидней (GMT +10:00)","selected":false},{"item":"option","value":"157","content":"Австрия (GMT +02:00)","selected":false},{"item":"option","value":"31","content":"Албания (GMT +02:00)","selected":false},{"item":"option","value":"22","content":"Алжир (GMT +01:00)","selected":false},{"item":"option","value":"247","content":"Американские Виргинские острова (GMT -04:00)","selected":false},{"item":"option","value":"211","content":"Ангилья (GMT -04:00)","selected":false},{"item":"option","value":"165","content":"Ангола (GMT +01:00)","selected":false},{"item":"option","value":"54","content":"Андорра (GMT +02:00)","selected":false},{"item":"option","value":"10","content":"Антигуа и Барбуда (GMT -04:00)","selected":false},{"item":"option","value":"184","content":"Аргентина (GMT -03:00)","selected":false},{"item":"option","value":"115","content":"Аруба (GMT -04:00)","selected":false},{"item":"option","value":"241","content":"Багамские острова (GMT -04:00)","selected":false},{"item":"option","value":"36","content":"Бангладеш (GMT +06:00)","selected":false},{"item":"option","value":"173","content":"Барбадос (GMT -04:00)","selected":false},{"item":"option","value":"181","content":"Бахрейн (GMT +03:00)","selected":false},{"item":"option","value":"53","content":"Белиз (GMT -06:00)","selected":false},{"item":"option","value":"244","content":"Бельгия (GMT +02:00)","selected":false},{"item":"option","value":"146","content":"Бенин (GMT +01:00)","selected":false},{"item":"option","value":"228","content":"Бермудские Острова (GMT -03:00)","selected":false},{"item":"option","value":"103","content":"Болгария (GMT +03:00)","selected":false},{"item":"option","value":"102","content":"Боливия (GMT -04:00)","selected":false},{"item":"option","value":"239","content":"Босния и Герцеговина (GMT +02:00)","selected":false},{"item":"option","value":"217","content":"Ботсвана (GMT +02:00)","selected":false},{"item":"option","value":"79","content":"Бразилия, Атибая (GMT -03:00)","selected":false},{"item":"option","value":"80","content":"Бразилия, Манаус (GMT -04:00)","selected":false},{"item":"option","value":"277","content":"Бразилия, Мосоро (GMT -03:00)","selected":false},{"item":"option","value":"156","content":"Британские Виргинские острова (GMT -04:00)","selected":false},{"item":"option","value":"51","content":"Бруней (GMT +08:00)","selected":false},{"item":"option","value":"200","content":"Буркина-Фасо (GMT +00:00)","selected":false},{"item":"option","value":"109","content":"Бурунди (GMT +02:00)","selected":false},{"item":"option","value":"60","content":"Бутан (GMT +06:00)","selected":false},{"item":"option","value":"161","content":"Вануату (GMT +11:00)","selected":false},{"item":"option","value":"78","content":"Ватикан (GMT +02:00)","selected":false},{"item":"option","value":"170","content":"Великобритания (GMT +01:00)","selected":false},{"item":"option","value":"197","content":"Венгрия (GMT +02:00)","selected":false},{"item":"option","value":"65","content":"Восточный Тимор (GMT +09:00)","selected":false},{"item":"option","value":"21","content":"Вьетнам (GMT +07:00)","selected":false},{"item":"option","value":"160","content":"Габон (GMT +01:00)","selected":false},{"item":"option","value":"29","content":"Гаити (GMT -05:00)","selected":false},{"item":"option","value":"105","content":"Гайана (GMT -04:00)","selected":false},{"item":"option","value":"205","content":"Гамбия (GMT +00:00)","selected":false},{"item":"option","value":"210","content":"Гана (GMT +00:00)","selected":false},{"item":"option","value":"150","content":"Гватемала (GMT -06:00)","selected":false},{"item":"option","value":"48","content":"Гвинея (GMT +00:00)","selected":false},{"item":"option","value":"11","content":"Гвинея-Бисау (GMT +00:00)","selected":false},{"item":"option","value":"56","content":"Германия (GMT +02:00)","selected":false},{"item":"option","value":"175","content":"Гибралтар (GMT +02:00)","selected":false},{"item":"option","value":"226","content":"Гондурас (GMT -06:00)","selected":false},{"item":"option","value":"90","content":"Гренада (GMT -04:00)","selected":false},{"item":"option","value":"76","content":"Гренландия (GMT -02:00)","selected":false},{"item":"option","value":"195","content":"Греция (GMT +03:00)","selected":false},{"item":"option","value":"121","content":"Грузия (GMT +04:00)","selected":false},{"item":"option","value":"245","content":"Гуам (GMT +10:00)","selected":false},{"item":"option","value":"225","content":"Дания, Копенгаген (GMT +02:00)","selected":false},{"item":"option","value":"224","content":"Дания, Хусар (GMT +01:00)","selected":false},{"item":"option","value":"37","content":"Демократическая Республика Конго (GMT +01:00)","selected":false},{"item":"option","value":"250","content":"Демократическая Республика Конго, Колвези (GMT +02:00)","selected":false},{"item":"option","value":"117","content":"Джибути (GMT +03:00)","selected":false},{"item":"option","value":"58","content":"Доминика (GMT -04:00)","selected":false},{"item":"option","value":"88","content":"Доминиканская Республика (GMT -04:00)","selected":false},{"item":"option","value":"16","content":"Египет (GMT +02:00)","selected":false},{"item":"option","value":"164","content":"Замбия (GMT +02:00)","selected":false},{"item":"option","value":"176","content":"Зимбабве (GMT +02:00)","selected":false},{"item":"option","value":"6","content":"Израиль (GMT +03:00)","selected":false},{"item":"option","value":"113","content":"Индонезия, Джакарта (GMT +07:00)","selected":false},{"item":"option","value":"114","content":"Индонезия, Джаяпура (GMT +09:00)","selected":false},{"item":"option","value":"279","content":"Индонезия, Макассар (GMT +08:00)","selected":false},{"item":"option","value":"112","content":"Индонезия, Семиньяк (GMT +08:00)","selected":false},{"item":"option","value":"232","content":"Иордания (GMT +03:00)","selected":false},{"item":"option","value":"111","content":"Ирак (GMT +03:00)","selected":false},{"item":"option","value":"168","content":"Ирландия (GMT +01:00)","selected":false},{"item":"option","value":"12","content":"Исландия (GMT +00:00)","selected":false},{"item":"option","value":"162","content":"Испания, Мадрид (GMT +02:00)","selected":false},{"item":"option","value":"163","content":"Испания, Санта-Крус-де-Тенерифе (GMT +01:00)","selected":false},{"item":"option","value":"28","content":"Италия (GMT +02:00)","selected":false},{"item":"option","value":"215","content":"Йемен (GMT +03:00)","selected":false},{"item":"option","value":"99","content":"Кабо-Верде (GMT -01:00)","selected":false},{"item":"option","value":"216","content":"Каймановы острова (GMT -05:00)","selected":false},{"item":"option","value":"145","content":"Камбоджа (GMT +07:00)","selected":false},{"item":"option","value":"45","content":"Камерун (GMT +01:00)","selected":false},{"item":"option","value":"222","content":"Канада, Ванкувер (GMT -07:00)","selected":false},{"item":"option","value":"221","content":"Канада, Виннипег (GMT -05:00)","selected":false},{"item":"option","value":"276","content":"Канада, Галифакс (GMT -03:00)","selected":false},{"item":"option","value":"219","content":"Канада, Йеллоунайф (GMT -06:00)","selected":false},{"item":"option","value":"282","content":"Канада, Принс-Альберт (GMT -06:00)","selected":false},{"item":"option","value":"283","content":"Канада, Сен-Пьер и Микелон (GMT -02:00)","selected":false},{"item":"option","value":"218","content":"Канада, Торонто (GMT -04:00)","selected":false},{"item":"option","value":"229","content":"Катар (GMT +03:00)","selected":false},{"item":"option","value":"1","content":"Кения (GMT +03:00)","selected":false},{"item":"option","value":"83","content":"Кипр (GMT +03:00)","selected":false},{"item":"option","value":"190","content":"Кирибати (GMT +12:00)","selected":false},{"item":"option","value":"189","content":"Китай (GMT +08:00)","selected":false},{"item":"option","value":"212","content":"Колумбия (GMT -05:00)","selected":false},{"item":"option","value":"214","content":"Коморские острова (GMT +03:00)","selected":false},{"item":"option","value":"24","content":"Коста-Рика (GMT -06:00)","selected":false},{"item":"option","value":"25","content":"Кот-д’Ивуар (GMT +00:00)","selected":false},{"item":"option","value":"85","content":"Куба (GMT -04:00)","selected":false},{"item":"option","value":"141","content":"Кувейт (GMT +03:00)","selected":false},{"item":"option","value":"77","content":"Кюрасао (GMT -04:00)","selected":false},{"item":"option","value":"193","content":"Лаос (GMT +07:00)","selected":false},{"item":"option","value":"110","content":"Латвия (GMT +03:00)","selected":false},{"item":"option","value":"8","content":"Лесото (GMT +02:00)","selected":false},{"item":"option","value":"86","content":"Либерия (GMT +00:00)","selected":false},{"item":"option","value":"116","content":"Ливан (GMT +03:00)","selected":false},{"item":"option","value":"68","content":"Ливия (GMT +02:00)","selected":false},{"item":"option","value":"71","content":"Литва (GMT +03:00)","selected":false},{"item":"option","value":"84","content":"Лихтенштейн (GMT +02:00)","selected":false},{"item":"option","value":"223","content":"Люксембург (GMT +02:00)","selected":false},{"item":"option","value":"235","content":"Маврикий (GMT +04:00)","selected":false},{"item":"option","value":"188","content":"Мавритания (GMT +00:00)","selected":false},{"item":"option","value":"35","content":"Мадагаскар (GMT +03:00)","selected":false},{"item":"option","value":"202","content":"Македония (GMT +02:00)","selected":false},{"item":"option","value":"18","content":"Малави (GMT +02:00)","selected":false},{"item":"option","value":"124","content":"Малайзия (GMT +08:00)","selected":false},{"item":"option","value":"191","content":"Мали (GMT +00:00)","selected":false},{"item":"option","value":"20","content":"Мальдивы (GMT +05:00)","selected":false},{"item":"option","value":"50","content":"Мальта (GMT +02:00)","selected":false},{"item":"option","value":"158","content":"Марокко (GMT +00:00)","selected":false},{"item":"option","value":"143","content":"Мартиника (GMT -04:00)","selected":false},{"item":"option","value":"63","content":"Маршалловы острова (GMT +12:00)","selected":false},{"item":"option","value":"280","content":"Мексика, Мехикали (GMT -07:00)","selected":false},{"item":"option","value":"127","content":"Мексика, Тласкала-де-Хикотенкатль (GMT -05:00)","selected":false},{"item":"option","value":"128","content":"Мексика, Чиуауа (GMT -06:00)","selected":false},{"item":"option","value":"253","content":"Мексика, Эрмосильо (GMT -07:00)","selected":false},{"item":"option","value":"155","content":"Мозамбик (GMT +02:00)","selected":false},{"item":"option","value":"187","content":"Монако (GMT +02:00)","selected":false},{"item":"option","value":"233","content":"Монголия (GMT +08:00)","selected":false},{"item":"option","value":"234","content":"Монголия, Ховд (GMT +07:00)","selected":false},{"item":"option","value":"198","content":"Монтсеррат (GMT -04:00)","selected":false},{"item":"option","value":"32","content":"Намибия (GMT +01:00)","selected":false},{"item":"option","value":"194","content":"Науру (GMT +12:00)","selected":false},{"item":"option","value":"199","content":"Нигер (GMT +01:00)","selected":false},{"item":"option","value":"66","content":"Нигерия (GMT +01:00)","selected":false},{"item":"option","value":"174","content":"Нидерланды (GMT +02:00)","selected":false},{"item":"option","value":"179","content":"Никарагуа (GMT -06:00)","selected":false},{"item":"option","value":"196","content":"Ниуэ (GMT -11:00)","selected":false},{"item":"option","value":"154","content":"Новая Зеландия (GMT +12:00)","selected":false},{"item":"option","value":"213","content":"Новая Каледония (GMT +11:00)","selected":false},{"item":"option","value":"23","content":"Норвегия (GMT +02:00)","selected":false},{"item":"option","value":"262","content":"Норфолк (GMT +10:00)","selected":false},{"item":"option","value":"203","content":"Объединённые Арабские Эмираты (GMT +04:00)","selected":false},{"item":"option","value":"30","content":"Оман (GMT +04:00)","selected":false},{"item":"option","value":"96","content":"Острова Кука (GMT -10:00)","selected":false},{"item":"option","value":"238","content":"Пакистан (GMT +05:00)","selected":false},{"item":"option","value":"204","content":"Палау (GMT +09:00)","selected":false},{"item":"option","value":"33","content":"Палестина (GMT +02:00)","selected":false},{"item":"option","value":"47","content":"Панама (GMT -05:00)","selected":false},{"item":"option","value":"259","content":"Папуа-Новая Гвинея (GMT +10:00)","selected":false},{"item":"option","value":"185","content":"Парагвай (GMT -04:00)","selected":false},{"item":"option","value":"74","content":"Перу (GMT -05:00)","selected":false},{"item":"option","value":"208","content":"Польша (GMT +02:00)","selected":false},{"item":"option","value":"275","content":"Польша, Бобова (GMT +04:00)","selected":false},{"item":"option","value":"152","content":"Португалия, Азорские острова (GMT +00:00)","selected":false},{"item":"option","value":"151","content":"Португалия, Лиссабон (GMT +01:00)","selected":false},{"item":"option","value":"254","content":"Португалия, Фигейра-де-Фош (GMT +02:00)","selected":false},{"item":"option","value":"46","content":"Пуэрто-Рико (GMT -04:00)","selected":false},{"item":"option","value":"186","content":"Республика Конго (GMT +01:00)","selected":false},{"item":"option","value":"201","content":"Руанда (GMT +02:00)","selected":false},{"item":"option","value":"206","content":"Румыния (GMT +03:00)","selected":false},{"item":"option","value":"761","content":"США, Атланта (GMT -04:00)","selected":false},{"item":"option","value":"42","content":"США, Бедфорд (GMT -05:00)","selected":false},{"item":"option","value":"40","content":"США, Гонолулу (GMT -10:00)","selected":false},{"item":"option","value":"41","content":"США, Денвер (GMT -06:00)","selected":false},{"item":"option","value":"44","content":"США, Джуно (GMT -08:00)","selected":false},{"item":"option","value":"39","content":"США, Дэйли-Сити (GMT -07:00)","selected":false},{"item":"option","value":"38","content":"США, Луисвилл (GMT -04:00)","selected":false},{"item":"option","value":"240","content":"Сальвадор (GMT -06:00)","selected":false},{"item":"option","value":"7","content":"Самоа (GMT +13:00)","selected":false},{"item":"option","value":"142","content":"Сан-Марино (GMT +02:00)","selected":false},{"item":"option","value":"64","content":"Сан-Томе и Принсипи (GMT +00:00)","selected":false},{"item":"option","value":"72","content":"Саудовская Аравия (GMT +03:00)","selected":false},{"item":"option","value":"167","content":"Сахарская Арабская Демократическая Республика (GMT +00:00)","selected":false},{"item":"option","value":"97","content":"Свазиленд (GMT +02:00)","selected":false},{"item":"option","value":"209","content":"Северная Корея (GMT +09:00)","selected":false},{"item":"option","value":"242","content":"Сейшельские острова (GMT +04:00)","selected":false},{"item":"option","value":"123","content":"Сенегал (GMT +00:00)","selected":false},{"item":"option","value":"169","content":"Сент-Винсент и Гренадины (GMT -04:00)","selected":false},{"item":"option","value":"101","content":"Сент-Китс и Невис (GMT -04:00)","selected":false},{"item":"option","value":"153","content":"Сент-Люсия (GMT -04:00)","selected":false},{"item":"option","value":"57","content":"Сербия (GMT +02:00)","selected":false},{"item":"option","value":"62","content":"Сингапур (GMT +08:00)","selected":false},{"item":"option","value":"268","content":"Синт-Мартен (GMT -04:00)","selected":false},{"item":"option","value":"27","content":"Сирия (GMT +03:00)","selected":false},{"item":"option","value":"87","content":"Словакия (GMT +02:00)","selected":false},{"item":"option","value":"236","content":"Словения (GMT +02:00)","selected":false},{"item":"option","value":"52","content":"Соломоновы острова (GMT +11:00)","selected":false},{"item":"option","value":"183","content":"Сомали (GMT +03:00)","selected":false},{"item":"option","value":"107","content":"Судан (GMT +03:00)","selected":false},{"item":"option","value":"207","content":"Суринам (GMT -03:00)","selected":false},{"item":"option","value":"67","content":"Сьерра-Леоне (GMT +00:00)","selected":false},{"item":"option","value":"148","content":"Таиланд (GMT +07:00)","selected":false},{"item":"option","value":"125","content":"Танзания (GMT +03:00)","selected":false},{"item":"option","value":"5","content":"Того (GMT +00:00)","selected":false},{"item":"option","value":"70","content":"Тонга (GMT +13:00)","selected":false},{"item":"option","value":"182","content":"Тринидад и Тобаго (GMT -04:00)","selected":false},{"item":"option","value":"231","content":"Тувалу (GMT +12:00)","selected":false},{"item":"option","value":"227","content":"Тунис (GMT +01:00)","selected":false},{"item":"option","value":"180","content":"Турция (GMT +03:00)","selected":false},{"item":"option","value":"34","content":"Тёркс и Кайкос (GMT -04:00)","selected":false},{"item":"option","value":"69","content":"Уганда (GMT +03:00)","selected":false},{"item":"option","value":"126","content":"Уругвай (GMT -03:00)","selected":false},{"item":"option","value":"230","content":"Федеративные Штаты Микронезии (GMT +10:00)","selected":false},{"item":"option","value":"14","content":"Фиджи (GMT +12:00)","selected":false},{"item":"option","value":"26","content":"Филиппины (GMT +08:00)","selected":false},{"item":"option","value":"122","content":"Финляндия (GMT +03:00)","selected":false},{"item":"option","value":"108","content":"Фолклендские острова (GMT -04:00)","selected":false},{"item":"option","value":"15","content":"Франция (GMT +02:00)","selected":false},{"item":"option","value":"106","content":"Французская Гвиана (GMT -03:00)","selected":false},{"item":"option","value":"171","content":"Французская Полинезия (GMT -10:00)","selected":false},{"item":"option","value":"2","content":"Хорватия (GMT +02:00)","selected":false},{"item":"option","value":"73","content":"Центрально-Африканская Республика (GMT +01:00)","selected":false},{"item":"option","value":"55","content":"Чад (GMT +01:00)","selected":false},{"item":"option","value":"9","content":"Черногория (GMT +02:00)","selected":false},{"item":"option","value":"172","content":"Чехия (GMT +02:00)","selected":false},{"item":"option","value":"281","content":"Чили, Остров Пасхи (GMT -06:00)","selected":false},{"item":"option","value":"237","content":"Чили, Сантьяго (GMT -04:00)","selected":false},{"item":"option","value":"49","content":"Швейцария (GMT +02:00)","selected":false},{"item":"option","value":"192","content":"Швеция (GMT +02:00)","selected":false},{"item":"option","value":"100","content":"Эквадор (GMT -05:00)","selected":false},{"item":"option","value":"159","content":"Экваториальная Гвинея (GMT +01:00)","selected":false},{"item":"option","value":"129","content":"Эритрея (GMT +03:00)","selected":false},{"item":"option","value":"19","content":"Эстония (GMT +03:00)","selected":false},{"item":"option","value":"104","content":"Эфиопия (GMT +03:00)","selected":false},{"item":"option","value":"82","content":"ЮАР (GMT +02:00)","selected":false},{"item":"option","value":"75","content":"Южная Корея (GMT +09:00)","selected":false},{"item":"option","value":"264","content":"Южный Судан (GMT +03:00)","selected":false},{"item":"option","value":"17","content":"Ямайка (GMT -05:00)","selected":false},{"item":"option","value":"59","content":"Япония (GMT +09:00)","selected":false}]},"regionsData":[{"item":"option","value":"russia","content":"Россия"},{"item":"option","value":"cis","content":"СНГ"},{"item":"option","value":"world","content":"Страны мира"}]}');
    /* jshint ignore:end */

    var data = scope.data;

    function getBlock() {
        var tree = u.getDOMTree({
            block: 'b-time-targeting-timezone',
            mix: [{ block: 'b-time-targeting', elem: 'row' }],
            data: {
                timezoneRegionsData: data.regionsData,
                timezoneData: data.timezoneData,
                timezoneRegionId: 'russia',
                timezoneId: '131',
                timezoneRegionText: '',
                timezoneText: ''
            }
        });

        return $(tree).bem('b-time-targeting-timezone');
    }

    describe('Допустим изначально выбран регион Россия', function() {
        var block;

        beforeEach(function() {
            block = getBlock();
        });

        afterEach(function() {
            BEM.DOM.destruct(block.domElem);
        });

        describe('Если изменить регион', function() {
            it('То должно сработать событие change с первым значением в новом списке временных зон', function(done) {
                block.on('change', function(e, data) {
                    expect(data.id).to.be.equal('278');
                    done();
                });

                block.findBlockInside({ block: 'select', modName: 'name', modVal: 'timezone-regions' }).val('world');
            });

            it('В событии change должны быть поля id, region, text', function(done) {
                block.on('change', function(e, data) {
                    expect(Object.keys(data)).to.deep.equal(['id', 'text', 'region']);
                    done();
                });

                block.findBlockInside({ block: 'select', modName: 'name', modVal: 'timezone-regions' }).val('world');
            });
        });

        describe('Если изменить таймзону', function() {
            it('То должно сработать событие change с данными таймзоны', function(done) {
                block.on('change', function(e, data) {
                    expect(data).to.be.eql({id: '130', text: 'Москва', region: 'russia'});
                    done();
                });
                block.findBlockInside({ block: 'select', modName: 'name', modVal: 'timezone-zones' }).val('130');
            });
        });

        it('Метод setTimezone изменяет значения селектов', function() {
            block.setTimezone('world', '104');

            expect(block.findBlockInside({ block: 'select', modName: 'name', modVal: 'timezone-zones' }).val()).to.equal('104');
            expect(block.findBlockInside({ block: 'select', modName: 'name', modVal: 'timezone-regions' }).val()).to.equal('world');
        })
    });
});
