/**
 * Генерируется событие при клике на псевдоссылки "все" и "рабочее время".
 *
 * @event b-time-targeting-toolbar#selected
 * @param {'all'|'workdays'} value
 */
BEM.DOM.decl({ block: 'b-time-targeting-toolbar' }, {

    /**
     * Измененяет общее значения часов и отображение их валидности
     * @param {Number|String} value
     * @param {Boolean} isValid
     * @private
     */
    setTotalHours: function(value, isValid) {
        this.elem('total-count').text(value);

        this.setMod(this.elem('total'), 'error', isValid ? '' : 'yes');
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'link', function(event) {
            this.trigger('selected', event.target.params.value);
        });
    }

});
