// TODO отделить формирование данных и bemjson
block('b-time-targeting').elem('prepare-data').def()(function() {

    //таймзона для москвы
    var TIMEZONE_ID_MOSCOW = 130,
        TIMEZONE_TEXT_MOSCOW = iget2('b-time-targeting', 'moskva', 'Москва'),
        params = this.ctx.params || {},
        value = params.value || {},
        timeZoneValue = value.timeZone || {},
        holidayShowSettings = value.holidayShowSettings || {},
        holidayShowFrom = holidayShowSettings.showingFrom,
        holidayShowTo = holidayShowSettings.showingTo,
        fullDays = {},
        timezoneId = timeZoneValue.id == 0 ? 0 : (timeZoneValue.id || TIMEZONE_ID_MOSCOW),
        timezoneText = timeZoneValue.text || TIMEZONE_TEXT_MOSCOW,

        selectedGroup,
        clickPriceCodes = {
            b: 10, c: 20, d: 30,
            e: 40, f: 50, g: 60,
            h: 70, i: 80, j: 90,
            k: 100, l: 110, m: 120,
            n: 130, o: 140, p: 150,
            q: 160, r: 170, s: 180,
            t: 190, u: 200
        },
        timezoneGroups = params.timeZoneGroups,
        getHoursOfDay = function(day) {
            if (!day) return {};

            var result = {},
                // Разбиваем на часы
                hours = day.match(/[A-X][a-u]*/g);

            (hours || []).forEach(function(item) {
                var value = item.replace(/[A-X]+/g, '');

                // используем код часа как ключ и кладем туда цену за клик
                result[item.replace(/[a-u]+/g, '')] = value ? clickPriceCodes[value] : 100;
            });

            return result;
        },
        getDayTotalHours = function(day, index) {
            var count = 0;

            for (var key in day) count++;

            // если показы полный день, то кэшируем
            count === 24 && (fullDays[index] = true);

            return count;
        },
        isFullHourLine = function(table, hourCode) {
            for (var i = 0; i < 7; i++)
                if (!table[i][hourCode]) return false;

            return true;
        },
        timeTargetCode = value.timeTargetCode || u['b-time-targeting'].CODE_ALL_TIME,

        timeTargetPreset = value.preset || 'other',

        indexCodeHour = u['b-time-targeting'].FULL_HOUR_CODES,

        data = {
            timeTargetCode: timeTargetCode,
            timeTargetMode: value.isExtendModeOn ? 'extend' : 'simple',

            timezoneId: timezoneId,
            timezoneText: timezoneText,

            timeTargetPreset: timeTargetPreset,

            isExtendedMode: value.isExtendModeOn,

            intoAccountWeekend: value.isWorkingWeekendEnabled,
            intoAccountHolidays: value.isHolidaySettingsEnabled,
            showWorkingWeekendCheckbox: value.showWorkingWeekendCheckbox,

            dontShowOnHolidays: holidayShowSettings.isShowing !== true,
            // необходимость эскейпить значения пришла отсюда https://st.yandex-team.ru/DIRECT-51418
            // и https://st.yandex-team.ru/DIRECT-42032.
            // При этом значение undefined должно превращаться в 8,
            // а значение 0 оставаться 0 (u.escapeHTML(0) -> '')
            holidaysFrom: holidayShowFrom == undefined ? 8 :
                holidayShowFrom === 0 ?
                    0 :
                    u.escapeHTML(holidayShowFrom),
            holidaysTo: holidayShowTo == undefined ? 20 :
                holidayShowTo === 0 ?
                    0 :
                    u.escapeHTML(holidayShowTo),
            holidaysTimeTargetLevel: holidayShowSettings.coefficient || 100
        },

        // Начинаем формировать переменные для таблицы временного таргетинга
        //Разбиваем код на дни
        timeTargetingDays = u['b-time-targeting'].DAYS_ARRAY.map(function(dayNumber) {
            // DIRECT-36289
            // в кодировке тайм таргетинга, если в днях нет отмеченных часов, может отсутствовать код дня
            // https://st.yandex-team.ru/DIRECT-36289#1414839702000
            return (timeTargetCode.match(new RegExp(dayNumber + '\\D*')) || [])[0];
        }),

        timeTargetTable = [],
        totalHours = 0,
        dayElems = [],
        hoursControls = [],
        timeTargetingModelData = {
            mode: data.timeTargetMode
        };

    if (!params.isExtendModeAvailable) {
        timeTargetingModelData = u._.extend(timeTargetingModelData, { noExtend: true, brushLevel: 100 });
    }

    for (var i = 0; i < 7; i++) {
        var day = getHoursOfDay(timeTargetingDays[i]);

        // считаем кол-во рабочих часов
        i < 5 && (totalHours = totalHours + getDayTotalHours(day));

        // строим граф
        timeTargetTable[i] = day;

        // строим контент для таблицы временного таргетинга
        dayElems.push({
            elem: 'day',
            elemMods: { index: i },
            label: u['b-time-targeting'].INDEX_WEEKDAY_LABELS[i],
            value: day,
            isFull: fullDays[i] || getDayTotalHours(day) === 24
        });
    }

    // генерируем контент для контролов управления часами
    for (var i = 0; i < 24; i++) {
        hoursControls.push({
            elem: 'hour-checkbox',
            elemMods: { code: indexCodeHour[i] },
            content: {
                block: 'checkbox',
                mods: {
                    theme: 'normal',
                    size: 's',
                    checked: isFullHourLine(timeTargetTable, indexCodeHour[i]) ? 'yes' : ''
                },
                js: { code: indexCodeHour[i] } }
        });
    }

    // prepare data for timezones
    var timezoneData = {},
        timezoneRegionsData = [];

    (timezoneGroups || []).forEach(function(item) {
        (item.timezones || []).forEach(function(zone) {
            //Не показываем Магаданскую таймзону для тех, у кого она не установлена DIRECT-35586
            if (zone.id == 140 && timezoneId != 140) return;

            !timezoneData[zone.group_nick] && (timezoneData[zone.group_nick] = []);

            timezoneData[zone.group_nick].push({
                item: 'option',
                value: zone.id,
                content: zone.name,
                selected: zone.id == data.timezoneId
            });

            zone.id == data.timezoneId && (selectedGroup = zone.group_nick);
        }, this);

        timezoneRegionsData.push({
            item: 'option',
            value: item.nick,
            content: item.name
        });

        item.nick === selectedGroup && (data.timezoneRegionText = item.name);
    }, this);

    data.timezoneRegionId = selectedGroup;

    data.timeTargetTable = timeTargetTable;
    data.totalHours = totalHours;
    data.dayElems = dayElems;
    data.hoursControls = hoursControls;

    timeTargetingModelData = u._.extend(
        timeTargetingModelData,
        u._.pick(data, [
            'intoAccountWeekend',
            'intoAccountHolidays',
            'dontShowOnHolidays',
            'holidaysFrom',
            'holidaysTo',
            'holidaysTimeTargetLevel',
            'timeTargetPreset',
            'timeTargetCode',
            //таймзоны
            'timezoneRegionText',
            'timezoneId',
            'timezoneText',
            'timezoneRegionId',

            'timeTargetTable'
        ]));

    data._timeTargetingModelData = timeTargetingModelData;

    data.timezoneRegionsData = timezoneRegionsData;
    data.timezoneData = timezoneData;

    return data;
});
