block('b-time-targeting')(

    def()(function() {
        var data = applyCtx({
            block: 'b-time-targeting',
            elem: 'prepare-data',
            params: this.ctx.params || {}
        });

        return applyNext({
            _data: data,
            // Если preset не задан (задается только для легкого интерфейса) - устанавливаем `other` (с таблицей времени)
            'mods.preset': this.mods.preset || 'other'
        });
    }),

    js()(function() {
        return {
            modelParams: {
                name: 'b-time-targeting',
                data: this._data._timeTargetingModelData
            },
            _data: this._data
        };
    }),

    elem('holidays')(
        mix()(function() {
            return { elem: 'row' };
        }),

        content()(function() {
            return {
                block: 'b-time-targeting-holidays',
                data: this._data
            };
        })
    ),

    elem('timezone').content()(function() {
        return {
            block: 'b-time-targeting-timezone',
            data: this._data
        };
    }),

    elem('board-controls')(
        mix()(function() {
            return {
                elem: 'row',
                elemMods: { type: 'wrap' }
            };
        }),

        content()(function() {
            return [
                {
                    elem: 'row',
                    elemMods: { type: 'mode-switcher' },
                    content: [
                        {
                            block: 'b-time-targeting-scale',
                            elem: 'title'
                        },
                        {
                            block: 'tumbler',
                            mods: { size: 's', theme: 'normal' },
                            mix: [{ block: 'b-time-targeting', elem: 'mode-switcher' }]
                        }
                    ]
                },
                {
                    block: 'b-time-targeting-scale',
                    mods: { type: 'slider' }
                },
                {
                    block: 'b-time-targeting-toolbar',
                    mix: [{ block: 'b-time-targeting', elem: 'row' }],
                    value: this._data.totalHours
                },
                {
                    block: 'b-time-targeting-scale-board',
                    mods: { type: 'simple' },
                    mix: [{ block: 'b-time-targeting', elem: 'row' }],
                    hoursControls: this._data.hoursControls,
                    content: this._data.dayElems
                }
            ];
        })
    ),

    elem('help-text')(
        content()(function() {
            return iget2('b-time-targeting', 'pokazy-dolzhny-byt-razresheny', 'Показы должны быть разрешены не менее 40 часов в рабочие дни');
        })
    )

);






