(function() {
    var CODE_FULL_DAY = 'ABCDEFGHIJKLMNOPQRSTUVWX',

        CODE_WORK_DAY = 'IJKLMNOPQRST',

        DAYS_ARRAY = [1, 2, 3, 4, 5, 6, 7],

        DAYS_WORK_ARRAY = [1, 2, 3, 4, 5],

        CODE_ALL_TIME = DAYS_ARRAY.map(function(day) {
            return day + CODE_FULL_DAY;
        }).join(''),

        CODE_WORK_TIME = DAYS_WORK_ARRAY.map(function(day) {
            return day + CODE_WORK_DAY;
        }).join(''),

        FULL_HOUR_CODES = CODE_FULL_DAY.split(''),

        WORK_HOUR_CODES = CODE_WORK_DAY.split(''),

        INDEX_WEEKDAY = [iget2('b-time-targeting', 'pn', 'ПН.'), iget2('b-time-targeting', 'vt', 'ВТ.'), iget2('b-time-targeting', 'sr', 'СР.'), iget2('b-time-targeting', 'cht', 'ЧТ.'), iget2('b-time-targeting', 'pt', 'ПТ.'), iget2('b-time-targeting', 'sb', 'СБ.'), iget2('b-time-targeting', 'vs', 'ВС.')],

        INDEX_WEEKDAY_LABELS = [
            iget2('b-time-targeting', 'pn-117', 'ПН'), iget2('b-time-targeting', 'vt-118', 'ВТ'), iget2('b-time-targeting', 'sr-119', 'СР'), iget2('b-time-targeting', 'cht-120', 'ЧТ'), iget2('b-time-targeting', 'pt-121', 'ПТ'), iget2('b-time-targeting', 'sb-122', 'СБ'), iget2('b-time-targeting', 'vs-123', 'ВС')
        ],

        LEVEL_CODES = { 10: 'b', 20: 'c', 30: 'd', 40: 'e', 50: 'f', 60: 'g', 70: 'h', 80: 'i', 90: 'j', 100: 'k' ,
            110: 'l', 120: 'm', 130: 'n', 140: 'o', 150: 'p', 160: 'q', 170: 'r', 180: 's', 190: 't', 200: 'u' };

    u.register({
        'b-time-targeting': {
            /**
             * Возвращает значение часов отформатированное для вывода, в виде HH:mm
             * @param {Number} hour
             * @returns {String}
             */
            getFormattedHours: function(hour) {
                return hour != 24 ?
                    u.moment().minutes(0).hour(hour).format('HH:mm') :
                    '24:00';
            },

            /**
             * Приводит строку временного таргетинга к хэшу
             * возвращает массив объектов вида { day: dayNumber, hours: code }
             * где dayNumber - номер дня недели
             * code - код часов в сутках в записи timetargetCode (A - с 00 до 01 часов, B - с 01 до 02 часов и т.п.)
             * @param {String} value
             * @returns {{ day: Number, hours: String }[]}
             */
            parseFromCode: function(value) {
                var days = value.match(/(?:\d)([A-Za-z]+)?/g),
                    hours,
                    res = [];

                for (var i = 0; i < days.length; i++) {
                    // убираем числа и строчные буквы - они обозначают коэффициент суток, а не час
                    hours = days[i].replace(/\d/g, '').replace(/[a-z]/g, '');
                    res.push({ day: i + 1, hours: hours });
                }

                return res;
            },

            /**
             * Преобразует хэш в строку временного таргетинга
             * @param {{ dayFrom: Number, dayTo: Number, hourFrom: Number, hourTo: Number }} data
             * @returns {String}
             * @private
             */
            parseToCode: function(data) {
                var value = '';

                DAYS_ARRAY.forEach(function(day) {
                    value += day;

                    if (day >= data.dayFrom && day <= data.dayTo) {
                        for (var j = data.hourFrom; j < data.hourTo; j++) {
                            value += FULL_HOUR_CODES[j];
                        }
                    }
                });

                return value;
            },

            CODE_ALL_TIME: CODE_ALL_TIME,

            CODE_WORK_TIME: CODE_WORK_TIME,

            FULL_HOUR_CODES: FULL_HOUR_CODES,

            WORK_HOUR_CODES: WORK_HOUR_CODES,

            INDEX_WEEKDAY: INDEX_WEEKDAY,

            INDEX_WEEKDAY_LABELS: INDEX_WEEKDAY_LABELS,

            DAYS_ARRAY: DAYS_ARRAY,

            LEVEL_CODES: LEVEL_CODES
        }
    });

})();
