BEM.MODEL.decl('b-time-targeting', {

    timezoneId: 'string',

    timezoneText: 'string',

    timezoneRegionId: 'string',

    timezoneRegionText: 'string',

    mode: {
        type: 'string',
        'default': 'simple'
    },

    noExtend: {
        type: 'boolean',
        'default': false
    },

    brushLevel: {
        type: 'number',
        'default': 100
    },

    intoAccountWeekend: {
        type: 'boolean',
        'default': false
    },

    intoAccountHolidays: {
        type: 'boolean',
        'default': false
    },

    dontShowOnHolidays: {
        type: 'boolean',
        'default': false
    },

    holidaysFrom: {
        type: 'number',
        'default': 8
    },

    holidaysTo: {
        type: 'number',
        'default': 20
    },

    holidaysTimeTargetLevel: {
        type: 'number',
        'default': 100
    },

    timeTargetPreset: 'string',

    timeTargetCode: 'string',

    timeTargetTable: {
        type: 'data-table',
        internal: true
    },

    totalHours: { // сумма часов в рабочие дни
        type: 'number',
        dependsFrom: ['timeTargetTable', 'timeTargetCode'],
        calculate: function() {
            var hash,
                count = 0;

            if (this.get('timeTargetPreset') === 'other') {
                this.get('timeTargetTable').fullScan(function(cell, value) {
                    if (cell[0] > 4) return true;

                    value && count++;
                });
            } else {
                var days = u['b-time-targeting'].parseFromCode(this.get('timeTargetCode'));
                count = days.reduce(function(res, value) {
                    if (value.day < 6) {
                        res += value.hours.length;
                    }

                    return res;
                }, 0);
            }

            return count;
        },
        format: function() {
            return this._raw.toString()
        },
        validation: {
            rules: {
                lte: {
                    value: 40,
                    text: iget2('b-time-targeting', 'kampaniya-dolzhna-byt-vklyuchena', 'Кампания должна быть включена не менее 40 часов в рабочие дни')
                }
            }
        }
    }

});
