/**
 * @param {String|BEMHTML} message сообщение окна подтверждения
 * @param {String} [confrimButtonText] текст кнопки подтврждения
 * @param {String} [cancelButtonText] текст кнопки отмены
 **/
block('b-user-dialog')(
    def()(function() {

        return applyCtx({
            block: 'popup',
            mods: {
                type: 'modal',
                position: 'fixed',
                autoclosable: 'no',
                'body-scroll': 'no'
            },
            mix: {
                block: 'b-user-dialog',
                js: {
                    isAlert: this.ctx.isAlert
                }
            },
            underMods: {
                type: 'paranja'
            },
            content: [{
                elem: 'content',
                mix: {
                    block: 'b-user-dialog',
                    elem: 'content'
                },
                content: [
                    {
                        block: 'b-user-dialog',
                        elem: 'body',
                        content: this.ctx.message
                    },
                    {
                        block: 'b-user-dialog',
                        elem: 'footer',
                        content: [
                            !this.ctx.isAlert && {
                                block: 'button',
                                mods: { size: 's', theme: 'action' },
                                mix: [
                                    {
                                        block: 'b-user-dialog',
                                        elem: 'button'
                                    },
                                    {
                                        block: 'b-user-dialog',
                                        elem: 'confirm'
                                    }
                                ],
                                content: this.ctx.confrimButtonText || iget2('b-user-dialog', 'da', 'Да')
                            },
                            {
                                block: 'button',
                                mods: { size: 's' },
                                mix: [
                                    {
                                        block: 'b-user-dialog',
                                        elem: 'button'
                                    },
                                    {
                                        block: 'b-user-dialog',
                                        elem: 'cancel'
                                    }
                                ],
                                content: this.ctx.cancelButtonText || (this.ctx.isAlert ? iget2('b-user-dialog', 'zakryt', 'Закрыть') : iget2('b-user-dialog', 'net', 'Нет'))
                            }
                        ]
                    }
                ]
            }]
        });
    })
);
