BEM.DOM.decl('b-user-dialog', {
    onSetMod: {

        js: function() {
            this._confirmButton = this.findBlockOn('confirm', 'button');
            this._cancelButton = this.findBlockOn('cancel', 'button');

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._subscriptionManager.on(this._cancelButton, 'click', function () {
                this._applyAction('_onCancel');
            }, this);

            this._confirmButton && this._subscriptionManager.on(this._confirmButton, 'click', function () {
                this._applyAction('_onConfirm');
            }, this);
        }
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Инициализирует попап
     * @param {BEM.DOM<popup>} [parentPopup] родительский попап
     * @param {Object} [callbackCtx] контекст вызова обработчиков Отмены и Подтверждения действия
     * @param {Function} [onConfirm] - обработчик события нажатия на кнопку Подтверждения
     * @param {Function} [onCancel] - обработчик события нажатия на кнопку Отмены
     */
    _initialize: function(options) {
        this._parentPopup = options.parentPopup;
        this._callbackCtx = options.callbackCtx;
        this._onConfirm = options.onConfirm;
        this._onCancel = options.onCancel;
    },

    /**
     * Применяет действие для кнопки
     * @param {'onCancel'|'onConfirm'} type тип кнопки
     */
    _applyAction: function(type) {
        var action = this[type];

        $.isFunction(action) && action.apply(this._ctx || this._callbackCtx);

        this._isButtonHideEvent = true;
        this._getPopup().hide();
    },

    /**
     * Показывает диалоговое окно
     * @returns {BEM.DOM<b-user-dialog>}
     */
    _show: function() {
        this._getPopup().show();

        return this;
    },

    /**
     * Возвращает блок попапа
     * @returns {BEM.DOM<popup>}
     */
    _getPopup: function() {
        var isAlert = this.params.isAlert;

        if (!this._popup) {
            this._popup = this.findBlockOn('popup')
                .on('show', function() {
                    var buttonToFocus = isAlert ? this._cancelButton : this._confirmButton;

                    //Хромиум ускоряет обработку click-ивентов, в результате событие фокус отрабатывает
                    // (ставится модификатор), но не ставится хромовый innerstyle.
                    // Хром считает это фичей, сообщество - багой и придумало вот такой воркэраунд
                    setTimeout(function() { buttonToFocus.setMod('focused', 'yes'); }, 100);
                }, this)
                .on('before-hide', function(e) {
                    // нажатие на кнопку Esc может закрывать только диалоговое окно нотификации
                    !isAlert && !this._isButtonHideEvent && e.preventDefault();
                }, this)
                .on('hide', function() {
                    this.destruct();
                }, this);

            this._parentPopup && this._popup.setParent(this._parentPopup);
        }

        return this._popup;
    }
}, {
    /**
     * Создаёт блок диалогового окна и открывает его
     * @param {Object|String} [options] параметры
     * @param {Boolean} [isAlert] параметры
     * @returns {BEM.DOM<b-user-dialog>}
     */
    _showDialog: function(options, isAlert) {
        var options = typeof(options) === 'string' ? {
                message: options
            } : options,
            blockJson = u._.assign({
                block: 'b-user-dialog',
                isAlert: isAlert
            }, options),
            dialog = $(BEMHTML.apply(blockJson)).bem('b-user-dialog');

        dialog._initialize({
            parentPopup: options.parentPopup,
            callbackCtx: options.callbackCtx,
            onConfirm: options.onConfirm,
            onCancel: options.onCancel
        });

        dialog._show();

        return dialog;
    },

    /**
     * Создаёт блок окна подтверждения и открывает его
     * @param {Object|String} [options] параметры
     * @param {String|BEMHTML} options.message сообщение окна подтверждения
     * @param {String} [options.confrimButtonText] текст кнопки подтврждения
     * @param {String} [options.cancelButtonText] текст кнопки отмены
     * @param {Object} [callbackCtx] контекст вызова обработчиков Отмены и Подтверждения действия
     * @param {Function} [onConfirm] обработчик события нажатия на кнопку Подтверждения
     * @param {Function} [onCancel] бработчик события нажатия на кнопку Отмены
     * @param {Object} [parentPopup] попап из которого вызвано диалоговое окно
     * @returns {BEM.DOM<b-user-dialog>}
     */
    confirm: function(options) {

        return this._showDialog(options);
    },

    /**
     * Создаёт блок окна нотификации и открывает его
     * @param {Object} [options] параметры
     * @param {String|BEMHTML} options.message сообщение окна нотификации
     * @param {String} [options.cancelButtonText] текст кнопки отмены
     * @param {Object} [callbackCtx] контекст вызова обработчика Отмены действия
     * @param {Function} [onCancel] бработчик события нажатия на кнопку Отмены
     * @returns {BEM.DOM<b-user-dialog>}
     */
    alert: function(options) {

        return this._showDialog(options, true);
    }
});
