block('banner-image-crop').mod('type', 'multi')(

    def()(function() {
        var types = this.ctx.types || [],
            typeToControls = apply('typeToControls'),
            // Заголовки берем от типа кампаний type=text
            ratioToTitle = typeToControls.text.reduce(function(ratioToTitle, control) {
                ratioToTitle[control.value] = control.text;
                return ratioToTitle;
            }, {}),
            // Определяем все возможные соотношения сторон для разных типов кампаний
            allRatios = u._.chain(typeToControls)
                .reduce(function(controls, typeControls) {
                    return u._.uniq(controls.concat(u._.map(typeControls, 'value')));
                }, [])
                .sortBy(function(ratio) {
                    return parseInt(ratio);
                })
                .value(),
            // Определяем соотношения сторон доступные для переданных кампаний
            availableRatios = u._.chain(types)
                .map(function(type) {
                    return _.map(typeToControls[type], 'value');
                })
                .thru(function(typesControls) {
                    return u._.intersection.apply(u._, typesControls);
                })
                .value();

        return applyNext({
            controls: allRatios.reduce(function(controls, ratio) {
                controls.push({
                    value: ratio,
                    text: ratioToTitle[ratio] || ratio,
                    disabled: !u._.includes(availableRatios, ratio)
                });

                return controls;
            }, []),
            isMobileContent: u._.includes(types, 'mobile-content')
        });
    })

);
