block('banner-image-crop')(

    js()(function() {
        return {
            isMobileContent: this.isMobileContent,
            availableRatios: u._.map(this.controls, 'value')
        };
    }),

    mode('typeToControls')(function() {
        return {
            'mobile-content': [
                { value: '16:9', text: '16:9' }
            ],
            'text': [
                { value: '0', text: iget2('banner-image-crop', 'standartnoe-izobrazhenie', 'Стандартное изображение') },
                { value: '16:9', text: iget2('banner-image-crop', 'shirokoformatnoe-16-9', 'Широкоформатное (16:9)') }
            ]
        };
    }),

    content()(function() {
        return [
            u._.size(this.controls) > 1 && {
                elem: 'aspect-ratio',
                controls: this.controls
            },
            { elem: 'editor' }
        ];
    }),

    elem('aspect-ratio').def()(function() {
        return applyCtx({
            block: 'radio-button',
            name: 'aspect-ratio',
            value: '0',
            mix: [{ block: 'banner-image-crop', elem: 'aspect-ratio' }],
            content: u._.map(this.ctx.controls, function(button) {
                // значения должны иметь вид 'w:h'(коэффициенты по ширине и высоте, разделенные двоеточием) или === '0'
                return {
                    elem: 'radio',
                    elemMods: { disabled: button.disabled  ? 'yes' : '' },
                    controlAttrs: { value: button.value, autocomplete: 'off' } ,
                    content: button.text
                };
            })
        });
    }),

    elem('editor').content()(function() {
        return {
            block: 'image',
            mix: [{ block: 'banner-image-crop', elem: 'image' }],
            url: ''
        };
    })

);
