/**
 * @requires BEM
 */
(function(BEM, $, undefined) {
var win = $(window);

BEM.decl('i-bem__dom', {
    /* https://github.yandex-team.ru/lego/islands/pull/3648 */
    bindToWin: function(event, data, fn) {
        if($.isFunction(data)) {
            fn = data;
            data = undefined;
        }

        var _fn = fn,
            currentDoubleHeight,
            currentDoubleWidth;

        if(event === 'resize') {
            fn = function() {
                // https://st.yandex-team.ru/ISL-3464
                // Свойств window.innerWidth/innerHeight нет для IE8-
                var newDoubleHeight = window.innerHeight | 0 + win.outerHeight(),
                    newDoubleWidth = window.innerWidth | 0 + win.outerWidth();

                if(currentDoubleWidth !== newDoubleWidth || currentDoubleHeight !== newDoubleHeight) {
                    currentDoubleHeight = newDoubleHeight;
                    currentDoubleWidth = newDoubleWidth;

                    _fn.apply(this, arguments);
                }
            };
            fn.guid = _fn.guid = _fn.guid || $.guid++;
        }

        this._needSpecialUnbind = true;

        return this.bindToDomElem(win, event, data, fn);
    }
});
})(BEM, jQuery);
