(function(BEM, $, undefined) {

    $.inheritSelf(BEM.DOM, {

        /**
         * Возвращает первый блок на элементе, реализующий интерфейс
         * @param {String|jQuery} [elem] Элемент блока
         * @param {String} interfaceName Интерфейс
         * @returns {BEM}
         */
        findBlockByInterfaceOn: function(elem, interfaceName) {
            return this._findBlocksByInterface('findBlockOn', elem, interfaceName, true);
        },

        /**
         * Возвращает блоки на элементе, реализующие интерфейс
         * @param {String|jQuery} [elem] Элемент блока
         * @param {String} interfaceName Интерфейс
         * @returns {BEM[]}
         */
        findBlocksByInterfaceOn: function(elem, interfaceName) {
            return this._findBlocksByInterface('findBlocksOn', elem, interfaceName);
        },

        /**
         * Возвращает первый блок внутри элемента(блока), реализующий интерфейс
         * @param {String|jQuery} [elem] Элемент блока
         * @param {String} interfaceName Интерфейс
         * @returns {BEM}
         */
        findBlockByInterfaceInside: function(elem, interfaceName) {
            return this._findBlocksByInterface('findBlockInside', elem, interfaceName, true);
        },

        /**
         * Возвращает блоки на элементе, реализующие интерфейс
         * @param {String|jQuery} [elem] Элемент блока
         * @param {String} interfaceName Интерфейс
         * @returns {BEM[]}
         */
        findBlocksByInterfaceInside: function(elem, interfaceName) {
            return this._findBlocksByInterface('findBlocksInside', elem, interfaceName);
        },

        /**
         * Возвращает найденные блок(и), реализующие(ий) интерфейс
         * @param {String} findMethod Метод поиска
         * @param {String|jQuery} [elem] Элемент блока
         * @param {String} interfaceName Интерфейс
         * @param {Boolean} onlyFirst
         * @returns {BEM[]}
         * @private
         */
        _findBlocksByInterface: function(findMethod, elem, interfaceName, onlyFirst) {
            if (!interfaceName) {
                interfaceName = elem;
                elem = null;
            }

            var res = BEM.INTERFACE.findBlocksByInterface(interfaceName, this, findMethod, elem);

            return onlyFirst ? res[0] : res;
        }

    },
    {
        /**
         * Декларация i-bem блока, поддерживающего интерфейсы
         * @param {Object} decl декларация
         * @param {Array|String} [decl.implements] список интерфейсов, реализуемых блоком
         * @param {Object} [props] поля блока
         * @param {Object} [staticProps] статические поля блока
         * @returns {Object} конструктор блока
         */
        decl: function(decl, props, staticProps) {
            var block = this.__base.apply(this, arguments),
                imps = decl.implements ?
                    $.isArray(decl.implements) ? decl.implements : [decl.implements] :
                    [];

            imps.forEach(function(imp) {
                BEM.INTERFACE.implements(imp, block.getName(), function(method) {
                    return block.prototype[method] && typeof block.prototype[method] === 'function';
                });
            });

            return block;
        }
    });

})(BEM, jQuery);


