(function(BEM, $) {

    var interfaces = {};

    /**
     * Набор статических методов для реализации интерфейсов в i-bem
     * @type {{decl: Function, implements: Function, findBlocksByInterface: Function}}
     */

    BEM.INTERFACE = {

        /**
         * Декларация интерфейса
         * @param {String} name идентификатор интерфейса
         * @param {Array} methods массив методов
         */
        decl: function(name, methods) {
            interfaces[name] = {
                methods: methods,
                blocks: []
            };
        },

        /**
         * Регистрирует блок, реализующий интерфейс
         * @param {String} name идентификатор интерфейса
         * @param {String} blockName имя блока
         * @param {Function} checkProp функция проверки наличия полей
         */
        implements: function(name, blockName, checkProp) {
            var intf = interfaces[name];

            if (!intf) throw new Error('Unknown interface ' + name);

            intf.methods.forEach(function(method) {
                if (!checkProp(method)) {
                    throw new Error(blockName + ' must implemented ' + method + ' of ' + name);
                }
            });

            intf.blocks.push(blockName);
        },

        /**
         * Возвращает массив найденных блоков, реализующих интерфейс
         * @param {String} name идентификатор интерфейса
         * @param {BEM} block инстанс блока
         * @param {String} findMethod метод поиска
         * @param {String|jQuery} [elem] элемент блока
         * @returns {BEM[]}
         */
        findBlocksByInterface: function(name, block, findMethod, elem) {
            var intf = interfaces[name],
                res = [];

            if (!intf) throw new Error('Unknown interface ' + name);

            intf.blocks.forEach(function(iBlock) {
                var searchResult = block[findMethod].apply(block, elem ? [elem, iBlock] : [iBlock]);

                if (searchResult) {
                    res = res.concat(searchResult);
                }
            });

            return res;
        }

    }

})(BEM, jQuery);

