/**
 * @property {String} [this.ctx.name] Имя инпута для загрузки изображения
 * @property {String[]} [this.ctx.mimeTypes] Список MIME-типов
 */
block('i-local-file-uploader')(

    tag()('input'),

    attrs()(function() {
        var ctx = this.ctx,
            attrs = {
                type: 'file',
                // cyn@: Было предположение, что без атрибута `name` в каких-нибудь браузерах может не работать,
                // проверять не стал, на всякий случай, добавил генерацию уникального
                name: ctx.name || ('flie-' + this.generateId())
            };

        if (ctx.mimeTypes) {
            attrs.accept = ctx.mimeTypes.join(',');
        }

        if (ctx.multiple) {
            attrs.multiple = 'multiple';
        }

        return attrs;
    })

);
