/**
 * @event i-local-file-uploader#select
 * @type {Object}
 * @property {Object} blob объект загруженного файла (https://developer.mozilla.org/ru/docs/Web/API/File)
 *
 * @fires i-local-file-uploader#select событие выбор в диалоговом окне файла для загрузки
 */
BEM.decl('i-local-file-uploader', {
    onSetMod: {
        js: {
            inited: function() {
                var params = this.params;

                this._fileControl = BEM.DOM.append(BEM.DOM.scope, BEMHTML.apply({
                    block: 'i-local-file-uploader',
                    name: params.name,
                    mimeTypes: params.mimeTypes,
                    multiple: params.multiple
                }));

                this._fileControl.on('change', function() {
                    this.trigger('select', { blob: this._fileControl[0] });
                }.bind(this));
            }
        }
    },

    /**
     * Открывает диалоговое окно выбора файла
     */
    openFileDialog: function() {
        // чтобы событие change генерировалось для всех браузеров даже,
        // если мы выбрали тот же файл, что и в прошлый раз
        this._fileControl.val('');

        this._fileControl[0].click();
    },

    /**
     * Проверка св-ва multiple
     * @returns {Boolean}
     */
    isMultiple: function() {
        return Boolean(this._fileControl.prop('multiple'));
    },

    /**
     * Устанавливает св-во multiple
     * @param {Boolean} multiple
     */
    setMultiple: function(multiple) {
        this._fileControl.prop('multiple', multiple);
    },

    destruct: function() {
        this._fileControl.un('change');
        BEM.DOM.destruct(this._fileControl);

        this.__base.apply(this, arguments);
    }
});
