describe('i-subscription-manager', function() {
    it('on() должен осуществлять подписку', function() {
        var subscriptionManager = BEM.create('i-subscription-manager'),
            emitter = new $.observable(),
            callback = sinon.spy();

        subscriptionManager.on(emitter, 'event', callback);

        emitter.trigger('event');

        expect(callback.called).to.be.equal(true);
    });

    it('dispose() должен уничтожать подписки', function() {
        var subscriptionManager = BEM.create('i-subscription-manager'),
            emitter = new $.observable(),
            emitter2 = new $.observable(),
            callback = sinon.spy();

        subscriptionManager.on(emitter, 'event', callback);
        subscriptionManager.on(emitter, 'event2', callback);
        subscriptionManager.on(emitter2, 'event', callback);

        subscriptionManager.dispose();

        emitter.trigger('event');
        emitter.trigger('event2');
        emitter2.trigger('event');

        expect(callback.called).to.be.equal(false);
    });

    it('wrap() должен возвращать observable с отслеживаемыми подписками', function() {
        var subscriptionManager = BEM.create('i-subscription-manager'),
            emitter = new $.observable(),
            callback = sinon.spy(),
            notifyingEmitter = subscriptionManager.wrap(emitter);

        notifyingEmitter
            .on('event1', callback)
            .on('event2', callback);

        emitter.trigger('event1');
        emitter.trigger('event2');

        expect(callback.callCount).to.be.equal(2);
    });

    it('dispose() должен уничтожать подписки всех объектов с отслеживаемыми подписками', function() {
        var subscriptionManager = BEM.create('i-subscription-manager'),
            emitter1 = new $.observable(),
            emitter2 = new $.observable(),
            notifyingEmitter1 = subscriptionManager.wrap(emitter1),
            notifyingEmitter2 = subscriptionManager.wrap(emitter2),
            callback = sinon.spy();

        notifyingEmitter1
            .on('event1', callback)
            .on('event2', callback);

        notifyingEmitter2
            .on('event1', callback)
            .on('event2', callback);

        subscriptionManager.dispose();

        emitter1.trigger('event1');
        emitter1.trigger('event2');
        emitter2.trigger('event1');
        emitter2.trigger('event2');

        expect(callback.called).to.be.equal(false);
    });
});
