(function($) {

    var maxSuggestCount = 15;

    BEM.decl('i-suggest-dataprovider', {

        /**
         * Инициализация списка для саджеста
         * @param {*} suggestList
         */
        init: function(suggestList) {
            this.items = suggestList;
        },

        /**
         * Поиск подходящих значение
         * @param {String} val Искомая строка
         * @param {Function} onSuccess Функция обработки результата
         */
        get: function(val, onSuccess) {
            if (!val || !this.items) {
                onSuccess([]);

                return;
            }

            var result = [];

            this.items.forEach(function(item) {
                u.text.suggestMatch(item, val) && result.length <= maxSuggestCount && result.push(item);
            });

            onSuccess(result);
        }

    });
})(jQuery);
