describe('i-suggest-dataprovider', function() {
    var bemjson = {
            block:  'i-suggest-dataprovider'
        },
        searchOptions = [
            'Алушта',
            'Евпатория',
            'Севастополь',
            'Симферополь',
            'Ялта',
            'алярм',
            'Судак',
            'гора Чатыр-Даг'
        ],
        suggestDataprovider,
        spy,
        sandbox;


    beforeEach(function() {
        sandbox = sinon.sandbox.create({ useFakeTimers: true });

        suggestDataprovider = u.createBlock(bemjson);

        spy = sandbox.spy(function() {});
    });

    afterEach(function() {
        suggestDataprovider.destruct();
        sandbox.restore();
    });

    it('При инициализации заполняется список саджеста', function() {
        suggestDataprovider.init(['a', 'b', 'c']);
        expect(suggestDataprovider.items).to.eql(['a', 'b', 'c']);
    });

    describe('Поиск подходящих значений', function() {

        it('При отсутствии списка саджеста нет ошибки', function() {
            suggestDataprovider.get('Что-нибудь', spy);
            sandbox.clock.tick(1);
            expect(spy.lastCall.calledWith([])).to.be.true;
        });

        it('Не найдено ничего', function() {
            suggestDataprovider.init(searchOptions);
            suggestDataprovider.get('Б', spy);
            sandbox.clock.tick(1);
            expect(spy.lastCall.calledWith([])).to.be.true;
        });

        it('Найдено одно значение', function() {
            suggestDataprovider.init(searchOptions);
            suggestDataprovider.get('Я', spy);
            sandbox.clock.tick(1);
            expect(spy.lastCall.calledWith(['Ялта'])).to.be.true;
        });

        it('Найден массив значений', function() {
            suggestDataprovider.init(searchOptions);
            suggestDataprovider.get('С', spy);
            sandbox.clock.tick(1);
            expect(spy.lastCall.calledWith(['Севастополь', 'Симферополь', 'Судак'])).to.be.true;
        });

        it('Найден массив значений (при поиске строчных букв учитываются и прописные, но не наоборот)', function() {
            suggestDataprovider.init(searchOptions);
            suggestDataprovider.get('ал', spy);
            sandbox.clock.tick(1);
            expect(spy.lastCall.calledWith(['Алушта', 'алярм'])).to.be.true;
        });

        it('По каждому слову', function() {
            suggestDataprovider.init(searchOptions);
            suggestDataprovider.get('Чатыр', spy);
            sandbox.clock.tick(1);
            expect(spy.lastCall.calledWith(['гора Чатыр-Даг'])).to.be.true;
        });

        it('По каждому слову, через дефис', function() {
            suggestDataprovider.init(searchOptions);
            suggestDataprovider.get('Даг', spy);
            sandbox.clock.tick(1);
            expect(spy.lastCall.calledWith(['гора Чатыр-Даг'])).to.be.true;
        });
    });
});
