(function() {
    u.register({
        /**
         * @param {Array} data - массив элементов
         * @param {Object} params
         *  @param {Number} [data.size] - максимольное количество элементов в chunk
         *  @param {Number} [data.delay] - задержка
         * @param {Function} handler - обработчик каждого chunk
         * @param {Object} [ctx] - контекст для callback и handler
         * @returns {Object}
         */
        forEachByChunks: function(data, params, handler, ctx) {
            if (u._.isObject(params)) {
                params = $.extend({ size: this._chunkDelay, delay: this._chunkDelay }, params);
            } else {
                ctx = handler || this;
                handler = params;
            }

            return {
                /**
                 * Текущий таймер
                 */
                current: null,

                /**
                 * Задержка
                 */
                delay: params.delay,

                /**
                 * Максимольное количество элементов в chunk
                 */
                size: params.size,

                /**
                 * обработчик каждого chunk
                 */
                handler: handler,

                /**
                 * контекст для callback и handler
                 */
                ctx: ctx,

                /**
                 * Массив элементов
                 */
                chunks: u._.chunk(data, params.size),

                /**
                 * Счетчик
                 */
                counter: 0,

                /**
                 * Обрабатывает большие массивы по частям
                 * @returns {Number}
                 */
                start: function() {
                    var deferred = $.Deferred(),
                        timeoutHandler;

                    /**
                     * @param {Object} timer - текущий процесс
                     */
                    timeoutHandler = function(timer) {
                        if (timer.counter < timer.chunks.length) {
                            timer.chunks[timer.counter]
                                .forEach(function(item, index) {
                                    timer.handler.call(timer.ctx, item, timer.counter * timer.size + index, timer);
                                });

                            timer.counter++;
                            timer.current = setTimeout(function() { timeoutHandler(timer) }, timer.delay);
                        } else {
                            deferred.resolveWith(timer.ctx);
                        }
                    };

                    timeoutHandler(this);

                    return deferred.promise();
                },

                /**
                 * Останавливает текущий процесс
                 */
                stop: function() {
                    this.current && clearTimeout(this.current);
                }
            }
        }
    });
})();
