(function() {
    u.register({
        /**
         * Возвращает случайно выбранный элемент массива
         * @param {Array} array
         * @returns {*}
         */
        pickRandom: function(array) {
            return array[u._.random(0, array.length - 1)];
        },

        /**
         * Разделяет массив строк или bemjson-объектов символами
         * ложные элементы отсеивает
         * @param {Array} arr Изначальный массив
         * @param {String} [space] разделяющая строка
         * @returns {Array}
         */
        spacer2: function(arr, space) {
            return arr.reduce(function(result, elem) {
                elem && (result = result.concat(result.length ? [space || ' ', elem] : elem));

                return result;
            }, []);
        }
    });
})();
