describe('i-utils__currencies', function() {
    var NBSP = String.fromCharCode(160);

    beforeEach(function() {
        u.stubCurrencies();
    });

    afterEach(function() {
        u.restoreCurrencies();
    });

    describe('get', function() {
        it('u.currencies.get("KZT") должна возвращать непустой объект', function() {
            expect(u.currencies.get('KZT')).to.be.an.instanceof(Object);
        });

        it('u.currencies.get("tenge") должна возвращать непустой объект', function() {
            expect(u.currencies.get('tenge')).to.be.an.instanceof(Object);
        });
    });

    describe('getName на полноценной валюте', function() {
        it('u.currencies.getName("RUB") -> руб.', function() {
            expect(u.currencies.getName('RUB')).to.be.equal('руб.');
        });

        it('u.currencies.getName("RUB", { full: 1 }) -> российские рубли', function() {
            expect(u.currencies.getName('RUB', { full: 1 })).to.be.equal('российские рубли');
        });
    });

    describe('getName на псевдо валюте', function() {

        it('u.currencies.getName("YND_FIXED") -> руб.', function() {
            expect(u.currencies.getName('YND_FIXED', { isPseudo: true })).to.be.equal('руб.');
        });

        it('u.currencies.getName("YND_FIXED", { full: 1 }) -> руб.', function() {
            expect(u.currencies.getName('YND_FIXED', { full: 1, isPseudo: true })).to.be.equal('руб.');
        });
    });


    describe('convUnitExplanation', function() {
        it('u.currencies.convUnitExplanation("KZT") -> 1 у.е. = 145.60 тенге', function() {
            expect(u.currencies.convUnitExplanation('KZT')).to.be.equal('1 у.е.' + NBSP + '=' + NBSP + '145.60 тенге');
        });
    });

    describe('getConst в нормальной валюте', function() {
        it('u.currencies.getConst("RUB", "MIN_PRICE") -> 0.3', function() {
            expect(u.currencies.getConst('RUB', 'MIN_PRICE')).to.be.equal(0.3);
        });
    });

    describe('getConst в псевдо валюте', function() {
        it('u.currencies.getConst("YND_FIXED", "MIN_PRICE", { isPseudo: true }) -> 0.3', function() {
            expect(u.currencies.getConst('YND_FIXED', 'MIN_PRICE', { isPseudo: true })).to.be.equal(0.3);
        });
    });

    describe('formatConst в нормальной валюте', function() {
        it('u.currencies.formatConst("RUB", "MIN_PRICE") -> 0.30 руб.', function() {
            expect(u.currencies.formatConst('RUB', 'MIN_PRICE')).to.be.equal('0.30 руб.');
        });
    });

    describe('formatConst в псевдо валюте', function() {
        it('u.currencies.formatConst("YND_FIXED", "MIN_PRICE", { isPseudo: true }) -> 0.30 руб.', function() {
            expect(u.currencies.formatConst('YND_FIXED', 'MIN_PRICE', { isPseudo: true })).to.be.equal('0.30 руб.');
        });
    });

    describe('getConvUnitRate в нормальной валюте', function() {
        it('u.currencies.getConvUnitRate("RUB") -> 30', function() {
            expect(u.currencies.getConvUnitRate('RUB')).to.be.equal(30);
        });
    });

    describe('getConvUnitRatePseudo в псевдо валюте', function() {
        it('u.currencies.getConvUnitRatePseudo("YND_FIXED") -> 30', function() {
            expect(u.currencies.getConvUnitRatePseudo('YND_FIXED')).to.be.equal(30);
        });
    });

    describe('roundPriceToStep', function() {
        it('u.currencies.roundPriceToStep(100.56, "rub", "up") -> 100.6', function() {
            expect(u.currencies.roundPriceToStep(100.56, 'rub', 'up')).to.be.equal(100.6);
        });

        it('u.currencies.roundPriceToStep(100.56, "rub", "down") -> 100.5', function() {
            expect(u.currencies.roundPriceToStep(100.56, 'rub', 'down')).to.be.equal(100.5);
        });
    });

    describe('formatSum', function() {
        it('u.currencies.formatSum("KZT", 123.4567) -> 123.46 тенге', function() {
            expect(u.currencies.formatSum('KZT', 123.4567)).to.be.equal('123.46 тенге');
        });

        it('округляет значения, большие 1e-7 до 0.01', function() {
            expect(u.currencies.formatSum('RUB', 0.0000001)).to.be.equal('0.01 руб.');
        });

        it('округляет значения, меньшие 1e-7 до 0.00', function() {
            expect(u.currencies.formatSum('RUB', 0.00000009)).to.be.equal('0.00 руб.');
        });

        it('разделяет группы разрядов неразрывным пробелом', function() {
            expect(u.currencies.formatSum('RUB', 1000)).to.be.equal('1' + NBSP + '000.00 руб.');
        });

        it('u.currencies.formatSum("KZT", 123.4567, { delim: "___", nds: 1 } }) -> 123.46___тенге включая НДС', function() {
            expect(u.currencies.formatSum('KZT', 123.4567, { delim: '___', nds: 1 })).to.be.equal('123.46___тенге включая НДС');
        });

        it('u.currencies.formatSum("YND_FIXED", 123.4567, { delim: "___", nds: 1 } }) -> 123.46___у.е.', function() {
            expect(u.currencies.formatSum('YND_FIXED', 123.4567, { delim: '___', nds: 1 })).to.be.equal('123.46___у.е.');
        });

        it('u.currencies.formatSum("KZT", 123.4567, { delim: "___", nds: 0 } }) -> 123.46___тенге без учёта НДС', function() {
            expect(u.currencies.formatSum('KZT', 123.4567, { delim: '___', nds: 0 })).to.be.equal('123.46___тенге без учёта НДС');
        });

        it('u.currencies.formatSum("KZT", 123.4567, { delim: "___", discount: 10, nds: 0 } }) -> 123.46___тенге без учёта НДС и скидки', function() {
            expect(u.currencies.formatSum('KZT', 123.4567, { delim: '___', discount: 10, nds: 0 })).to.be.equal('123.46___тенге без учёта НДС и скидки');
        });

        it('u.currencies.formatSum("KZT", 123.4567, { delim: "___", nds: 1, discount: 10 } }) -> 123.46___тенге включая НДС и без учёта скидки', function() {
            expect(u.currencies.formatSum('KZT', 123.4567, { delim: '___', nds: 1, discount: 10 })).to.be.equal('123.46___тенге включая НДС и без учёта скидки');
        });
    });
});
