describe('i-utils__format', function() {

    var nbsp = String.fromCharCode(160);

    describe('.formatInt', function() {

        it('должен вернуть undefined если вызвать без аргументов или с аргументом равным undefined', function() {
            expect(u.formatInt()).to.be.undefined;
        });

        it('не должен форматировать числа состоящие меньше чем из 4 цифр', function() {
            expect(u.formatInt(333)).to.be.equal('333');
        });

        it('должен преобразовывать число к целому значению отбрасывая дробную часть', function() {
            expect(u.formatInt(0.9999999)).to.be.equal('0');
        });

        context('если вызвали с одним аргументом', function() {
            it('должен вставить неразрывный пробел между каждыми тремя цифрами ', function() {
                expect(u.formatInt(1234123456789.123456)).to.be.equal('1' + nbsp + '234' + nbsp + '123' + nbsp + '456' + nbsp + '789');
            });
        });

        context('если вторым аргументом передали разделитель', function() {
            it('должен вставить переданный разделитель между каждыми тремя цифрами ', function() {
                expect(u.formatInt(1234123456789.123456, '-X-')).to.be.equal('1-X-234-X-123-X-456-X-789');
            });
        });
    });

    describe('.round2s', function() {
        [
            {
                funcArg: undefined,
                expectedResult: 0
            },
            {
                funcArg: '',
                expectedResult: 0
            },
            {
                funcArg: 0,
                expectedResult: 0
            },
            {
                funcArg: null,
                expectedResult: 0
            }
        ].forEach(function(testData) {
            it('должен вернуть 0 если вызвали с falsy аргументом. arguments=[' + testData.funcArg + ']',
                function() {
                    expect(u.round2s(testData.funcArg)).to.be.equal(testData.expectedResult);
                });
        });

        [
            {
                funcArg: 80.05499999999999,
                expectedResult: 80.06
            },
            {
                funcArg: -80.05499999999999,
                expectedResult: -80.06
            },
            {
                funcArg: 1.2,
                expectedResult: 1.2
            },
            {
                funcArg: 0.6666666666666666,
                expectedResult: 0.67
            },
            {
                funcArg: 1664.2,
                expectedResult: 1664.2
            },
            {
                funcArg: 96.072,
                expectedResult: 96.07
            },
            {
                funcArg: 0.005,
                expectedResult: 0.01
            },
            {
                funcArg: 1234,
                expectedResult: 1234
            },
            {
                funcArg: 1.25,
                expectedResult: 1.25
            }
        ].forEach(function(testData) {
            it('должен округлять дробную часть переданного значения оставляя не более 2 знаков после запятой. ' +
                'arguments=[' + testData.funcArg + ']',
                function() {
                    expect(u.round2s(testData.funcArg)).to.be.equal(testData.expectedResult);
                });
        });
    });

    describe('.formatPrice', function() {

        it('должен вернуть undefined если если не передали хотя бы один аргумент', function() {
            expect(u.formatPrice()).to.be.undefined;
        });

        [
            {
                description: 'не должен форматировать значения меньше целая часть которых содержит меньше 3 цифр',
                funcArg: 999.99,
                expectedResult: '999.99'
            },
            {
                description: 'должен округлить дробную часть значения до двух знаков',
                funcArg: 0.9999999,
                expectedResult: '1.00'
            },
            {
                description: 'должен отображать 2 знака после дробного разделителя',
                funcArg: 0,
                expectedResult: '0.00'
            },
            {
                description: 'должен округлять значение до 0.01 если оно больше 1e-7 и меньше 0.01',
                funcArg: 1e-7 * 1.1,
                expectedResult: '0.01'
            },
            {
                description: 'должен округлять значение до 0.00 если оно меньше 1e-7',
                funcArg: 1e-7 * 0.9,
                expectedResult: '0.00'
            }
        ].forEach(function(testData) {
            it(testData.description, function() {
                expect(u.formatPrice(testData.funcArg)).to.be.equal(testData.expectedResult);
            });
        });

        context('при вызове с одним аргументом', function() {
            it('должен добавлять неразрывный пробел между каждыми тремя цифрами', function() {
                expect(u.formatPrice(1234123456789)).to.be.equal('1' + nbsp + '234' + nbsp + '123' + nbsp + '456' + nbsp + '789.00');
            });
        });

        context('если передали разделитель вторым аргументом', function() {
            it('должен добавлять разделитель между каждыми тремя цифрами', function() {
                expect(u.formatPrice(1234123456789, '-x-')).to.be.equal('1-x-234-x-123-x-456-x-789.00');
            });
        });
    });

    describe('.formatShowsOrMoney', function() {

        it('должен форматировать переданное значение если первый аргумент undefined или "-"', function() {
            expect(u.formatShowsOrMoney()).to.be.undefined;
            expect(u.formatShowsOrMoney('-')).to.be.equal('-');
        });

        context('если не передали второй аргумент', function() {
            it('по умолчанию должен форматировать переданное значение как цену', function() {
                expect(u.formatShowsOrMoney(123.23423)).to.be.equal('123.23');
            });

            it('должен вернуть "0.00" если переданное значение 0', function() {
                expect(u.formatShowsOrMoney(0, 'money')).to.be.equal('0.00');
            });
        });

        context('если вторым аргументом передать "money"', function() {
            it('должен форматировать переданное значение как цену', function() {
                expect(u.formatShowsOrMoney(123.23423, 'money')).to.be.equal('123.23');
            });

            it('должен вернуть "0.00" если переданное значение 0', function() {
                expect(u.formatShowsOrMoney(0, 'money')).to.be.equal('0.00');
            });
        });

        context('если вторым аргументом передали "shows"', function() {
            it('должен уменьшать переданное в 1000 раз и оставлять 3 знака после дробного разделителя', function() {
                expect(u.formatShowsOrMoney(3, 'shows')).to.be.equal('0.003');
            });

            it('должен вернуть "0" если переданное значение < 0.001', function() {
                expect(u.formatShowsOrMoney(0.0009, 'shows')).to.be.equal('0');
            });

            it('должен вернуть 0 если переданное значение < 0.001', function() {
                expect(u.formatShowsOrMoney(0, 'shows')).to.be.equal(0);
            });

            [0.9, 1.4].forEach(function(item) {
                it('должен округлить до 0.001 если переданное значение больше 0.4 и меньше 1.5. ' +
                    'arguments=[' + item + ']',
                    function() {
                        expect(u.formatShowsOrMoney(item, 'shows')).to.be.equal('0.001');
                    });
            });
        });
    });
});
