u.register({

    /**
     * Возврашает цветовое распределение(в процентах) для построения градиента
     * @param {Array} colors
     * @param {Object} limits
     * @returns {Array}
     */
    gradient: function(colors, limits) {
        var min = limits.min,
            max = limits.max,
            maxCpmPrice = limits.maxCpmPrice,
            rupture = limits.rupture,
            percentage,
            range = (max - min) * 100 / rupture, // вычисляем длину шкалы в масштабе основных значений
            rangeMax = (maxCpmPrice - max) * 100 / (100 - rupture); // вычисляем длину шкалы в маштабе максимальных значений

        percentage = colors.map(function(color) {
            var start = color.range[0],
                finish = (color.range[1] || maxCpmPrice), // maxCpmPrice так как, для последнего цвета нет max
                // если больше max, то превышение от основного значения переводим в проценты в масштабе максимальных значений
                startPercent = (start < max) ? (start - min) / range * 100 : (rupture + (start - max) / rangeMax * 100),
                finishPercent = (finish < max) ? (finish - min) / range * 100 : (rupture + (finish - max) / rangeMax * 100);

            return {
                name: color.name,
                startPercent: startPercent,
                finishPercent: finishPercent
            };
        });

        return percentage.reduce(function(result, color) {
            result.push(color.name + ' ' + color.startPercent + '%');
            result.push(color.name + ' ' + color.finishPercent + '%');

            return result;
        }, []);
    }
});
