describe('i-utils__hellip-cut', function() {
    describe('u.hellipCut', function() {

        it('должна обрезать строки длиннее чем запрашиваемое количество символов', function() {
            expect(u.hellipCut('The quick brown fox jumps over the lazy dog', 12)).to.be.equal('The quick br…');
        });

        it('не должна включать в результирующий текст пробел, если он является последним символом', function() {
            expect(u.hellipCut('The quick brown fox jumps over the lazy dog', 10)).to.be.equal('The quick…'); //а не 'The quick …'
        });

        it('не должна обрезать текст, если длина текста совпадает с длиной обрезания', function() {
            expect(u.hellipCut('The a, b and c', 13)).to.be.equal('The a, b and c'); //а не 'The a, b and …'
        });

        it('должна добавлять в конец результата указанный символ вместо html-сущности многоточия', function() {
            expect(u.hellipCut('The quick brown fox jumps over the lazy dog', 12, '...')).to.be.equal('The quick br...');
        });

        it('должна обрабатывать результат переданной функцией-обработчиком, не включая многоточие', function() {
            expect(u.hellipCut('The quick brown fox jumps over the lazy dog', 12, 'etc', function(str) { return str.toUpperCase(); })).to.be.equal('THE QUICK BRetc');
            //Тест ниже не включил, чтобы не тащить зависимость для u.escapeHTML, но он иллюстрирует интент добавления resultDecorator
            //u.hellipCut(">>жми сюда<<", 3, u.escapeHTML).must.be.equal('&#62;&#62;ж…') //а не &#62;&#62;ж&#38;hellip;
        });

    });

    describe('u.hellipCutFromStart', function() {

        it('должна обрезать строки длиннее чем запрашиваемое количество символов', function() {
            expect(u.hellipCutFromStart('The quick brown fox jumps over the lazy dog', 12)).to.be.equal('…the lazy dog');
        });

        it('не должна включать в результирующий текст пробел, если он является первым символом', function() {
            expect(u.hellipCutFromStart('The quick brown fox jumps over the lazy dog', 9)).to.be.equal('…lazy dog'); //а не '… lazy dog'
        });

        it('не должна обрезать текст, если длина текста совпадает с длиной обрезания', function() {
            expect(u.hellipCutFromStart('The a, b and c', 13)).to.be.equal('The a, b and c');
        });

        it('должна добавлять в начало результата указанный символ вместо html-сущности многоточия', function() {
            expect(u.hellipCutFromStart('The quick brown fox jumps over the lazy dog', 12, '...')).to.be.equal('...the lazy dog');
        });

        it('должна обрабатывать результат переданной функцией-обработчиком, не включая многоточие', function() {
            expect(u.hellipCutFromStart('The quick brown fox jumps over the lazy dog', 12, 'etc', function(str) { return str.toUpperCase(); })).to.be.equal('etcTHE LAZY DOG');
        });

    });

    describe('u.hellipSplit', function() {

        it('должна добавлять в середину результата указанный символ вместо html-сущности многоточия', function() {
            expect(u.hellipSplit('The quick brown fox jumps over the lazy dog', 12, '...')).to.be.equal('The qu...zy dog');
        });

        it('должна обрезать строки длиннее чем запрашиваемое количество символов', function() {
            expect(u.hellipSplit('The quick brown fox jumps over the lazy dog', 12)).to.be.equal('The qu…zy dog');
        });

        it('не должна включать в результирующий текст пробел, если он является последним символом первой части строки или первым символом второй части строки', function() {
            expect(u.hellipSplit('The quick brown fox jumps over the lazy dog', 19)).to.be.equal('The quick…lazy dog'); //а не 'The quick … lazy dog'
        });

        it('не должна обрезать текст, если длина текста совпадает с длиной обрезания', function() {
            expect(u.hellipSplit('The a, b and c', 13)).to.be.equal('The a, b and c');
        });

        it('должна обрабатывать результат переданной функцией-обработчиком, не включая многоточие', function() {
            expect(u.hellipSplit('The quick brown fox jumps over the lazy dog', 12, 'etc', function(str) { return str.toUpperCase(); })).to.be.equal('THE QUetcZY DOG');
        });

    });

});
