(function() {
    u.register({

        _hellip: {

            MODES: {
                // режим обрезки с хвоста
                DEFAULT: 0,
                // режим обрезки с начала
                START: 1,
                // режим обрезки по центру
                SPLIT: 2
            },

            /**
             * Производит преобразование строки согласно режиму
             * @param {Number} mode режим (enum u._hellip.MODES)
             * @param {String} string исходная строка
             * @param {Number} length желаемое количество символов в результате
             * @param {String} [hellipString='…'] строка, которая дописывается к результату согласно режиму
             * @param {Function} [resultDecorator] функция - обработчик обрезанной части, по умолчанию ничего не делает
             * @returns {String}
             * @private
             */
            _process: function(mode, string, length, hellipString, resultDecorator) {
                var parts;

                if (string) {
                    if (typeof hellipString == 'function') {
                        resultDecorator = hellipString;
                        hellipString = null;
                    }

                    if (string.length > length + 1) {
                        parts = ([
                            [
                                // режем хвост - тримим хвост
                                string.substr(0, length).replace(/\s+$/, ''),
                                // правый join
                                ''
                            ],
                            [
                                // левый join
                                '',
                                // режем начало - тримим начало
                                string.substr(string.length - length).replace(/^\s+/, '')
                            ],
                            [
                                // режем хвост - тримим хвост
                                string.slice(0, length / 2).replace(/\s+$/, ''),
                                // режем начало - тримим начало
                                string.slice(-length / 2).replace(/^\s+/, '')
                            ]
                        ])[mode];
                    }

                    return (parts || [string])
                        .map(resultDecorator || function(str) { return str; })
                        .join(hellipString || '…');
                }

                return string;
            }
        },

        /**
         * Обрезает строку до указанного количества символов и обрабатывает ее resultDecorator-ом.
         * Добавляет в конец строки hellipString
         * @param {String} string исходная строка
         * @param {Number} length желаемое количество символов в результате
         * @param {String} [hellipString='…'] строка, которая дописывается в конец результата
         * @param {Function} [resultDecorator] функция - обработчик обрезанной части, по умолчанию ничего не делает
         * @returns {String}
         */
        hellipCut: function(string, length, hellipString, resultDecorator) {
            return u._hellip._process(u._hellip.MODES.DEFAULT, string, length, hellipString, resultDecorator)
        },

        /**
         * Обрезает строку до указанного количества символов и обрабатывает ее resultDecorator-ом.
         * Добавляет в начало строки hellipString
         * @param {String} string исходная строка
         * @param {Number} length желаемое количество символов в результате
         * @param {String} [hellipString='…'] строка, которая дописывается в начало результата
         * @param {Function} [resultDecorator] функция - обработчик обрезанной части, по умолчанию ничего не делает
         * @returns {String}
         */
        hellipCutFromStart: function(string, length, hellipString, resultDecorator) {
            return u._hellip._process(u._hellip.MODES.START, string, length, hellipString, resultDecorator)
        },

        /**
         * Обрезает строку до указанного количества символов и обрабатывает ее resultDecorator-ом.
         * Добавляет в середину строки hellipString
         * @param {String} string исходная строка
         * @param {Number} length желаемое количество символов в результате
         * @param {String} [hellipString='…'] строка, которая дописывается в середину результата
         * @param {Function} [resultDecorator] функция - обработчик обрезанной части, по умолчанию ничего не делает
         * @returns {String}
         */
        hellipSplit: function(string, length, hellipString, resultDecorator) {
            return u._hellip._process(u._hellip.MODES.SPLIT, string, length, hellipString, resultDecorator)
        }

    });

})();
