/* jshint ignore:start */

// Локализация
// moment.js language configuration
// language : russian (ru)
// author : Viktorminator : https://github.com/Viktorminator
// Author : Menelion Elensúle : https://github.com/Oire

(function (factory) {
    factory(u.moment);
}(function (moment) {
    function plural(word, num) {
        var forms = word.split('_');
        return num % 10 === 1 && num % 100 !== 11 ? forms[0] : (num % 10 >= 2 && num % 10 <= 4 && (num % 100 < 10 || num % 100 >= 20) ? forms[1] : forms[2]);
    }

    function relativeTimeWithPlural(number, withoutSuffix, key) {
        var format = {
            'mm': [withoutSuffix ? iget2('i-utils', 'minuta', 'минута') : iget2('i-utils', 'minutu', 'минуту'), iget2('i-utils', 'minuty', 'минуты'), iget2('i-utils', 'minut', 'минут')].join('_'),
            'hh': [iget2('i-utils', 'chas', 'час'), iget2('i-utils', 'chasa', 'часа'), iget2('i-utils', 'chasov', 'часов')].join('_'),
            'dd': [iget2('i-utils', 'den', 'день'), iget2('i-utils', 'dnya', 'дня'), iget2('i-utils', 'dney', 'дней')].join('_'),
            'MM': [iget2('i-utils', 'mesyac', 'месяц'), iget2('i-utils', 'mesyaca', 'месяца'), iget2('i-utils', 'mesyacev', 'месяцев')].join('_'),
            'yy': [iget2('i-utils', 'god', 'год'), iget2('i-utils', 'goda', 'года'), iget2('i-utils', 'let', 'лет')].join('_')
        };
        if (key === 'm') {
            return withoutSuffix ? iget2('i-utils', 'minuta', 'минута') : iget2('i-utils', 'minutu', 'минуту');
        }
        else {
            return number + ' ' + plural(format[key], +number);
        }
    }

    function monthsCaseReplace(m, format) {
        var months = {
            'nominative': [iget2('i-utils', 'yanvar', 'январь'), iget2('i-utils', 'fevral', 'февраль'), iget2('i-utils', 'mart', 'март'), iget2('i-utils', 'aprel', 'апрель'), iget2('i-utils', 'may', 'май'), iget2('i-utils', 'iyun', 'июнь'), iget2('i-utils', 'iyul', 'июль'), iget2('i-utils', 'avgust', 'август'), iget2('i-utils', 'sentyabr', 'сентябрь'), iget2('i-utils', 'oktyabr', 'октябрь'), iget2('i-utils', 'noyabr', 'ноябрь'), iget2('i-utils', 'dekabr', 'декабрь')],
            'accusative': [iget2('i-utils', 'yanvarya', 'января'), iget2('i-utils', 'fevralya', 'февраля'), iget2('i-utils', 'marta', 'марта'), iget2('i-utils', 'aprelya', 'апреля'), iget2('i-utils', 'maya', 'мая'), iget2('i-utils', 'iyunya', 'июня'), iget2('i-utils', 'iyulya', 'июля'), iget2('i-utils', 'avgusta', 'августа'), iget2('i-utils', 'sentyabrya', 'сентября'), iget2('i-utils', 'oktyabrya', 'октября'), iget2('i-utils', 'noyabrya', 'ноября'), iget2('i-utils', 'dekabrya', 'декабря')]
        },

        nounCase = (/D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/).test(format) ?
            'accusative' :
            'nominative';

        return months[nounCase][m.month()];
    }

    function monthsShortCaseReplace(m, format) {
        var monthsShort = {
            'nominative': [iget2('i-utils', 'yanv', 'янв'), iget2('i-utils', 'fev', 'фев'), iget2('i-utils', 'mar', 'мар'), iget2('i-utils', 'apr', 'апр'), iget2('i-utils', 'may', 'май'), iget2('i-utils', 'iyun', 'июнь'), iget2('i-utils', 'iyul', 'июль'), iget2('i-utils', 'avg', 'авг'), iget2('i-utils', 'sen', 'сен'), iget2('i-utils', 'okt', 'окт'), iget2('i-utils', 'noya', 'ноя'), iget2('i-utils', 'dek', 'дек')],
            'accusative': [iget2('i-utils', 'yanv', 'янв'), iget2('i-utils', 'fev', 'фев'), iget2('i-utils', 'mar', 'мар'), iget2('i-utils', 'apr', 'апр'), iget2('i-utils', 'maya', 'мая'), iget2('i-utils', 'iyunya', 'июня'), iget2('i-utils', 'iyulya', 'июля'), iget2('i-utils', 'avg', 'авг'), iget2('i-utils', 'sen', 'сен'), iget2('i-utils', 'okt', 'окт'), iget2('i-utils', 'noya', 'ноя'), iget2('i-utils', 'dek', 'дек')]
        },

        nounCase = (/D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/).test(format) ?
            'accusative' :
            'nominative';

        return monthsShort[nounCase][m.month()];
    }

    function weekdaysCaseReplace(m, format) {
        var weekdays = {
            'nominative': [iget2('i-utils', 'voskresene', 'воскресенье'), iget2('i-utils', 'ponedelnik', 'понедельник'), iget2('i-utils', 'vtornik', 'вторник'), iget2('i-utils', 'sreda', 'среда'), iget2('i-utils', 'chetverg', 'четверг'), iget2('i-utils', 'pyatnica', 'пятница'), iget2('i-utils', 'subbota', 'суббота')],
            'accusative': [iget2('i-utils', 'voskresene', 'воскресенье'), iget2('i-utils', 'ponedelnik', 'понедельник'), iget2('i-utils', 'vtornik', 'вторник'), iget2('i-utils', 'sredu', 'среду'), iget2('i-utils', 'chetverg', 'четверг'), iget2('i-utils', 'pyatnicu', 'пятницу'), iget2('i-utils', 'subbotu', 'субботу')]
        },

        nounCase = (/\[ ?[Вв] ?(?:прошлую|следующую)? ?\] ?dddd/).test(format) ?
            'accusative' :
            'nominative';

        return weekdays[nounCase][m.day()];
    }

    return moment.locale('ru', {
        months : monthsCaseReplace,
        monthsShort : monthsShortCaseReplace,
        weekdays : weekdaysCaseReplace,
        weekdaysShort : [iget2('i-utils', 'vs', 'вс'), iget2('i-utils', 'pn', 'пн'), iget2('i-utils', 'vt', 'вт'), iget2('i-utils', 'sr', 'ср'), iget2('i-utils', 'cht', 'чт'), iget2('i-utils', 'pt', 'пт'), iget2('i-utils', 'sb', 'сб')],
        weekdaysMin : [iget2('i-utils', 'vs', 'вс'), iget2('i-utils', 'pn', 'пн'), iget2('i-utils', 'vt', 'вт'), iget2('i-utils', 'sr', 'ср'), iget2('i-utils', 'cht', 'чт'), iget2('i-utils', 'pt', 'пт'), iget2('i-utils', 'sb', 'сб')],
        monthsParse : [iget2('i-utils', 'yanv', 'янв'), iget2('i-utils', 'fev', 'фев'), iget2('i-utils', 'mar', 'мар'), iget2('i-utils', 'apr', 'апр'), iget2('i-utils', 'may', 'май'), iget2('i-utils', 'iyun-188', 'июн'), iget2('i-utils', 'iyul-189', 'июл'), iget2('i-utils', 'avg', 'авг'), iget2('i-utils', 'sen', 'сен'), iget2('i-utils', 'okt', 'окт'), iget2('i-utils', 'noya', 'ноя'), iget2('i-utils', 'dek', 'дек')].map(function(m) {
            m === 'май' && (m = 'ма[йя]');

            return new RegExp(m, 'i');
        }),
        longDateFormat : {
            LT : "HH:mm",
            L : "DD.MM.YYYY",
            LL : "D MMMM YYYY г.",
            LLL : "D MMMM YYYY г., LT",
            LLLL : "dddd, D MMMM YYYY г., LT"
        },
        calendar : {
            sameDay: '[' + iget2('i-utils', 'segodnya-v', 'Сегодня в') +'] LT',
            nextDay: '['+ iget2('i-utils', 'zavtra-v', 'Завтра в')+'] LT',
            lastDay: '[Вчера в] LT',
            nextWeek: function () {
                return this.day() === 2 ? '[Во] dddd [в] LT' : '[В] dddd [в] LT';
            },
            lastWeek: function () {
                switch (this.day()) {
                case 0:
                    return '['+ iget2('i-utils', 'v-proshloe', 'В прошлое')+'] dddd [в] LT';
                case 1:
                case 2:
                case 4:
                    return '['+ iget2('i-utils', 'v-proshlyy', 'В прошлый')+'] dddd [в] LT';
                case 3:
                case 5:
                case 6:
                    return '['+ iget2('i-utils', 'v-proshluyu', 'В прошлую')+'] dddd [в] LT';
                }
            },
            sameElse: 'L'
        },
        relativeTime : {
            future : iget2('i-utils', 'cherez', 'через') + " %s",
            past : "%s " + iget2('i-utils', 'nazad', 'назад'),
            s : iget2('i-utils', 'neskolko-sekund', 'несколько секунд'),
            m : relativeTimeWithPlural,
            mm : relativeTimeWithPlural,
            h : iget2('i-utils', 'chas', 'час'),
            hh : relativeTimeWithPlural,
            d : iget2('i-utils', 'den', 'день'),
            dd : relativeTimeWithPlural,
            M : iget2('i-utils', 'mesyac', 'месяц'),
            MM : relativeTimeWithPlural,
            y : iget2('i-utils', 'god', 'год'),
            yy : relativeTimeWithPlural
        },

        // M. E.: those two are virtually unused but a user might want to implement them for his/her website for some reason

        meridiem : function (hour, minute, isLower) {
            if (hour < 4) {
                return iget2('i-utils', 'nochi', 'ночи');
            } else if (hour < 12) {
                return iget2('i-utils', 'utra', 'утра');
            } else if (hour < 17) {
                return iget2('i-utils', 'dnya', 'дня');
            } else {
                return iget2('i-utils', 'vechera', 'вечера');
            }
        },

        ordinal: function (number, period) {
            switch (period) {
            case 'M':
            case 'd':
            case 'DDD':
                return number + '-й';
            case 'D':
                return number + '-го';
            case 'w':
            case 'W':
                return number + '-я';
            default:
                return number;
            }
        },

        week : {
            dow : 1, // Monday is the first day of the week.
            doy : 7  // The week that contains Jan 1st is the first week of the year.
        }
    });
}));
/* jshint ignore:end */
