describe('i-utils__preview', function() {
    describe('getPreviewUrl', function() {
        it ('должен подставлять значения шаблона (__template__) и параметров({параметр}) из params.subst', function() {
            expect(u.getPreviewUrl('http://ya.ru?search=#template#&from={param1}', {
                subst: {
                    param1: "param1",
                    __template__: "template content"
                }
            })).to.be.equal('http://ya.ru?search=template content&from=param1');
        });

        // @see DIRECT-49974
        it ('должен url-кодировать значения подставляемых параметров', function() {
            expect(u.getPreviewUrl('http://www.logo.ru/shop/televizory-audio-video/televizory/{param1}', {
                subst: {
                    param1: "?prop[003024][from]=25&prop[003024][to]=25"
                }
            })).to.be.equal('http://www.logo.ru/shop/televizory-audio-video/televizory/%3Fprop%5B003024%5D%5Bfrom%5D%3D25%26prop%5B003024%5D%5Bto%5D%3D25');
        });

        it ('должен добавлять параметры из params.add', function() {
            expect(u.getPreviewUrl('http://ya.ru', {
                add: {
                    _openstat: 'tR23jQ9l',
                    yclid: '12rfSdfkc2E'
                }
            })).to.be.equal('http://ya.ru?_openstat=tR23jQ9l&yclid=12rfSdfkc2E');
        });

        it ('должен добавлять параметры из params.add учитывая якоря в ссылках', function() {
            expect(u.getPreviewUrl('http://www.avteplos.ru/#!gasnapoln/cs96', {
                add: {
                    yclid: '12rfSdfkc2E'
                }
            })).to.be.equal('http://www.avteplos.ru/?yclid=12rfSdfkc2E#!gasnapoln/cs96');
        });

        it ('должен возвращать значение по умолчанию для шаблона, если значение шаблона не задано', function() {
            expect(u.getPreviewUrl('http://ya.ru/?search=#помыть кота видео#')).to.be.equal('http://ya.ru/?search=помыть кота видео');
        });

        it ('должен правильно обрабатывать ссылки с шаблонами и якорями', function() {
            expect(u.getPreviewUrl('http://ya.ru/?search=#помыть кота видео##anchor')).to.be.equal('http://ya.ru/?search=помыть кота видео#anchor');
        });

        it ('должен правильно обрабатывать ссылки с шаблонами и добавлять параметры из params.add', function() {
            expect(u.getPreviewUrl('http://ya.ru/?search=#помыть кота видео#', {
                add: {
                    yclid: '12rfSdfkc2E'
                }
            })).to.be.equal('http://ya.ru/?search=помыть кота видео&yclid=12rfSdfkc2E');
        });

        it ('должен добавлять к ссылке протокол, если его нет', function() {
            expect(u.getPreviewUrl('ya.ru')).to.be.equal('http://ya.ru');
        });

        it ('должен игнорировать регистр при решении, добавлять ли протокол', function() {
            expect(u.getPreviewUrl('hTTp://ya.ru')).to.be.equal('hTTp://ya.ru');
        });
    });

    describe('getPreviewUrlParams', function() {
        it ('должен возвращать параметры переданной фразы', function() {
            expect(u.getPreviewUrlParams({
                key_words: 'автозапчасти',
                param1: 'param1value',
                param2: 'param2value'
            })).to.be.eql({
                subst: {
                    __template__: 'автозапчасти',
                    param1: 'param1value',
                    param2: 'param2value'
                },
                add: {}
            });
        });
        it ('должен добавлять в параметры _openstat, если передан соответствующий флаг', function() {
            expect(u.getPreviewUrlParams(null, true)).to.be.eql({
                subst: {
                    __template__: ''
                },
                add: {
                    _openstat: 'dGVzdDsxOzE7'
                }
            });
        });
        it ('должен  добавлять в параметры yclid, если передан соответствующий флаг ', function() {
            var yclid = 48313024715480424;

            u.stub(u, {
                generateYclid: function() {
                    return yclid;
                }
            });

            expect(u.getPreviewUrlParams(null, false, true)).to.be.eql({
                subst: {
                    __template__: ''
                },
                add: {
                    yclid: yclid
                }
            });

            u.restore(u);
        });
        it ('должен добавлять в параметры yclid и _openstat, если передали только эти флаги без фразы', function() {
            var yclid = 48313024715480424;

            u.stub(u, {
                generateYclid: function() {
                    return yclid;
                }
            });

            expect(u.getPreviewUrlParams(true, true)).to.be.eql({
                subst: {
                    __template__: ''
                },
                add: {
                    yclid: yclid,
                    _openstat: 'dGVzdDsxOzE7'
                }
            });

            u.restore(u);
        });
    });

    describe('replaceTemplate', function() {
        it('должен заменять шаблон на его значение', function() {
            expect(u.replaceTemplate('купите #запчасти#', 33, 'карданный вал')).to.be.equal('купите <span class="b-banner-preview__template">карданный вал</span>');
        });

        it('должен заменять шаблон значением по умолчанию, если строка с заменой шаблона на templateValue не укладывается в ограничение длины', function() {
            expect(u.replaceTemplate('купите #запчасти#', 33, 'стабилизатор поперечной устойчивости')).to.be.equal('купите <span class="b-banner-preview__template">запчасти</span>');
        });

        it('должен обрезать строку результата до limit', function() {
            expect(u.replaceTemplate('купите #запчасти#', 10, 'карданный вал')).to.be.equal('купите <span class="b-banner-preview__template">зап</span>');
        });

        it('замена должна происходить только между первым и вторым символом #', function() {
            expect(u.replaceTemplate('купите #запчасти# и #слона и #енота', 50, 'капибару')).to.be.equal('купите <span class="b-banner-preview__template">капибару</span> и #слона и #енота');
        });
    });

    describe('formatPhrase', function() {
        it ('должна удалять оператор !', function() {
            expect(u.preview.formatPhrase('!купить !продать цветы')).to.be.equal('купить продать цветы');
        });
        it ('не должна удалять !, не являющимся оператором', function() {
            expect(u.preview.formatPhrase('купить цветы!')).to.be.equal('купить цветы!');
        });
        it ('должна удалять оператор +', function() {
            expect(u.preview.formatPhrase('+товары +для автомобиля')).to.be.equal('товары для автомобиля');
        });
        it ('не должна удалять +, не являющимся оператором', function() {
            expect(u.preview.formatPhrase('1 + 2 + 3')).to.be.equal('1 + 2 + 3');
        });
        it ('должна удалять оператор []', function() {
            expect(u.preview.formatPhrase('билеты [Москва Мадрид] на выходные')).to.be.equal('билеты Москва Мадрид на выходные');
        });
        it ('должна удалять оператор ""', function() {
            expect(u.preview.formatPhrase('"камин"')).to.be.equal('камин');
        });
    });

    describe('serpTitleSubstitution', function() {

        describe('Переставляет в конец заголовка первое предложение из текста', function() {
            it ('заканчивающиеся на точку. При этом точку из предложения подстановки обрезаем', function() {
                expect(u.preview.serpTitleSubstitution('Title show.', 'Only for you. Body text')).to.eql({
                    title: 'Title show. – Only for you',
                    body: 'Body text'
                });
            });
            it ('заканчивающиеся на восклицательный знак', function() {
                expect(u.preview.serpTitleSubstitution('Title show!', 'Only for you! Body text')).to.eql({
                    title: 'Title show! – Only for you!',
                    body: 'Body text'
                });
            });
            it ('заканчивающиеся на вопросительный знак', function() {
                expect(u.preview.serpTitleSubstitution('Title show.', 'Only for you? Body text')).to.eql({
                    title: 'Title show. – Only for you?',
                    body: 'Body text'
                });
            });
            it ('заканчивающиеся на несколько восклицательных знаков', function() {
                expect(u.preview.serpTitleSubstitution('Title show.', 'Only for you!! Body text')).to.eql({
                    title: 'Title show. – Only for you!!',
                    body: 'Body text'
                });
            });
            it ('заканчивающиеся на комбинацию восклицательного и вопросительного знаков', function() {
                expect(u.preview.serpTitleSubstitution('Title show.', 'Only for you?! Body text')).to.eql({
                    title: 'Title show. – Only for you?!',
                    body: 'Body text'
                });
            });
            it ('если после точки нет пробела, но идет заглавная буква', function() {
                expect(u.preview.serpTitleSubstitution('Title show.', 'Only for you.Body text')).to.eql({
                    title: 'Title show. – Only for you',
                    body: 'Body text'
                });
            });
            it ('если после точки есть пробел, но идет строчная буква', function() {
                expect(u.preview.serpTitleSubstitution('Title show.', 'Only for you. body text')).to.eql({
                    title: 'Title show. – Only for you',
                    body: 'body text'
                });
            });
            describe('если находит многоточие', function() {
                it ('многоточие из одного символа', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', 'Only for you…body text')).to.eql({
                        title: 'Title show. – Only for you…',
                        body: 'body text'
                    });
                });
                it ('многоточие из трех символов', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', 'Only for you...body text')).to.eql({
                        title: 'Title show. – Only for you...',
                        body: 'body text'
                    });
                });
            });
            it ('если заголовок и первое предложение совпадают в одном слове', function() {
                expect(u.preview.serpTitleSubstitution('Look text!', 'Body text. Title show.')).to.eql({
                    title: 'Look text! – Body text',
                    body: 'Title show.'
                });
            });
            it ('если количество символов заголовка и первого предложения (c учетом « – ») = 56', function() {
                expect(u.preview.serpTitleSubstitution('Интернет-магаз верхней одежды!', 'Женская верхняя одежда! Скидки до 70%!')).to.eql({
                    title: 'Интернет-магаз верхней одежды! – Женская верхняя одежда!',
                    body: 'Скидки до 70%!'
                });
            });
            it ('если количество символов заголовка и первого предложения (без учета « – ») < 56', function() {
                expect(u.preview.serpTitleSubstitution('Магазин верхней одежды!', 'Женская верхняя одежда! Скидки до 70%! Бесплатная примерка!')).to.eql({
                    title: 'Магазин верхней одежды! – Женская верхняя одежда!',
                    body: 'Скидки до 70%! Бесплатная примерка!'
                });
            });
            it ('если конец предложения находится между словами с апострофом', function() {
                expect(u.preview.serpTitleSubstitution('Title show.', "Mc'Donald создал сеть. Mc'Donald создал культуру.Body text.")).to.eql({
                    title: "Title show. – Mc'Donald создал сеть",
                    body: "Mc'Donald создал культуру.Body text."
                });
            });
        });

        describe('Переставляет в конец заголовка часть описания, включая знаки-разделители', function() {
            it ('если после точки нет пробела', function() {
                expect(u.preview.serpTitleSubstitution('Title show.', 'Only for 12.12.1990. you')).to.eql({
                    title: 'Title show. – Only for 12.12.1990',
                    body: 'you'
                });
            });

            it ('если внутри числа вставленна одинарная кавычка', function() {
                expect(u.preview.serpTitleSubstitution('Title show.', 'Only for 500\'000. you')).to.eql({
                    title: 'Title show. – Only for 500\'000',
                    body: 'you'
                });
            });
            it ('если одинарная кавычка находится в конце слова', function() {
                expect(u.preview.serpTitleSubstitution('Title show.', 'Only for hat\'. you')).to.eql({
                    title: 'Title show. – Only for hat\'',
                    body: 'you'
                });
            });
            it ('если одинарная кавычка окружена символами и цифрами', function() {
                expect(u.preview.serpTitleSubstitution('Title show.', 'Only for hat\'55. you')).to.eql({
                    title: 'Title show. – Only for hat\'55',
                    body: 'you'
                });
            });
            describe('если перед точкой находится слово-исключение', function() {
                ['им', 'с', 'яндекс', 'и', 'тыс', 'млн', 'абон', 'м', 'юр', 'г', 'руб', 'р', 'ак', '₽'].forEach(function(exclude) {

                    it ('Исключение «' + exclude + '»', function() {
                        expect(u.preview.serpTitleSubstitution('Title show.', 'Только для ' + exclude +'. тебя. текст')).to.eql({
                            title: 'Title show. – Только для ' + exclude + '. тебя',
                            body: 'текст'
                        });
                    });

                    it ('Исключение «' + exclude + '» с числом в начале', function() {
                        expect(u.preview.serpTitleSubstitution('Title show.', 'Только для 100500' + exclude +'. тебя. текст')).to.eql({
                            title: 'Title show. – Только для 100500' + exclude + '. тебя',
                            body: 'текст'
                        });
                    });

                    it ('Исключение «' + exclude + '» с числом посреди строки', function() {
                        var obj = u.preview.serpTitleSubstitution('Title show.', 'Только для 100/500' + exclude +'. Тебя текст в подарок!');

                        expect(obj.title).to.eql('Title show.');
                        expect(obj.body).to.eql('Только для 100/500' + exclude +'. Тебя текст в подарок!');
                    });

                    it ('Первое слово – исключение «' + exclude + '» с числом в начале', function() {
                        var obj = u.preview.serpTitleSubstitution('Title show.', '100' + exclude +'. в подарок. body text');

                        expect(obj.title).to.eql('Title show. – 100' + exclude + '. в подарок');
                        expect(obj.body).to.eql('body text');
                    });

                    it ('Два слова – исключения «' + exclude + '» с числом в начале', function() {
                        var obj = u.preview.serpTitleSubstitution('Title show.', '2' + exclude +'. 4' + exclude +'. да! body text');

                        expect(obj.title).to.eql('Title show. – 2' + exclude + '. 4' + exclude +'. да!');
                        expect(obj.body).to.eql('body text');
                    });

                    it ('Слово, окнчивающееся как исклюение «' + exclude + '», но им не являющееся', function() {
                        expect(u.preview.serpTitleSubstitution('Title show.', 'Только для те' + exclude +'. Бя. текст')).to.eql({
                            title: 'Title show. – Только для те' + exclude,
                            body: 'Бя. текст'
                        });
                    });
                });
            });
            describe('если найденный знак окончания предложения находится внутри', function() {
                it ('двойных кавычек', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', 'Второй конец "будет. тут" лежать.Body text.')).to.eql({
                        title: 'Title show. – Второй конец "будет. тут" лежать',
                        body: 'Body text.'
                    });
                });
                it ('квадратных скобок', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', 'Четвертый конец [будет. Тут].Body text.')).to.eql({
                        title: 'Title show. – Четвертый конец [будет',
                        body: 'Тут].Body text.'
                    });
                });
                it ('внутри елочек', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', 'Шестой конец «будет. тут» лежать.Body text.')).to.eql({
                        title: 'Title show. – Шестой конец «будет. тут» лежать',
                        body: 'Body text.'
                    });
                });
                it ('внутри одинарных кавычек', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', "Восьмой конец 'будет. тут' лежать.Body text.")).to.eql({
                        title: "Title show. – Восьмой конец 'будет. тут' лежать",
                        body: 'Body text.'
                    });
                });
                it ('фигурных, круглых скобок и одинарных кавычек', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', 'Жуткая ( {комбинация. разнообразных.} скобок. "и." кавычек.) проверим.Body text.')).to.eql({
                        title: 'Title show.',
                        body: 'Жуткая ( {комбинация. разнообразных.} скобок. "и." кавычек.) проверим.Body text.'
                    });
                });
                it ('одинарных кавычек, при этом есть слова с апострофом', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', "Тест 'bla r'n'r bl. bla' последний.Body text.")).to.eql({
                        title: "Title show. – Тест 'bla r'n'r bl. bla' последний",
                        body: 'Body text.'
                    });
                });
            });
        });

        describe('Не делает перестановку, но добавляет к заголовку домен (если он есть), ', function() {
            it ('если текст содержит только одно предложение', function() {
                expect(u.preview.serpTitleSubstitution('Title show.', 'Only for you; Body text.', 'ya.ru')).to.eql({
                    title: 'Title show. / ya.ru',
                    body: 'Only for you; Body text.'
                });
            });
            it ('при вхождении первого предложения в заголовок без учета регистра', function() {
                expect(u.preview.serpTitleSubstitution('Title show me.', 'Title Show. Body text', 'ya.ru')).to.eql({
                    title: 'Title show me. / ya.ru',
                    body: 'Title Show. Body text'
                });
            });
            it ('при вхождении заголовка в первое предложение без учета регистра', function() {
                expect(u.preview.serpTitleSubstitution('for YOU', 'Only for you. Body text')).to.eql({
                    title: 'for YOU',
                    body: 'Only for you. Body text'
                });
            });
            it ('если количество символов заголовка и первого предложения = 66', function() {
                expect(u.preview.serpTitleSubstitution('Title show. Haaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa!', 'Body text. Title show.')).to.eql({
                    title: 'Title show. Haaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa!',
                    body: 'Body text. Title show.'
                });
            });
            it ('Количество символов заголовка = 65', function() {
                expect(u.preview.serpTitleSubstitution('Title show. Haaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa!', 'Only for you. Body text')).to.eql({
                    title: 'Title show. Haaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa!',
                    body: 'Only for you. Body text'
                });
            });

            describe('Если в тексте не парное количество', function() {
                it ('круглых скобок', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', 'Only ((for you). Body text')).to.eql({
                        title: 'Title show.',
                        body: 'Only ((for you). Body text'
                    });
                });
                it ('фигурных скобок', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', '{Only for you}}. Body text')).to.eql({
                        title: 'Title show.',
                        body: '{Only for you}}. Body text'
                    });
                });
                it ('знаков меньше, больше', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', 'Only <>>for you). Body text')).to.eql({
                        title: 'Title show.',
                        body: 'Only <>>for you). Body text'
                    });
                });
                it ('ёлочек', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', '«Only for you. Body text»»')).to.eql({
                        title: 'Title show.',
                        body: '«Only for you. Body text»»'
                    });
                });
                it ('двойных кавычек', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', '"Only for you". "Body text')).to.eql({
                        title: 'Title show.',
                        body: '"Only for you". "Body text'
                    });
                });
                it ('одинарных кавычек, исключая апостроф', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', "Mc'Donald создал сеть. Mc'Donald создал 'культуру")).to.eql({
                        title: "Title show.",
                        body: "Mc'Donald создал сеть. Mc'Donald создал 'культуру"
                    });
                });
            });

            describe('Если в тексте не верная комбинация скобок/кавычек', function() {
                it ('двойные кавычки, круглые скобки', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', 'Only ("for you). Body text"')).to.eql({
                        title: 'Title show.',
                        body: 'Only ("for you). Body text"'
                    });
                });
                it ('фигурные скобки, одинарные кавычки, исключая апостроф', function() {
                    expect(u.preview.serpTitleSubstitution('Title show.', "{On'ly for' you}. Body' text")).to.eql({
                        title: 'Title show.',
                        body: "{On'ly for' you}. Body' text"
                    });
                });
            });

            describe('prepareHref', function() {
                var utils = u.preview;

                it('Если передано href без протокола и передан protocol -> protocol + href', function() {
                    expect(utils.prepareHref('yandex.ru', 'https://')).to.equal('https://yandex.ru');
                });

                it('Если передано href без протокола и не передан protocol -> http:// + href', function() {
                    expect(utils.prepareHref('yandex.ru')).to.equal('http://yandex.ru');
                });

                it('Если передано href c протоколом и передан protocol -> href', function() {
                    expect(utils.prepareHref('http://yandex.ru', 'https://')).to.equal('http://yandex.ru');
                });

                it ('должен игнорировать регистр при решении, добавлять ли протокол', function() {
                    expect(utils.prepareHref('hTTp://ya.ru')).to.be.equal('hTTp://ya.ru');
                });
            });

            describe('skipSharpSign', function() {
                var utils = u.preview;

                it('Если в строке есть символы решетки, метод должен их убрать', function() {
                    expect(utils.skipSharpSign('#строка# и #решетки#')).to.equal('строка и решетки');
                });
            });

            describe('strCounterWithoutNarrow', function() {
                var utils = u.preview;

                it('Должен игнорировать символы-исключения во время подсчета', function() {
                    expect(utils.strCounterWithoutNarrow('три!?!?', 10, '!?')).to.equal(7);
                });
            });
        });
    });
});
