describe('i-utils__strategy', function() {

    describe('Описательное имя', function() {
        [
            {
                name: 'default',
                text: 'Ручное управление ставками'
            },
            {
                name: 'different_places',
                text: 'Ручное управление ставками'
            },
            {
                name: 'maximum_clicks',
                text: 'Ручное управление ставками'
            },
            {
                name: 'maximum_coverage',
                text: 'Ручное управление ставками'
            },
            {
                name: 'search_maximum_coverage',
                text: 'Ручное управление ставками'
            },
            {
                name: 'autobudget_avg_cpa',
                text: 'Оптимизация конверсий'
            },
            {
                name: 'autobudget_avg_click',
                text: 'Оптимизация кликов'
            },
            {
                name: 'autobudget_avg_cpi',
                text: 'Оптимизация количества установок приложения'
            },
            {
                name: 'autobudget_roi',
                text: 'Оптимизация рентабельности'
            },
            {
                name: 'autobudget',
                text: 'Оптимизация кликов'
            },
            {
                name: 'autobudget_week_bundle',
                text: 'Оптимизация кликов'
            },
            {
                name: 'autobudget_optimization_cpc',
                text: 'Оптимизация количества кликов'
            },
            {
                name: 'autobudget_optimization_cpa',
                text: 'Оптимизация количества конверсий'
            }
        ].forEach(function(test) {
            it('Для стратегии ' + test.name + ' описательное имя "' + test.text + '"', function() {
                expect(u.strategy.getTitleByName(test.name, 'search', 'text', {})).to.equal(test.text);
            });
        });
    });

    describe('Метод getMinPricePlaceTitle', function() {
            [
                {
                    place: 'both',
                    text: 'в спецразмещении и «гарантии»'
                },
                {
                    place: 'premium',
                    text: 'в спецразмещении'
                }
            ].forEach(function(test) {
                it('Если place == "' + test.place + '", то возвращает ' + test.text, function() {
                    expect(u.strategy.getMinPricePlaceTitle(test.place)).to.equal(test.text);
                })
            })
        });

    describe('Метод getPlatform', function() {
        it('Если is_net_stopped: true, возввращает search', function() {
            expect(u.strategy.getPlatform({
                name: '',
                search: { name: 'autbudget' },
                net: { name: 'stop' }
            }, true)).to.equal('search');
        });

        it('Если different_places, search: stop, возвращает net', function() {
            expect(u.strategy.getPlatform({
                name: 'different_places',
                search: { name: 'stop' },
                net: { name: 'autobudget' }
            }, false)).to.equal('net');
        });

        it('Если different_places, search: name: autobudget, возвращает all', function() {
            expect(u.strategy.getPlatform({
                name: 'different_places',
                search: { name: 'autobudget' },
                net: { name: 'autobudget' }
            }, false)).to.equal('all');
        });

        ['default', 'autobudget_avg_click', 'autobudget_avg_cpa',
        'autobudget_avg_cpi', 'autobudget_roi', 'autobudget', 'autobudget_week_bundle'].forEach(function(name) {
            it('Если не different_places, стратегия: ' + name + ' возвращает all', function() {
                expect(u.strategy.getPlatform({
                    name: '',
                    search: { name: name },
                    net: { name: 'autobudget' }
                }, false)).to.equal('all');
            })
        })
    });

    describe('Метод getNameByPlatform', function() {
        describe('Для автостратегий', function() {
            ['autobudget_avg_click', 'autobudget_avg_cpa', 'autobudget_optimization_cpc', 'autobudget_optimization_cpa',
                'autobudget_avg_cpi', 'autobudget_roi', 'autobudget', 'autobudget_week_bundle'].forEach(function(name) {
                    it('Если не different_places, стратегия: ' + name + ' возвращает ' + name, function() {
                        expect(u.strategy.getNameByPlatform('all', name)).to.equal(name);
                        expect(u.strategy.getNameByPlatform('search', name)).to.equal(name);
                        expect(u.strategy.getNameByPlatform('net', 'different_places', { net: { name: name } }))
                            .to.equal(name);
                    });
                });
        });

        describe('Для ручных стратегий', function() {
            it('На сети стратегия maximum_coverage возвращает maximum_clicks', function() {
                expect(u.strategy.getNameByPlatform('net', 'different_places', { net: { name: 'maximum_coverage' } }))
                    .to.equal('maximum_clicks');
            });

            it('На поиске стратегия search_maximum_coverage возвращает search_maximum_coverage', function() {
                expect(u.strategy.getNameByPlatform('search', 'search_maximum_coverage'))
                    .to.equal('search_maximum_coverage');
            });

            ['default', 'maximum_clicks'].forEach(function(name) {
                it('На всех площадках раздельное ' + name + ' возвращает maximum_clicks', function() {
                    expect(u.strategy.getNameByPlatform('all', 'different_places',
                        { net: { name: name }, search: { name: name } })).to.equal('maximum_clicks');
                });

                it('На всех площадках нераздельное ' + name + ' возвращает maximum_clicks', function() {
                    expect(u.strategy.getNameByPlatform('all', name)).to.equal('maximum_clicks');
                });

                it('На поиске площадках нераздельное ' + name + ' возвращает maximum_clicks', function() {
                    expect(u.strategy.getNameByPlatform('search', name)).to.equal('maximum_clicks');
                });
            });
        });
    });
});
