(function(u) {
    // константы с идентификаторами стратегий
    var STRATEGIES = {
            // Наивысшая доступная позиция
            DEFAULT: 'default',

            // Средняя цена клика
            AUTOBUDGET_AVG_CLICK: 'autobudget_avg_click',

            // Средняя цена конверсии
            AUTOBUDGET_AVG_CPA: 'autobudget_avg_cpa',

            // Средняя цена установки приложения
            AUTOBUDGET_AVG_CPI: 'autobudget_avg_cpi',

            // Средняя рентабельность инвестиций
            AUTOBUDGET_ROI: 'autobudget_roi',

            // Недельный бюджет
            AUTOBUDGET: 'autobudget',

            // Независимое управление для разных типов площадок
            DIFFERENT_PLACES: 'different_places',

            // Недельный пакет кликов
            AUTOBUDGET_WEEK_BUNDLE: 'autobudget_week_bundle',

            // Максимальный доступный охват
            MAXIMUM_COVERAGE: 'maximum_coverage',

            // Максимальный доступный охват на поиске
            SEARCH_MAXIMUM_COVERAGE: 'search_maximum_coverage',

            // Отключены показы
            STOP: 'stop',

            // Оптимизация количества кликов
            AUTOBUDGET_OPTIMIZATION_CPC: 'autobudget_optimization_cpc',

            // Оптимизация количества конверсий
            AUTOBUDGET_OPTIMIZATION_CPA: 'autobudget_optimization_cpa',

            //Максимум кликов по выбранной цене
            MAXIMUM_CLICKS: 'maximum_clicks',

            // Максимально возможный объем показов при выбранных для каждого условия максимальных ценах за тыс. показов
            // (для cpm_banner кампаний)
            CPM_DEFAULT: 'cpm_default',

            // Максимальное количество показов (для cpm_banner кампаний)
            AUTOBUDGET_MAXIMUM_SHOWS: 'autobudget_max_impressions',

            // Максимальный охват (для cpm_banner кампаний)
            AUTOBUDGET_MAXIMUM_COVERAGE: 'autobudget_max_reach',

            // Максимум просмотров видео (для cpm_banner кампаний)
            AUTOBUDGET_AVG_CPV: 'autobudget_avg_cpv'
        },
        MOBILE_CPA_GOAL_ID = '4',
        // Константы идентификаторов платформ
        PLATFORM_TYPES = {
            ALL: 'all',
            SEARCH: 'search',
            NET: 'net'
        },
        // в рамках DIRECT-72782: Бюджет на произвольный период
        // добавлены стратегии которые не размещаются на отдельном табе, а лишь являются частным случаем
        SUB_STRATEGIES_PARENTS = {
            // Максимум показов по минимальной цене «за период»
            autobudget_max_impressions_custom_period: 'autobudget_max_impressions',
            // Снижение цены повторных показов «за период»
            autobudget_max_reach_custom_period: 'autobudget_max_reach',
            // Максимум просмотров видео «за период»
            autobudget_avg_cpv_custom_period: 'autobudget_avg_cpv',
        };

    /**
     * Получение описательного имени стратегии (используется в попапе стратегий)
     * @param {String} strategyName - имя стратегии
     * @param {String} [platform] - платформа
     * @param {String} [mediaType] - тип кампании
     * @param {Object} [options] - настройки стратегии
     * @returns {String}
     */
    function getTitleByName(strategyName, platform, mediaType, options, isChangeManualStrategyName) {
        var isUserInAppEventsInRmpEnabled = u.consts('isUserInAppEventsInRmpEnabled'),
            names = {
                default: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'ruchnoe-upravlenie-stavkami', 'Ручное управление ставками'),
                different_places: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'ruchnoe-upravlenie-stavkami', 'Ручное управление ставками'),
                maximum_clicks: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'ruchnoe-upravlenie-stavkami', 'Ручное управление ставками'),
                cpm_default: iget2('i-utils', 'strategy_title_cpm_default', 'Ручное управление ставками'),
                net_cpm_default: iget2('i-utils', 'strategy_title_net_cpm_default', 'Ручное управление ставками с оптимизацией в сетях'),
                maximum_coverage: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'ruchnoe-upravlenie-stavkami', 'Ручное управление ставками'),

                // заголовки ручных стратегий с разбивкой по платформам
                all_default: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'strategy_title_all_default', 'Ручное управление ставками с оптимизацией в сетях'),
                search_default: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'strategy_title_search_default', 'Ручное управление ставками'),
                net_default: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'strategy_title_net_default', 'Ручное управление ставками с оптимизацией в сетях'),
                all_different_places: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'strategy_title_all_different_places', 'Ручное управление ставками с оптимизацией в сетях'),
                search_different_places: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'strategy_title_search_different_places', 'Ручное управление ставками'),
                net_different_places: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'strategy_title_net_different_places', 'Ручное управление ставками с оптимизацией в сетях'),
                all_maximum_clicks: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'strategy_title_all_maximum_clicks', 'Ручное управление ставками с оптимизацией в сетях'),
                search_maximum_clicks: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'strategy_title_search_maximum_clicks', 'Ручное управление ставками'),
                net_maximum_clicks: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'strategy_title_net_maximum_clicks', 'Ручное управление ставками с оптимизацией в сетях'),

                all_maximum_coverage: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'strategy_title_all_maximum_coverage', 'Ручное управление ставками с оптимизацией в сетях'),
                search_maximum_coverage: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'strategy_title_search_maximum_coverage', 'Ручное управление ставками'),
                net_maximum_coverage: isChangeManualStrategyName
                  ? iget2('i-utils', 'manual-bid-control-with-optimization', 'Ручное управление ставками с оптимизацией')
                  : iget2('i-utils', 'strategy_title_net_maximum_coverage', 'Ручное управление ставками с оптимизацией в сетях'),

                autobudget_avg_click: iget2('i-utils', 'clicks-optimization', 'Оптимизация кликов'),
                autobudget_avg_cpa: iget2('i-utils', 'cpa-optimization', 'Оптимизация конверсий'),
                autobudget_avg_cpi: isUserInAppEventsInRmpEnabled ?
                        iget2('i-utils', 'cpa-optimization', 'Оптимизация конверсий') :
                        iget2('i-utils', 'cpi-optimization', 'Оптимизация количества установок приложения'),
                autobudget_roi: iget2('i-utils', 'roi-optimization', 'Оптимизация рентабельности'),
                autobudget: (options.goal_id || (options.search || {}).goal_id || (options.net || {}).goal_id) ?
                    mediaType === 'mobile_content' ?
                        iget2('i-utils', 'cpi-optimization', 'Оптимизация количества установок приложения') :
                        iget2('i-utils', 'cpa-optimization', 'Оптимизация конверсий') :
                    iget2('i-utils', 'clicks-optimization', 'Оптимизация кликов'),
                autobudget_week_bundle: iget2('i-utils', 'clicks-optimization', 'Оптимизация кликов'),
                autobudget_optimization_cpc: iget2('i-utils', 'optimizaciya-kolichestva-klikov', 'Оптимизация количества кликов'),
                autobudget_optimization_cpa: iget2('i-utils', 'optimizaciya-kolichestva-konversiy', 'Оптимизация количества конверсий'),
                autobudget_max_reach: iget2('i-utils', 'maximum-coverage', 'Снижение цены повторных показов'),
                autobudget_max_reach_custom_period: iget2('i-utils', 'maximum-coverage', 'Снижение цены повторных показов'),
                autobudget_max_impressions: iget2('i-utils', 'maximum-number-impressions', 'Максимум показов по минимальной цене'),
                autobudget_max_impressions_custom_period: iget2('i-utils', 'maximum-number-impressions', 'Максимум показов по минимальной цене'),
                autobudget_avg_cpv: iget2('i-utils', 'maximum-number-views', 'Максимум просмотров за фиксированную цену'),
                autobudget_avg_cpv_custom_period: iget2('i-utils', 'maximum-number-views', 'Максимум просмотров за фиксированную цену')
            };

        return names[platform + '_' + strategyName] || names[strategyName];
    }

    function getDisabledInfo(strategyName) {
        switch (strategyName) {
            case u.strategy.AUTOBUDGET_AVG_CPV:
                return iget2(
                    'i-utils',
                    'disable-info-avg-cpv',
                    'Чтобы выбрать эту стратегию, удалите из кампании группы без видео'
                );
            default:
                return '';
        }
    }

    /**
    * Проверяет, где работает стратегия - на поиске, в сетях или везде
    * Если стратегия different_places, то стратегия будет либо только в сетях (strategy.search.name=='stop') или везде
    * Если не different_places, то показы в сетях могут быть отдельно отключены в настройках для сетей (is_net_stopped)
    * @param {Object} strategy - стратегия
    * @param {Number} isNetStopped - отключены ли показы в сетях
    * @returns {String} тип платформы
    */
    function getPlatform(strategy, isNetStopped) {
        return strategy.name === 'different_places' ?
            (strategy.search.name === 'stop' ? 'net' : 'all') :
            (isNetStopped ? 'search' : 'all');
    }

    /**
     * Получает имя текущей стратегии в зависимости от платформы показа
     * @param {String} platform - платформа
     * @param {String} name - имя стратегии из модели кампании
     * @param {Object} options - опции кампании
     * @returns {*}
     */
    function getNameByPlatform(platform, name, options) {
        var handStrategies = [STRATEGIES.DEFAULT],
            searchName = handStrategies.indexOf(name) >= 0 ? STRATEGIES.MAXIMUM_CLICKS : name;

        switch (platform) {
            case 'net': return options.net.name === STRATEGIES.MAXIMUM_COVERAGE ?
                STRATEGIES.MAXIMUM_CLICKS :
                options.net.name;
            case 'search': return searchName;
            case 'all': return name === STRATEGIES.DIFFERENT_PLACES ? STRATEGIES.MAXIMUM_CLICKS : searchName;
        }
    }

    /**
     * Возвращает имена для выбора места показа по минимальной цене
     * @param {String} place - место
     * @returns {String}
     */
    function getMinPricePlaceTitle(place) {
        return place === 'both' ?
            iget2('i-utils', 'v-specrazmeshchenii-i-laquo-102', 'в спецразмещении и «гарантии»') :
            iget2('i-utils', 'v-specrazmeshchenii-103', 'в спецразмещении');
    }

    /**
     * Возвращает название родительской стратегии
     * @param {String} name - название стратегии
     * @param {Object} _options - опции стратегии
     * @returns {String|undefined}
     */
    function getParent(name, _options) {
        var options = _options || {},
            goal_id = options.goal_id || (options.search || {}).goal_id || (options.net || {}).goal_id;

        if (name === 'autobudget_week_bundle') {
            return 'autobudget_avg_click';
        }
        if (name === 'autobudget') {
            return goal_id ? 'autobudget_avg_cpa' : 'autobudget_avg_click';
        }

        return SUB_STRATEGIES_PARENTS[name];
    }


    /**
     * Подмешивает в цели кампании РМП цели
     * @param {Array} campaignGoals - список целей кампании
     * @param {Boolean} isAdditionalGoalsAvailable - доступны все цели РМП в ТГО
     * @param {String} mediaType - тип кампании
     * @returns {Object}
     * @private
     */
    function addRmpGoals(campaignGoals, isAdditionalGoalsAvailable, mediaType, currentGoalId) {
        var result = u._.cloneDeep(campaignGoals);
        // дополнительные цели по РМП объявлены в bricks
        // source.blocks/b-strategy2-settings/_name/b-strategy2-settings_name_cpi.utils.js
        var goals = u['goalsIdName'],
            technicalGoals = u['techGoalsIdName'];

        if (isRmpGoalsAvailable(mediaType)) {
            if (!isAdditionalGoalsAvailable) {
                result.push({
                    goal_id: u.strategy.MOBILE_CPA_GOAL_ID,
                    goal_name: goals[u.strategy.MOBILE_CPA_GOAL_ID],
                    counter_status: 'Active',
                    goal_status: 'Active'
                })
            } else {
                Object.keys(goals).forEach(function(goalId) {
                    result.push({
                        goal_id: goalId,
                        goal_name: goals[goalId],
                        counter_status: 'Active',
                        goal_status: 'Active'
                    })
                });

                if (u.consts('isTechInAppEventsInRmpEnabled')) {
                    Object.keys(technicalGoals).forEach(function(goalId) {
                        result.push({
                            goal_id: goalId,
                            goal_name: technicalGoals[goalId],
                            counter_status: 'Active',
                            goal_status: 'Active'
                        })
                    });
                } else if (technicalGoals[currentGoalId]) {
                    result.push({
                        goal_id: currentGoalId,
                        goal_name: technicalGoals[currentGoalId],
                        counter_status: 'Active',
                        goal_status: 'Active'
                    });

                }
            }
        }


        return result;
    }

    function convertGoalsToSpecial(goals) {
        return goals.map(function(goal) {
            return {
                id: goal.goal_id,
                name: goal.goal_name,
                goal_type: goal.goal_type,
                parent_goal_id: goal.parent_goal_id
            }
        })

    }

    function isRmpGoalsAvailable(mediaType) {
        return mediaType === 'text' && !!(u.consts('isMobileAppGoalsForTextCampaignAllowed') ||
            u.consts('isMobileAppGoalsForTextCampaignStrategyEnabled'));
    }

    function isConversionsInfoAvailable(mediaType) {
        return mediaType === 'text' || mediaType === 'dynamic' || mediaType === 'performance';
    }

    u.register({
        strategy: u._.extend((u.strategy || {}), STRATEGIES, PLATFORM_TYPES, {
            getTitleByName: getTitleByName,
            getPlatform: getPlatform,
            getNameByPlatform: getNameByPlatform,
            getMinPricePlaceTitle: getMinPricePlaceTitle,
            getParent: getParent,
            MOBILE_CPA_GOAL_ID: MOBILE_CPA_GOAL_ID,
            addRmpGoals: addRmpGoals,
            isRmpGoalsAvailable: isRmpGoalsAvailable,
            convertGoalsToSpecial: convertGoalsToSpecial,
            isConversionsInfoAvailable: isConversionsInfoAvailable,
            getDisabledInfo: getDisabledInfo
        })
    });
})(u);
