describe('i-utils__text', function() {

    describe('Должен вернуть true, если ', function() {

        it('строки полностью совпадают', function() {
            expect(u.text.suggestMatch('Москва', 'Москва')).to.be.equal(true);
        });

        it('строки полностью совпадают, но разных регистрах', function() {
            expect(u.text.suggestMatch('Москва', 'москва')).to.be.equal(true);
        });

        it('строки совпадают в начале', function() {
            expect(u.text.suggestMatch('Москва', 'Мос')).to.be.equal(true);
        });

        it('строки совпадают в начале, но разных регистрах', function() {
            expect(u.text.suggestMatch('Москва', 'мос')).to.be.equal(true);
        });

        it('поиск соответствует одному из слов (превому)', function() {
            expect(u.text.suggestMatch('Москва и область', 'Москва')).to.be.equal(true);
        });

        it('поиск соответствует с учетом пробелов', function() {
            expect(u.text.suggestMatch('Москва и область', 'Москва и')).to.be.equal(true);
        });

        it('поиск соответствует с учетом дефисов', function() {
            expect(u.text.suggestMatch('Ростов-на-Дону', 'ростов-на')).to.be.equal(true);
        });

        it('поиск соответствует с учетом скобок', function() {
            expect(u.text.suggestMatch('Республика Саха (Якутия)', 'Якутия')).to.be.equal(true);
        });

        it('поиск соответствует одному из слов (второму)', function() {
            expect(u.text.suggestMatch('Москва и область', 'область')).to.be.equal(true);
        });

        it('поиск соответствует одному из слов (первому), написанных через дефис', function() {
            expect(u.text.suggestMatch('Ростов-на-Дону', 'ростов')).to.be.equal(true);
        });

        it('поиск соответствует одному из слов (второму), написанных через дефис', function() {
            expect(u.text.suggestMatch('Ростов-на-Дону', 'на')).to.be.equal(true);
        });

        it('поиск соответствует одному из слов (третьему), написанных через дефис', function() {
            expect(u.text.suggestMatch('Ростов-на-Дону', 'дону')).to.be.equal(true);
        });

        it('поиск соответствует двум словам, написанным через дефис', function() {
            expect(u.text.suggestMatch('Ростов-на-Дону', 'на-Дону')).to.be.equal(true);
        });

        it('поиск соответствует двум словам, написанным через пробел', function() {
            expect(u.text.suggestMatch('Еврейская автономная область', 'автономная область')).to.be.equal(true);
        });

        it('поиск соответствует 4 словам, написанным через пробел и дефис', function() {
            expect(u.text.suggestMatch('Санкт-Петербург и Ленинградская область', 'Санкт-Петербург и Ленинградская')).to.be.equal(true);
        });

        it('поиск соответствует 3 словам, написанным через пробел и дефис в начале', function() {
            expect(u.text.suggestMatch('Город Санкт-Петербург и Ленинградская область', 'Город Санкт-Петербург')).to.be.equal(true);
        });

        it('поиск соответствует 4 словам, написанным через пробел и дефис не в начале', function() {
            expect(u.text.suggestMatch('Город Санкт-Петербург и Ленинградская область', 'Санкт-Петербург и Ленинградская')).to.be.equal(true);
        });
    });

    describe('Должен вернуть false, если ', function() {

        it('строки не совпадают', function() {
            expect(u.text.suggestMatch('Москва', 'Воронеж')).to.be.equal(false);
        });

        it('строки совпадают но не вначале слов', function() {
            expect(u.text.suggestMatch('Москва', 'сква')).to.be.equal(false);
        });

    });

});
