(function() {
    var _chunksCache = {},
        _separator = ':';

    /**
     * Разбивает строки вида "Ростов-на-Дону", "Москва и область" на массивы
     * ["ростов", "на", "дону", "ростов:на", "ростов:на:дону", "на:дону"] и
     * ["москва", "и", "область", "москва:и", "москва:и:область", "и:область"]
     * @param {string} text - название региона
     * @returns {Array}
     * @private
     */
    function _getChunks(text) {
        var chunks = [],
            words = text.toLowerCase().split(/\s|-|\(|\)/),
            length = words.length,
            i = 0,
            // создает массивы строк из чанка с переданным индексом + все допустимые продолжения
            // например, для массива чанков "ростов, на, дону" с currentIndex: 1 создаст
            // ["на:дону", "дону"]
            addChunks = function(currentIndex) {
                var res = [],
                    j = currentIndex;

                res.push(words[currentIndex]);

                while(j < length - 1) {
                    j++;

                    res.push(res[res.length - 1] + _separator + words[j]);
                }

                return res;
            };

        while(i < length) {
            chunks = chunks.concat(addChunks(i));

            i++;
        }

        return chunks;
    }

    u.register({
        text: {
            /**
             * Проверяет конкретную строку для саджеста
             * @param {String} text - проверяемая строка
             * @param {String} search - строка поиска
             * @return {Boolean}
             */
            suggestMatch: function(text, search) {
                // преобразуем строку вида "Санкт-Петербург и Ленинградская область" в
                // "санкт:петербург:и:ленинградская:область"
                // Двоеточие нужно, так как во введенной фразе может быть дефис, скобки и пробел одновременно
                search = $.trim(search).toLowerCase().replace(/\s|-|\(|\)/g, _separator);

                if (!_chunksCache[text]) {
                    _chunksCache[text] = _getChunks(text);
                }
                return _chunksCache[text].some(function(word) {return !word.indexOf(search)});
            }
        }
    });
})();
