describe('i-utils__url', function() {

    describe('hasHrefParams', function() {
        it('Должен принимать за параметры шаблон', function() {
            expect(u.hasHrefParams('http://ya.ru?q=##')).to.be.equal(true);
        });

        [
            'param1',
            'param2',
            'source',
            'source_type',
            'position_type',
            'position',
            'keyword',
            'addphrases',
            'campaign_id',
            'ad_id',
            'banner_id',
            'phrase_id',
            'retargeting_id',
            'gbid',
            'device_type'
        ].forEach(function(param) {
            it('Должен принимать за параметр {' + param + '}', function() {
                expect(u.hasHrefParams('http://ya.ru?q={' + param + '}')).to.be.equal(true);
            });

        });

        it('Не должен принимать за параметр произвольную строку в фигурных скобках', function() {
            expect(u.hasHrefParams('http://ya.ru?q={some_string}')).to.be.equal(false);
        });

    });



    describe.skip('formatUrl', function() { //@todo
        var formatUrl = BEM.blocks['i-utils'].formatUrl,
            formatTests = {
                'http://example.com?': {
                    protocol: 'http',
                    host: 'example.com',
                    search: '?',
                    query: {},
                    path: '/'
                },
                'http://example.com?foo=bar#frag': {
                    protocol: 'http',
                    host: 'example.com',
                    hash: '#frag',
                    search: '?foo=bar',
                    query: 'foo=bar',
                    path: '/'
                },
                'http://example.com?foo=@bar#frag': {
                    protocol: 'http',
                    host: 'example.com',
                    hash: '#frag',
                    search: '?foo=@bar',
                    query: 'foo=@bar',
                    path: '/'
                },
                'http://example.com?foo=/bar/#frag': {
                    protocol: 'http',
                    host: 'example.com',
                    hash: '#frag',
                    search: '?foo=/bar/',
                    query: 'foo=/bar/',
                    path: '/'
                },
                'http://example.com?foo=?bar/#frag': {
                    protocol: 'http',
                    host: 'example.com',
                    hash: '#frag',
                    search: '?foo=?bar/',
                    query: 'foo=?bar/',
                    path: '/'
                },
                'http://example.com#frag=?bar/#frag': {
                    protocol: 'http',
                    host: 'example.com',
                    hash: '#frag=?bar/#frag',
                    path: '/'
                },
                'http://google.com" onload="alert(42)/': {

                    protocol: 'http',
                    host: 'google.com',
                    path: '/%22%20onload=%22alert(42)/'
                },
                'http://a.com/a/b/c?s#h': {
                    protocol: 'http',
                    host: 'a.com',
                    path: 'a/b/c',
                    hash: 'h',
                    search: 's'
                },
                // `#`,`?` in path
                '/path/to/%%23%3F+=&.txt?foo=theA1#bar': {
                    query: {
                        foo: 'theA1'
                    },
                    hash: '#bar',
                    path: '/path/to/%%23%3F+=&.txt'
                },

                // `#`,`?` in path + `#` in query
                '/path/to/%%23%3F+=&.txt?foo=the%231#bar': {
                    query: {
                        foo: 'the#1'
                    },
                    hash: "#bar",
                    path: '/path/to/%%23%3F+=&.txt'
                },

                // `?` and `#` in path and search
                'http://ex.com/foo%3F100%m%23r?abc=the%231?&foo=bar#frag': {
                    protocol: 'http:',
                    hostname: 'ex.com',
                    hash: '#frag',
                    search: '?abc=the#1?&foo=bar'
                },

                // `?` and `#` in search only
                'http://ex.com/fooA100%mBr?abc=the%231?&foo=bar#frag': {
                    protocol: 'http:',
                    hostname: 'ex.com',
                    hash: '#frag',
                    search: '?abc=the#1?&foo=bar',
                    path: '/fooA100%mBr'
                }
            };

        Object.keys(formatTests).forEach(function(key) {
            it('must format to ' + key, function() {
                expect(formatUrl(formatTests[key])).to.be.eql(key);
            });
        });
    });

    describe.skip('parseUrl', function() { //@todo
        var parseUrl = BEM.blocks['i-utils'].parseUrl,
            parseTests = {
                '//some_path': {
                    path: '//some_path'
                },
                'HTTP://www.example.com/': {
                    protocol: 'http',
                    host: 'www.example.com',
                    path: '/'
                },
                'HTTP://www.example.com': {
                    protocol: 'http',
                    host: 'www.example.com',
                    path: '/'
                },
                'http://www.ExAmPlE.com/': {
                    protocol: 'http',
                    host: 'www.example.com',
                    path: '/'
                },
                'http://user:pw@www.ExAmPlE.com/': {
                    protocol: 'http',
                    'auth': 'user:pw',
                    host: 'www.example.com',
                    path: '/'
                },
                'http://USER:PW@www.ExAmPlE.com/': {
                    protocol: 'http',
                    'auth': 'USER:PW',
                    host: 'www.example.com',
                    path: '/'
                },
                'http://user@www.example.com/': {
                    protocol: 'http',
                    'auth': 'user',
                    host: 'www.example.com',
                    path: '/'
                },
                'http://user%3Apw@www.example.com/': {
                    protocol: 'http',
                    'auth': 'user:pw',
                    host: 'www.example.com',
                    path: '/'
                },
                'http://x.com/path?that\'s#all, folks': {
                    protocol: 'http',
                    host: 'x.com',
                    search: '?that%27s',
                    query: 'that%27s',
                    path: '/path',
                    hash: '#all,%20folks'
                },
                'HTTP://X.COM/Y': {
                    protocol: 'http',
                    host: 'x.com',
                    path: '/Y'
                },
                // an unexpected invalid char in the hostname.
                'HtTp://x.y.cOm*a/b/c?d=e#f g<h>i': {
                    protocol: 'http',
                    host: 'x.y.com',
                    path: '/*a/b/c',
                    search: '?d=e',
                    query: 'd=e',
                    hash: '#f%20g%3Ch%3Ei'
                },
                // make sure that we don't accidentally lcast the path parts.
                'HtTp://x.y.cOm*A/b/c?d=e#f g<h>i': {
                    protocol: 'http',
                    host: 'x.y.com',
                    path: '/*A/b/c',
                    search: '?d=e',
                    query: 'd=e',
                    hash: '#f%20g%3Ch%3Ei'
                },
                'http://x...y...#p': {
                    protocol: 'http',
                    host: 'x...y...',
                    hash: '#p',
                    path: '/'
                },
                'http://x/p/"quoted"': {
                    protocol: 'http',
                    host: 'x',
                    path: '/p/%22quoted%22'
                },
                '<http://goo.corn/bread> Is a URL!': {
                    path: '%3Chttp://goo.corn/bread%3E%20Is%20a%20URL!'
                },
                'http://www.narwhaljs.org/blog/categories?id=news': {
                    protocol: 'http',
                    host: 'www.narwhaljs.org',
                    search: '?id=news',
                    query: 'id=news',
                    path: '/blog/categories'
                },
                'http://mt0.google.com/vt/lyrs=m@114&hl=en&src=api&x=2&y=2&z=3&s=': {
                    protocol: 'http',
                    host: 'mt0.google.com',
                    path: '/vt/lyrs=m@114&hl=en&src=api&x=2&y=2&z=3&s='
                },
                'http://mt0.google.com/vt/lyrs=m@114???&hl=en&src=api&x=2&y=2&z=3&s=': {
                    protocol: 'http',
                    host: 'mt0.google.com',
                    search: '???&hl=en&src=api&x=2&y=2&z=3&s=',
                    query: '??&hl=en&src=api&x=2&y=2&z=3&s=',
                    path: '/vt/lyrs=m@114'
                },
                'http://user:pass@mt0.google.com/vt/lyrs=m@114???&hl=en&src=api&x=2&y=2&z=3&s=': {
                    protocol: 'http',
                    host: 'mt0.google.com',
                    'auth': 'user:pass',
                    search: '???&hl=en&src=api&x=2&y=2&z=3&s=',
                    query: '??&hl=en&src=api&x=2&y=2&z=3&s=',
                    path: '/vt/lyrs=m@114'
                },
                'file:///etc/passwd': {
                    protocol: 'file:',
                    path: '/etc/passwd',
                    host: ''
                },
                'file://localhost/etc/passwd': {
                    protocol: 'file:',
                    path: '/etc/passwd',
                    host: 'localhost'
                },
                'file://foo/etc/passwd': {
                    protocol: 'file:',
                    path: '/etc/passwd',
                    host: 'foo'
                },
                'file:///etc/node/': {
                    protocol: 'file:',
                    path: '/etc/node/',
                    host: ''
                },
                'file://localhost/etc/node/': {
                    protocol: 'file:',
                    path: '/etc/node/',
                    host: 'localhost'
                },
                'file://foo/etc/node/': {
                    protocol: 'file:',
                    path: '/etc/node/',
                    host: 'foo'
                },
                'http:/baz/../foo/bar': {
                    protocol: 'http',
                    path: '/baz/../foo/bar'
                },
                'http://user:pass@example.com:8000/foo/bar?baz=quux#frag': {
                    protocol: 'http',
                    host: 'example.com:8000',
                    'auth': 'user:pass',
                    port: '8000',
                    hash: '#frag',
                    search: '?baz=quux',
                    query: 'baz=quux',
                    path: '/foo/bar'
                },
                '//user:pass@example.com:8000/foo/bar?baz=quux#frag': {
                    host: 'example.com:8000',
                    'auth': 'user:pass',
                    port: '8000',
                    hash: '#frag',
                    search: '?baz=quux',
                    query: 'baz=quux',
                    path: '/foo/bar'
                },
                '/foo/bar?baz=quux#frag': {
                    hash: '#frag',
                    search: '?baz=quux',
                    query: 'baz=quux',
                    path: '/foo/bar'
                },
                'http:/foo/bar?baz=quux#frag': {
                    protocol: 'http',
                    hash: '#frag',
                    search: '?baz=quux',
                    query: 'baz=quux',
                    path: '/foo/bar'
                },
                'mailto:foo@bar.com?subject=hello': {
                    protocol: 'mailto:',
                    host: 'bar.com',
                    'auth': 'foo',
                    search: '?subject=hello',
                    query: 'subject=hello'
                },
                /*jslint -W107*/
                'javascript:alert(\'hello\');': {
                    protocol: 'javascript:',
                    path: 'alert(\'hello\');'
                },
                'xmpp:isaacschlueter@jabber.org': {
                    protocol: 'xmpp:',
                    host: 'jabber.org',
                    'auth': 'isaacschlueter'
                },
                'http://atpass:foo%40bar@127.0.0.1:8080/path?search=foo#bar': {
                    protocol: 'http:',
                    host: '127.0.0.1:8080',
                    'auth': 'atpass:foo@bar',
                    port: '8080',
                    path: '/path',
                    search: '?search=foo',
                    query: 'search=foo',
                    hash: '#bar'
                },
                'svn+ssh://foo/bar': {
                    host: 'foo',
                    protocol: 'svn+ssh:',
                    path: '/bar'
                },
                'dash-test://foo/bar': {
                    host: 'foo',
                    protocol: 'dash-test:',
                    path: '/bar'
                },
                'dash-test:foo/bar': {
                    host: 'foo',
                    protocol: 'dash-test:',
                    path: '/bar'
                },
                'dot.test://foo/bar': {
                    host: 'foo',
                    protocol: 'dot.test:',
                    path: '/bar'
                },
                'dot.test:foo/bar': {
                    host: 'foo',
                    protocol: 'dot.test:',
                    path: '/bar'
                },
                // IDNA tests
                'http://www.日本語.com/': {
                    protocol: 'http',
                    host: 'www.xn--wgv71a119e.com',
                    path: '/'
                },
                'http://example.Bücher.com/': {
                    protocol: 'http',
                    host: 'example.xn--bcher-kva.com',
                    path: '/'
                },
                'http://www.Äffchen.com/': {
                    protocol: 'http',
                    host: 'www.xn--ffchen-9ta.com',
                    path: '/'
                },
                'http://www.Äffchen.cOm*A/b/c?d=e#f g<h>i': {
                    protocol: 'http',
                    host: 'www.xn--ffchen-9ta.com',
                    path: '/*A/b/c',
                    search: '?d=e',
                    query: 'd=e',
                    hash: '#f%20g%3Ch%3Ei'
                },
                'http://SÉLIER.COM/': {
                    protocol: 'http',
                    host: 'xn--slier-bsa.com',
                    path: '/'
                },
                'http://ليهمابتكلموشعربي؟.ي؟/': {
                    protocol: 'http',
                    host: 'xn--egbpdaj6bu4bxfgehfvwxn.xn--egb9f',
                    path: '/'
                },
                'http://➡.ws/➡': {
                    protocol: 'http',
                    host: 'xn--hgi.ws',
                    path: '/➡'
                },
                'http://bucket_name.s3.amazonaws.com/image.jpg': {
                    protocol: 'http:',
                    host: 'bucket_name.s3.amazonaws.com',
                    hostname: 'bucket_name.s3.amazonaws.com'
                },
                'git+http://github.com/joyent/node.git': {
                    protocol: 'git+http:',
                    host: 'github.com',
                    hostname: 'github.com',
                    path: '/joyent/node.git'
                },
                //if local1@domain1 is uses as a relative URL it may
                //be parse into auth@hostname, but here there is no
                //way to make it work in url.parse, I add the test to be explicit
                'local1@domain1': {
                    path: 'local1@domain1'
                },
                //While this may seem counter-intuitive, a browser will parse
                'www.example.com': {
                    path: 'www.example.com'
                },
                // ipv6 support
                '[fe80::1]': {
                    path: '[fe80::1]'
                },
                'coap://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]': {
                    protocol: 'coap:',
                    host: '[fedc:ba98:7654:3210:fedc:ba98:7654:3210]',
                    path: '/'
                },
                'coap://[1080:0:0:0:8:800:200C:417A]:61616/': {
                    protocol: 'coap:',
                    host: '[1080:0:0:0:8:800:200c:417a]:61616',
                    port: '61616',
                    path: '/'
                },
                'http://user:password@[3ffe:2a00:100:7031::1]:8080': {
                    protocol: 'http',
                    'auth': 'user:password',
                    host: '[3ffe:2a00:100:7031::1]:8080',
                    port: '8080',
                    path: '/'
                },
                'coap://u:p@[::192.9.5.5]:61616/.well-known/r?n=Temperature': {
                    protocol: 'coap:',
                    'auth': 'u:p',
                    host: '[::192.9.5.5]:61616',
                    port: '61616',
                    search: '?n=Temperature',
                    query: 'n=Temperature',
                    path: '/.well-known/r'
                },
                // empty port
                'http://example.com:': {
                    protocol: 'http',
                    host: 'example.com',
                    path: '/'
                },
                'http://example.com:/a/b.html': {
                    protocol: 'http',
                    host: 'example.com',
                    path: '/a/b.html'
                },
                'http://example.com:?a=b': {
                    protocol: 'http',
                    host: 'example.com',
                    search: '?a=b',
                    query: 'a=b',
                    path: '/'
                },
                'http://example.com:#abc': {
                    protocol: 'http',
                    host: 'example.com',
                    hash: '#abc',
                    path: '/'
                },
                'http://[fe80::1]:/a/b?a=b#abc': {
                    protocol: 'http',
                    host: '[fe80::1]',
                    search: '?a=b',
                    query: 'a=b',
                    hash: '#abc',
                    path: '/a/b'
                },
                'http://-lovemonsterz.tumblr.com/rss': {
                    protocol: 'http',
                    host: '-lovemonsterz.tumblr.com',
                    path: '/rss'
                },
                'http://-lovemonsterz.tumblr.com:80/rss': {
                    protocol: 'http',
                    port: '80',
                    host: '-lovemonsterz.tumblr.com:80',
                    path: '/rss'
                },
                'http://user:pass@-lovemonsterz.tumblr.com/rss': {
                    protocol: 'http',
                    'auth': 'user:pass',
                    host: '-lovemonsterz.tumblr.com',
                    path: '/rss'
                },
                'http://user:pass@-lovemonsterz.tumblr.com:80/rss': {
                    protocol: 'http',
                    'auth': 'user:pass',
                    port: '80',
                    host: '-lovemonsterz.tumblr.com:80',
                    path: '/rss'
                },
                'http://_jabber._tcp.google.com/test': {
                    protocol: 'http',
                    host: '_jabber._tcp.google.com',
                    path: '/test'
                },
                'http://user:pass@_jabber._tcp.google.com/test': {
                    protocol: 'http',
                    'auth': 'user:pass',
                    host: '_jabber._tcp.google.com',
                    path: '/test'
                },
                'http://_jabber._tcp.google.com:80/test': {
                    protocol: 'http',
                    port: '80',
                    host: '_jabber._tcp.google.com:80',
                    path: '/test'
                },
                'http://user:pass@_jabber._tcp.google.com:80/test': {
                    protocol: 'http',
                    'auth': 'user:pass',
                    port: '80',
                    host: '_jabber._tcp.google.com:80',
                    path: '/test'
                },
                'http://x:1/\' <>"`/{}|\\^~`/': {
                    protocol: 'http:',
                    host: 'x:1',
                    port: '1',
                    hostname: 'x',
                    path: '/%27%20%3C%3E%22%60/%7B%7D%7C%5C%5E~%60/'
                },
                'http://a@b@c/': {
                    protocol: 'http:',
                    auth: 'a@b',
                    host: 'c',
                    hostname: 'c',
                    path: '/'
                },
                'http://a@b?@c': {
                    protocol: 'http:',
                    auth: 'a',
                    host: 'b',
                    hostname: 'b',
                    path: '/?@c',
                    search: '?@c',
                    query: '@c'
                },
                'http://a\r" \t\n<\'b:b@c\r\nd/e?f': {
                    protocol: 'http:',
                    auth: 'a\r" \t\n<\'b:b',
                    host: 'c',
                    port: null,
                    hash: null,
                    search: '?f',
                    query: 'f',
                    path: '%0D%0Ad/e?f'
                },
                '/foo/bar?baz=quuux#frag': {
                    hash: '#frag',
                    search: '?baz=quux',
                    query: {
                        'baz': 'quuux'
                    },
                    path: '/foo/bar'
                },
                'http://example.com': {
                    protocol: 'http',
                    host: 'example.com',
                    query: {},
                    search: '',
                    path: '/'
                }
            };

        Object.keys(parseTests).forEach(function(key) {
            it('must parse ' + key, function() {
                var actual = parseUrl(key);

                Object.keys(parseTests[key]).forEach(function(valueKey) {
                    expect((actual[valueKey] || '')).to.be.eql(parseTests[key][valueKey]);
                });
            });
        });
    });

    describe('getUrlProtocol', function() {
        it('Должен вернуть http://', function() {
            expect(u.getUrlProtocol('http://ya.ru/')).to.be.eql('http://');
        });
        it('Должен вернуть https://', function() {
            expect(u.getUrlProtocol('https://ya.ru/')).to.be.eql('https://');
        });
        it('Должен вернуть пустую строку', function() {
            expect(u.getUrlProtocol('ya.ru')).to.be.eql('');
        });
    });

});
