(function() {
    //взял отсюда http://blog.mattheworiordan.com/post/13174566389/url-regular-expression-for-links-with-or-without
    var urlRegEx = /((([A-Za-z]{3,9}:(?:\/\/)?)(?:[\-;:&=\+\$,\w]+@)?[A-Za-z0-9\.\-]+|(?:www\.|[\-;:&=\+\$,\w]+@)[A-Za-z0-9\.\-]+)((?:\/[\+~%\/\.\w\-]*)?\??(?:[\-\+=&;%@\.\w]*)#?(?:[\.\!\/\\\w]*))?)/g,
        hrefParams = [
            'param1',
            'param2',
            'source',
            'source_type',
            'position_type',
            'position',
            'keyword',
            'addphrases',
            'campaign_id',
            'ad_id',
            'banner_id',
            'phrase_id',
            'retargeting_id',
            'gbid',
            'device_type'
        ].map(function(param) {
            return '{' + param + '}';
        }),
        hrefParamsRegex = new RegExp(hrefParams.join('|'), 'i');

    u.register({
        /**
         * Говорит, если ли в строке символы шаблона
         * @param {String} str
         * @returns {Boolean}
         */
        hasTemplateSymbols: function(str) {
            return /#[^#]*#/.test(str);
        },

        /**
         * Говорит, есть ли в url параметры-плейсхолдеры (шаблоны или параметры в фигурных скобках)
         * @param {String} url
         * @returns {Boolean}
         */
        hasHrefParams: function(url) {
            return u.hasTemplateSymbols(url) || hrefParamsRegex.test(url);
        },

        /**
         * Парсит url строку
         * @param {String} url
         * @returns {Object}
         */
        parseUrl: function(url) {
            // используется нативный метод trim строки (метод  используется и на клиенте и в bemtree, где нет jQuery)
            // приведение к строке для обратной совместимости с $.trim
            url = ('' + url).trim();

            var keys = ['source', 'protocol', 'authority', 'userInfo', 'user', 'password', 'host', 'port', 'relative', 'path', 'directory', 'file', 'query', 'hash'],
                parser = /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/,
                matched = parser.exec(url),
                result = {},
                queryObj = {},
                i = keys.length;

            while (i--) result[keys[i]] = matched[i] || '';

            result.query && result.query.replace(/(?:^|&)([^&=]*)(?:=?([^&]*))?/g, function(index, key, value) {
                if (!queryObj[key]) {
                    queryObj[key] = value;
                } else if (Array.isArray(queryObj[key])) {
                    queryObj[key].push(value);
                } else {
                    queryObj[key] = [queryObj[key], value];
                }
            });

            result.query = queryObj;

            return result;
        },

        /**
         * Формирует ссылку по переданному объект-описанию
         * @param {Object} urlObject
         * @param {String} [urlObject.protocol] протокол
         * @param {String} [urlObject.host] хост
         * @param {String} [urlObject.port] порт
         * @param {String} [urlObject.path] путь
         * @param {Object} [urlObject.query] объект с хешем параметров: ключи - имена параметров, значения - значения параметров
         * @param {String} [urlObject.hash] "якорь"
         * @param {Boolean} keepEmpty оставлять ли в query параметры со значением undefined или null
         * @returns {String}
         */
        formatUrl: function(urlObject, keepEmpty) {
            urlObject = urlObject || {};

            var protocol = urlObject.protocol || '',
                host = urlObject.host || '',
                port = urlObject.port || '',
                path = urlObject.path || '/',
                query = urlObject.query || '',
                hash = urlObject.hash || '';

            if (protocol && protocol.search('://') !== protocol.length - 3) protocol = protocol + '://';
            if (port && port.charAt(0) !== ':') port = ':' + port;
            if (path && path.charAt(0) !== '/') path = '/' + path;
            if (hash && hash.charAt(0) !== '#') hash = '#' + hash;

            if (query) {
                if (typeof query === 'object') {
                    query = Object.keys(query).map(function(key) {
                        var value = query[key];

                        if (typeof value === 'undefined' || value === null) return null;

                        if (Array.isArray(value)) {
                            return value.map(function(val) {
                                return (val != '' || keepEmpty && key) ? key + '=' + val : key;
                            }).join('&');
                        }

                        return value != '' || keepEmpty ? key + '=' + value : key;
                    }).filter(function(item) { return item !== null; }).join('&');
                }
                if (query.length && query.charAt(0) !== '?') query = '?' + query;
            }

            return protocol + host + port + path + query + hash;
        },

        /**
         * Вытаскивает имя домена из ссылки
         * @param {string} url ссылка
         * @returns {string}
         */
        extractDomain: function(url) {
            return ('' + url).trim().replace(/http(s)?:\/\//, '').replace(/[\/\?].*/, '').replace(/\#.*/, '').replace(/\/$/, '');
        },

        /**
         * Удаляет www из имени домена
         * @param {string} domain домен
         * @returns {string}
         */
        stripWww: function(domain) {
            domain = $.trim(domain).toLowerCase();
            if (domain.match(/^www\..*\./) && !domain.match('^www\\.' + u.commonDomainRegExp + '$')) {
                domain = domain.replace(/^www\./, '');
            }
            return domain;
        },

        /**
         * Удаляет http:// из имени домена
         * @param {String} domain
         * @returns {String}
         */
        stripHttp: function(domain) {
            if (!this.extractDomain(domain)) return '';

            domain = ('' + domain).trim();

            if (domain.match(/^http:\/\/.+/i)) {
                domain = domain.replace(/^^http:\/\//i, '');
            } else if (domain.match(/^https:\/\/.+/i)) {
                domain = domain.replace(/^^https:\/\//i, '');
            }

            return domain;
        },

        /**
         * Заменяет текстовые ссылки на результат работы urlWrapper. В тексте не должно быть html разметки
         * @param {String} text Исходный текст, без разметки
         * @param {function} [urlWrapper] функция замены, должна вернуть текст, который будет вставлен вместо ссылки
         *                                по умолчанию, оборачивает ссылки в <a></a>
         * @returns {String}
         */
        urlify: function(text, urlWrapper) {
            urlWrapper = urlWrapper || function(url) {
                return '<a href="' + url + '">' + url + '</a>';
            };
            return text.replace(urlRegEx, urlWrapper);
        },

        /**
         * Возвращает протокол ссылки или пустую строку
         * @param {String} url - ссылка
         * @returns {String}
         */
        getUrlProtocol: function(url) {
            url = ('' + url).trim();
            if (url.match(/^http:/)) {
                return 'http://';
            } else if (url.match(/^https:/)) {
                return 'https://';
            }

            return '';
        }
    });

}());
