(function() {
    // строка с regexp`ом для IPv6 адреса, отсюда https://github.com/indutny/node-ip
    var ipV6RegExpStr = '(::)?(((\\d{1,3}\\.){3}(\\d{1,3}){1})?([0-9a-f]){0,4}:{0,2}){1,8}(::)?',
        ipV4RegExpStr = '([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})';

    u.register({

        ipV4RegExpStr: ipV4RegExpStr,

        ipV6RegExpStr: ipV6RegExpStr,

        // при использовании IPv6 адреса вместо доменного имени,
        // он должен быть обернут в квадратные скобки RFC2732
        ipV6DomainRegExpStr: '\\[' + ipV6RegExpStr + '\\]',

        /**
         * Проверяет является ли переданная строка валидным IPv4 адресом
         * @param {String} ip адрес
         * @returns {boolean} true если валидный
         */
        isIPv4: function(ip) {
            var bytes_str,
                b,
                ok;

            bytes_str = ip.match(new RegExp('^' + ipV4RegExpStr + '$', 'i'));
            if (!bytes_str) {

                return false;
            }
            for (var i = 1; i <= 4; i++) {
                b = parseInt(bytes_str[i], 10);
                ok = (b <= 255) && !((b > 0) && (bytes_str[i][0] == '0'));
                if (!ok) {

                    return false;
                }
            }

            return true;
        },

        validation: {
            /**
             * Говорит, состоит ли входная строка только из допустимых в объявлениях символов
             * @param {String} str проверяемая строка
             * @returns {Boolean}
             */
            isAllowedForBannerString: function(str) {
                return /^[abcdefghijklmonpqrstuvwxyzABCDEFGHIJKLMONPQRSTUVWXYZабвгдеёжзийклмнопрстуфхцчшщъыьэюяАБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯЄІЇєіїҐґ'ğĞüÜşŞöÖçÇıİ̇âÂîÎûÛéҰҒғӨҢҚҺҮұөңқһүҖҲҳҗӘә[\]0123456789.ҰҒғӨҢҚҺҮұөңқһүҖҲҳҗӘә\-+,. "!?()%$€;:|\/&'*_=#№«» –—−ʻʼ]*$/.test(str);
            },
            /**
             * Говорит, является ли переданная строка url-ом
             * @param {String} url
             * @returns {Boolean}
             */
            isUrl: function(url) {
                u.hrefRegExp = u.hrefRegExp ||
                        (new RegExp('^\\s*(?:https?:\/\/)?' + u.domainRegExpString + '(?:\\s*$|\/|:\\d+|\\?|#)', 'i'));

                return !!url.match(typeof u.hrefRegExp == 'function' ? u.hrefRegExp() : u.hrefRegExp);
            }
        }

    });
})();
