describe('i-utils__validation', function() {
    describe('isEmpty', function() {
        var isEmpty = BEM.blocks['i-utils'].isEmpty;

        it('must treat empty string as empty', function() {
            expect(isEmpty('')).to.be.equal(true);
        });

        it('must treat string of spaces as empty', function() {
            expect(isEmpty('    ')).to.be.equal(true);
        });

        it('must treat string with non-space characters as non-empty', function() {
            expect(isEmpty('  !  ')).to.be.equal(false);
        });

        it('must treat undefined as empty', function() {
            expect(isEmpty(undefined)).to.be.equal(true);
        });

        it('must treat null as empty', function() {
            expect(isEmpty(undefined)).to.be.equal(true);
        });
    });
    //все тесткейсы никогда не поддерживались, когда-то @alkaline показалось хорошей идеей собрать их в одном месте и подумать
    describe('isUrl', function() {
        var isUrl = BEM.blocks['i-utils'].isUrl.bind(BEM.blocks['i-utils']),
            urls = [
                //'//some_path',
                'HTTP://www.example.com/',
                'HTTPS://www.example.com/',
                'HTTP://www.example.com',
                'http://www.ExAmPlE.com/',
                //'http://user:pw@www.ExAmPlE.com/',
                //'http://USER:PW@www.ExAmPlE.com/',
                //'http://user@www.example.com/',
                //'http://user%3Apw@www.example.com/',
                'http://x.com/path?that\'s#all, folks\',',
                'HTTP://X.COM/Y',
                //'HtTp://x.y.cOm*a/b/c?d=e#f g<h>i',
                //'HtTp://x.y.cOm*A/b/c?d=e#f g<h>i',
                //'http://x...y...#p', 'http://x/p/\'quoted\'',
                //'<http://goo.corn/bread> Is a URL!',
                'http://www.narwhaljs.org/blog/categories?id=news',
                'https://www.narwhaljs.org/blog/categories?id=news',
                'http://mt0.google.com/vt/lyrs=m@114&hl=en&src=api&x=2&y=2&z=3&s=',
                'http://mt0.google.com/vt/lyrs=m@114???&hl=en&src=api&x=2&y=2&z=3&s=',
                //'http://user:pass@mt0.google.com/vt/lyrs=m@114???&hl=en&src=api&x=2&y=2&z=3&s=',
                //'file:///etc/passwd',
                //'file://localhost/etc/passwd',
                //'file://foo/etc/passwd',
                //'file:///etc/node/',
               // 'file://localhost/etc/node/',
                //'file://foo/etc/node/',
                //'http:/baz/../foo/bar',
                //'http://user:pass@example.com:8000/foo/bar?baz=quux#frag',
               // '//user:pass@example.com:8000/foo/bar?baz=quux#frag',
               // '/foo/bar?baz=quux#frag',
               // 'http:/foo/bar?baz=quux#frag',
               // 'mailto:foo@bar.com?subject=hello',
                /*jslint -W107*/
              //  'javascript:alert(\'hello\');',
               // 'xmpp:isaacschlueter@jabber.org',
               // 'http://atpass:foo%40bar@127.0.0.1:8080/path?search=foo#bar',
               // 'svn+ssh://foo/bar',
               // 'dash-test://foo/bar',
               // 'dash-test:foo/bar',
               // 'dot.test://foo/bar',
               // 'dot.test:foo/bar',
               // 'http://www.日本語.com/',
               // 'http://example.Bücher.com/',
               // 'http://www.Äffchen.com/',
               // 'http://www.Äffchen.cOm*A/b/c?d=e#f g<h>i',
               // 'http://SÉLIER.COM/',
               // 'http://ليهمابتكلموشعربي؟.ي؟/',
               // 'http://➡.ws/➡',
                'http://bucket_name.s3.amazonaws.com/image.jpg',
               // 'git+http://github.com/joyent/node.git',
               // 'local1@domain1',
               // 'www.example.com',
               // '[fe80::1]',
                //'coap://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]',
                //'coap://[1080:0:0:0:8:800:200C:417A]:61616/',
                //'http://user:password@[3ffe:2a00:100:7031::1]:8080',
                //'coap://u:p@[::192.9.5.5]:61616/.well-known/r?n=Temperature',
                //'http://example.com:',
                //'http://example.com:/a/b.html',
                //'http://example.com:?a=b',
                //'http://example.com:#abc',
                //'http://[fe80::1]:/a/b?a=b#abc',
                //'http://-lovemonsterz.tumblr.com/rss',
                //'http://-lovemonsterz.tumblr.com:80/rss',
                //'http://user:pass@-lovemonsterz.tumblr.com/rss',
                //'http://user:pass@-lovemonsterz.tumblr.com:80/rss',
                'http://_jabber._tcp.google.com/test',
                //'http://user:pass@_jabber._tcp.google.com/test',
                'http://_jabber._tcp.google.com:80/test',
              //  'http://user:pass@_jabber._tcp.google.com:80/test',
                //'http://a@b@c/',
                //'http://a@b?@c'
            ];

        urls.forEach(function(url) {
            it('must consider ' + url + ' to be url', function() {
                expect(isUrl(url)).to.be.equal(true);
            })
        });
    });

    describe('escape', function() {
        var escape = BEM.blocks['i-utils'].escapeHTML.bind(BEM.blocks['i-utils']);

        it('must escape special chars to html entities', function() {
            expect(escape('Curly & Moe')).to.be.equal('Curly &amp; Moe');
            expect(escape('Curly &amp; Moe')).to.be.equal('Curly &amp;amp; Moe');
            expect(escape('<a href=\'http://moe.com\'>Curly & Moe\'s</a>')).to.be.equal('&lt;a href=&#39;http://moe.com&#39;&gt;Curly &amp; Moe&#39;s&lt;/a&gt;');
//            escape(null).must.be.equal(''); //todo?
        });
    });

    describe('emailRegExp', function() {
        var regex = BEM.blocks['i-utils'].emailRegExp(),
            validEmails =[
                "first.last@iana.org", "1234567890123456789012345678901234567890123456789012345678901234@iana.org",
                //"\"first\\\"last\"@iana.org",
                //"\"first@last\"@iana.org",
                //"\"first\\\\last\"@iana.org",
                //"x@x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x2",
                "1234567890123456789012345678901234567890123456789012345678@12345678901234567890123456789012345678901234567890123456789.12345678901234567890123456789012345678901234567890123456789.123456789012345678901234567890123456789012345678901234567890123.iana.org",
                //"first.last@[12.34.56.78]",
                //"first.last@[IPv6:::12.34.56.78]",
                //"first.last@[IPv6:1111:2222:3333::4444:12.34.56.78]",
                //"first.last@[IPv6:1111:2222:3333:4444:5555:6666:12.34.56.78]",
                //"first.last@[IPv6:::1111:2222:3333:4444:5555:6666]", "first.last@[IPv6:1111:2222:3333::4444:5555:6666]",
                //"first.last@[IPv6:1111:2222:3333:4444:5555:6666::]",
                //"first.last@[IPv6:1111:2222:3333:4444:5555:6666:7777:8888]",
                //"first.last@x23456789012345678901234567890123456789012345678901234567890123.iana.org",
                "first.last@3com.com",
                "first.last@123.iana.org",
                //"\"first\\last\"@iana.org",
                //"first.last@[IPv6:1111:2222:3333::4444:5555:12.34.56.78]",
                //"first.last@[IPv6:1111:2222:3333::4444:5555:6666:7777]", "first.last@example.123", "first.last@com",
                //"\"Abc\\@def\"@iana.org",
                //"\"Fred\\ Bloggs\"@iana.org",
                //"\"Joe.\\\\Blow\"@iana.org",
               // "\"Abc@def\"@iana.org",
                //"\"Fred Bloggs\"@iana.org",
                "user+mailbox@iana.org",
                //"customer/department=shipping@iana.org",
                //"$A12345@iana.org",
                //"!def!xyz%abc@iana.org",
                "_somename@iana.org", "dclo@us.ibm.com", "peter.piper@iana.org",
                //"\"Doug \\\"Ace\\\" L.\"@iana.org",
                "test@iana.org", "TEST@iana.org", "1234567890@iana.org", "test+test@iana.org", "test-test@iana.org",
                //"t*est@iana.org",
                //"+1~1+@iana.org", "{_test_}@iana.org", "\"[[ test ]]\"@iana.org",
                "test.test@iana.org",
                //"\"test.test\"@iana.org",
                // "test.\"test\"@iana.org", "\"test@test\"@iana.org",
                "test@123.123.123.x123", "test@123.123.123.123",
                //"test@[123.123.123.123]",
                "test@example.iana.org",
                "test@example.example.iana.org",
                //"\"test\\test\"@iana.org", "test@example", "\"test\\\\blah\"@iana.org",
                //"\"test\\blah\"@iana.org", "\"test\\&#13;blah\"@iana.org", "\"test\\\"blah\"@iana.org",
                //"customer/department@iana.org",
                "_Yosemite.Sam@iana.org",
                //"~@iana.org", "\"Austin@Powers\"@iana.org",
                "Ima.Fool@iana.org",
                //"\"Ima.Fool\"@iana.org",
                //"\"Ima Fool\"@iana.org", "\"first\".\"last\"@iana.org",
                //"\"first\".middle.\"last\"@iana.org", "\"first\".last@iana.org", "first.\"last\"@iana.org",
                //"\"first\".\"middle\".\"last\"@iana.org", "\"first.middle\".\"last\"@iana.org",
                //"\"first.middle.last\"@iana.org", "\"first..last\"@iana.org", "\"first\\\\\\\"last\"@iana.org",
                //"first.\"mid\\dle\".\"last\"@iana.org", "Test.&#13;&#10; Folding.&#13;&#10; Whitespace@iana.org",
                //"\"test&#13;&#10; blah\"@iana.org", "(foo)cal(bar)@(baz)iamcal.com(quux)", "cal@iamcal(woo).(yay)com",
                //"cal(woo(yay)hoopla)@iamcal.com", "cal(foo\\@bar)@iamcal.com", "cal(foo\\)bar)@iamcal.com",
                //"first().last@iana.org", "first.(&#13;&#10; middle&#13;&#10; )last@iana.org",
                //"first(Welcome to&#13;&#10; the (\"wonderful\" (!)) world&#13;&#10; of email)@iana.org",
                //"pete(his account)@silly.test(his host)", "c@(Chris's host.)public.example",
                //"jdoe@machine(comment).  example", "1234   @   local(blah)  .machine .example",
                //"first(abc.def).last@iana.org", "first(a\"bc.def).last@iana.org", "first.(\")middle.last(\")@iana.org",
                //"first(abc\\(def)@iana.org",
                //"first.last@x(1234567890123456789012345678901234567890123456789012345678901234567890).com",
                //"a(a(b(c)d(e(f))g)h(i)j)@iana.org",
                "name.lastname@domain.com",
                //"a@b",
                "a@bar.com",
                //"aaa@[123.123.123.123]", "a@bar",
                "a-b@bar.com",
                //"+@b.c",
                "+@b.com", "a@b.co-foo.uk"//,
                //"\"hello my name is\"@stutter.com", "\"Test \\\"Fail\\\" Ing\"@iana.org", "valid@about.museum",
                //"shaitan@my-domain.thisisminekthx", "foobar@192.168.0.1", "\"Joe\\\\Blow\"@iana.org",
                //"HM2Kinsists@(that comments are allowed)this.is.ok", "user%uucp!path@berkeley.edu",
                //"\"first(last)\"@iana.org",
                //" &#13;&#10; (&#13;&#10; x &#13;&#10; ) &#13;&#10; first&#13;&#10; ( &#13;&#10; x&#13;&#10; ) &#13;&#10; .&#13;&#10; ( &#13;&#10; x) &#13;&#10; last &#13;&#10; (  x &#13;&#10; ) &#13;&#10; @iana.org",
                //"first.last @iana.org", "test. &#13;&#10; &#13;&#10; obs@syntax.com", "\"Unicode NULL \\␀\"@char.com",
                //"cdburgess+!#$%&'*-/=?+_{}|~test@gmail.com", "first.last@[IPv6:::a2:a3:a4:b1:b2:b3:b4]",
                //"first.last@[IPv6:a1:a2:a3:a4:b1:b2:b3::]", "first.last@[IPv6:::]", "first.last@[IPv6:::b4]",
                //"first.last@[IPv6:::b3:b4]", "first.last@[IPv6:a1::b4]", "first.last@[IPv6:a1::]",
                //"first.last@[IPv6:a1:a2::]", "first.last@[IPv6:0123:4567:89ab:cdef::]",
                //"first.last@[IPv6:0123:4567:89ab:CDEF::]", "first.last@[IPv6:::a3:a4:b1:ffff:11.22.33.44]",
                //"first.last@[IPv6:::a2:a3:a4:b1:ffff:11.22.33.44]", "first.last@[IPv6:a1:a2:a3:a4::11.22.33.44]",
                //"first.last@[IPv6:a1:a2:a3:a4:b1::11.22.33.44]", "first.last@[IPv6:a1::11.22.33.44]",
                //"first.last@[IPv6:a1:a2::11.22.33.44]", "first.last@[IPv6:0123:4567:89ab:cdef::11.22.33.44]",
                //"first.last@[IPv6:0123:4567:89ab:CDEF::11.22.33.44]", "first.last@[IPv6:a1::b2:11.22.33.44]",
                //"test@test.com", "test@xn--example.com", "test@Bücher.ch"
            ],
            invalidEmails = [
                "first.last@sub.do,com", "first\\@last@iana.org",
                //"123456789012345678901234567890123456789012345678901234567890@12345678901234567890123456789012345678901234567890123456789.12345678901234567890123456789012345678901234567890123456789.12345678901234567890123456789012345678901234567890123456789.12345.iana.org",
                "first.last",
                //"12345678901234567890123456789012345678901234567890123456789012345@iana.org",
                //".first.last@iana.org", "first.last.@iana.org", "first..last@iana.org", "\"first\"last\"@iana.org",
                "\"\"\"@iana.org", "\"\\\"@iana.org", "\"\"@iana.org", "first\\\\@last@iana.org", "first.last@",
                //"x@x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456789.x23456",
                "first.last@[.12.34.56.78]", "first.last@[12.34.56.789]", "first.last@[::12.34.56.78]",
                "first.last@[IPv5:::12.34.56.78]", "first.last@[IPv6:1111:2222:3333:4444:5555:12.34.56.78]",
                "first.last@[IPv6:1111:2222:3333:4444:5555:6666:7777:12.34.56.78]",
                "first.last@[IPv6:1111:2222:3333:4444:5555:6666:7777]",
                "first.last@[IPv6:1111:2222:3333:4444:5555:6666:7777:8888:9999]",
                "first.last@[IPv6:1111:2222::3333::4444:5555:6666]", "first.last@[IPv6:1111:2222:333x::4444:5555]",
                "first.last@[IPv6:1111:2222:33333::4444:5555]", "first.last@-xample.com",
                //"first.last@exampl-.com",
                //"first.last@x234567890123456789012345678901234567890123456789012345678901234.iana.org",
                "abc\\@def@iana.org", "abc\\\\@iana.org", "Doug\\ \\\"Ace\\\"\\ Lovell@iana.org",
                "abc@def@iana.org", "abc\\\\@def@iana.org", "abc\\@iana.org", "@iana.org", "doug@", "\"qu@iana.org",
                "ote\"@iana.org",
                //".dot@iana.org", "dot.@iana.org", "two..dot@iana.org",
                "\"Doug \"Ace\" L.\"@iana.org", "Doug\\ \\\"Ace\\\"\\ L\\.@iana.org", "hello world@iana.org",
                "gatsby@f.sc.ot.t.f.i.tzg.era.l.d.", "test.iana.org",
                //"test.@iana.org", "test..test@iana.org",
                //".test@iana.org",
                "test@test@iana.org", "test@@iana.org", "-- test --@iana.org", "[test]@iana.org",
                "\"test\"test\"@iana.org", "()[]\\;:,><@iana.org", "test@.", "test@example.", "test@.org",
                //"test@123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012.com",
                "test@[123.123.123.123", "test@123.123.123.123]", "NotAnEmail", "@NotAnEmail",
                "\"test&#13;blah\"@iana.org", "\"test\"blah\"@iana.org",
                //".wooly@iana.org", "wo..oly@iana.org",
                //"pootietang.@iana.org",
                //".@iana.org",
                "Ima Fool@iana.org", "phil.h\\@\\@ck@haacked.com",
                "\"first\\\\\"last\"@iana.org", "foo@[\\1.2.3.4]", "first.\"\".last@iana.org",
                "first\\last@iana.org", "Abc\\@def@iana.org", "Fred\\ Bloggs@iana.org", "Joe.\\\\Blow@iana.org",
                "first.last@[IPv6:1111:2222:3333:4444:5555:6666:12.34.567.89]",
                "\"test\\&#13;&#10; blah\"@iana.org", "{^c\\@**Dog^}@cartoon.com", "\"foo\"(yay)@(hoopla)[1.2.3.4]",
                "cal(foo(bar)@iamcal.com", "cal(foo)bar)@iamcal.com", "cal(foo\\)@iamcal.com",
                //"first(12345678901234567890123456789012345678901234567890)last@(1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890)iana.org",
                "first(middle)last@iana.org",
                "first(abc(\"def\".ghi).mno)middle(abc(\"def\".ghi).mno).last@(abc(\"def\".ghi).mno)example(abc(\"def\".ghi).mno).(abc(\"def\".ghi).mno)com(abc(\"def\".ghi).mno)",
                "a(a(b(c)d(e(f))g)(h(i)j)@iana.org", ".@", "@bar.com", "@@bar.com", "aaa.com", "aaa@.com",
                "aaa@.123", "aaa@[123.123.123.123]a", "aaa@[123.123.123.333]",
                //"a@bar.com.",
                "a@-b.com",
                // "a@b-.com",
                "-@..com", "-@a..com", "invalid@about.museum-", "test@...........com",
                "Invalid \\&#10; Folding \\&#10; Whitespace@iana.org", "test.&#13;&#10;&#13;&#10; obs@syntax.com",
                "\"Unicode NULL ␀\"@char.com", "Unicode NULL \\␀@char.com", "first.last@[IPv6::]",
                "first.last@[IPv6::::]", "first.last@[IPv6::b4]", "first.last@[IPv6::::b4]",
                "first.last@[IPv6::b3:b4]", "first.last@[IPv6::::b3:b4]", "first.last@[IPv6:a1:::b4]",
                "first.last@[IPv6:a1:]", "first.last@[IPv6:a1:::]", "first.last@[IPv6:a1:a2:]",
                "first.last@[IPv6:a1:a2:::]", "first.last@[IPv6::11.22.33.44]", "first.last@[IPv6::::11.22.33.44]",
                "first.last@[IPv6:a1:11.22.33.44]", "first.last@[IPv6:a1:::11.22.33.44]",
                "first.last@[IPv6:a1:a2:::11.22.33.44]", "first.last@[IPv6:0123:4567:89ab:cdef::11.22.33.xx]",
                "first.last@[IPv6:0123:4567:89ab:CDEFF::11.22.33.44]",
                "first.last@[IPv6:a1::a4:b1::b4:11.22.33.44]", "first.last@[IPv6:a1::11.22.33]",
                "first.last@[IPv6:a1::11.22.33.44.55]", "first.last@[IPv6:a1::b211.22.33.44]",
                "first.last@[IPv6:a1::b2::11.22.33.44]", "first.last@[IPv6:a1::b3:]", "first.last@[IPv6::a2::b4]",
                "first.last@[IPv6:a1:a2:a3:a4:b1:b2:b3:]", "first.last@[IPv6::a2:a3:a4:b1:b2:b3:b4]",
                "first.last@[IPv6:a1:a2:a3:a4::b1:b2:b3:b4]", "test@example.com&#10;"
            ];

        validEmails.forEach(function(email) {
            it('should treat ' + email + ' as email', function() {
                expect(regex.test(email)).to.be.equal(true);
            });
        });
        invalidEmails.forEach(function(email) {
            it('should not treat ' + email + ' as email', function() {
                expect(regex.test(email)).to.be.equal(false);
            });
        });
    });

    describe('escapeHTML', function() {
        it ('должна возвращать null при вызове без аргументов', function() {
            expect(u.escapeHTML()).to.be.equal(null);
        });

        it ('должна возвращать undefined при вызове c undefined', function() {
            expect(u.escapeHTML(undefined)).to.be.equal(undefined);
        });

        it ('должна возвращать пустую строку при вызове с null', function() {
            expect(u.escapeHTML(null)).to.be.equal('');
        });

        it ('должна возвращать пустую строку при вызове с пустой строкой', function() {
            expect(u.escapeHTML('')).to.be.equal('');
        });

        it ('должна привести число к строке при вызове с числом', function() {
            expect(u.escapeHTML(42)).to.be.equal('42');
        });

        it ('должна экранировать символы <>&"\'', function() {
            expect(u.escapeHTML('<>&"\'')).to.be.equal('&lt;&gt;&amp;&#34;&#39;');
        });
    });

    describe('isAppId', function() {
        var isAppId = BEM.blocks['i-utils'].isAppId.bind(BEM.blocks['i-utils']),
            ids = {
                valid: [
                    'some.a',
                    'a.application',
                    's.a.i',
                    'some.app',
                    'Some.app',
                    'Som-e.app',
                    'Som-e.ap_p',
                    'Some.APP',
                    'SOME.APP',
                    'some123.app',
                    'some.1app',
                    'some.ap123p',
                    'some.app.identifier',
                    'sOmE.aPp.iDeNtFiEr',
                    'Some.App.Identifier'
                ],
                invalid: [
                    'some',
                    'Some.',
                    '.some.',
                    'some.app.identifier.',
                    '_some.app.identifier',
                    'some._app._identifier',
                    '1some.app',
                    'some.app.',
                    'some.app  '
                ]
            };

        Object.keys(ids).forEach(function(type) {
            ids[type].forEach(function(id) {
                it('must consider ' + id + ' as ' + type, function() {
                    expect(isAppId(id)).to.be.equal(type === 'valid');
                });
            });
        });

    });
});
