(function() {
    u.register({
        isEmpty: function(str) {
            return str === undefined || !!(str + '').match(/^\s*$/);
        },

        emailRegExp: function() {
            return new RegExp('^\\s*[a-z0-9_\\.\\-\\+]+\\@' + u.domainRegExpString + '\\.?\\s*$', 'i');
        },

        isUrl: function(url) {
            var hrefRegExp = new RegExp('^\\s*(?:http(s)?:\/\/)?' + u.domainRegExpString + '(?:\\s*$|\/|:\\d+|\\?|#)', 'i');

            return hrefRegExp.test(url)
        },

        domainRegExpString: '(?:(?:[_a-zа-яёЄІЇєіїҐґ0-9][_a-zа-яёЄІЇєіїҐґ0-9-]*)\\.)+([a-z0-9а-яёЄІЇєіїҐґ]{2,15}|xn--[a-z0-9-]+)',

        escapeHTMLRe:  /[&<>\"\']/g,

        /**
         * Регулярное выражение для проверки корректного именования приложения iOS и Android
         * http://developer.android.com/guide/topics/manifest/manifest-element.html#package
         * https://developer.apple.com/library/ios/documentation/IDEs/Conceptual/AppDistributionGuide/ConfiguringYourApp/ConfiguringYourApp.html
         */
        appIdRegExp: /^([a-zA-Z]([\w-]+)?\.)+[a-zA-Z\d]([\w-]+)?$/,

        escapeHTMLReplacer: function(c) {
            // из-за https://st.yandex-team.ru/DIRECT-54699#1464779175000 добавили условие для <>&
            return u.escapeCharMap[c] || ('&#' + c.charCodeAt(0) + ';');
        },

        /**
         * Экранирует строки до html-безопасного вида
         * @see html2string, html_escape
         * @param {String} str исходная строка
         * @returns {String} html-экранированная строка
         */
        escapeHTML: function(str) {
            if (arguments.length == 0) {
                return null;
            }
            if (str === undefined) {
                return undefined;
            }
            if (!str) {
                return '';
            }
            str = '' + str;
            return str.replace(u.escapeHTMLRe, u.escapeHTMLReplacer);
        },

        escapeCharMap: {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;'
        },

        escapeHTMLSafeReplacer: function(c) {
            return u.escapeCharMap[c] || c;
        },

        /**
         * Нестандартно экранирует html (заменяет символы <, &, >)
         * @param {String} str Текст, в котором нужно заменить символы html
         * @returns {String}
         */
        escapeHtmlSafe: function(str) {
            str = '' + str;

            return str.replace(/[&<>]/g, u.escapeHTMLSafeReplacer);
        },

        /**
         * Говорит, является ли переданная строка корректным
         * идентификатор (some.app.id.identifier)
         * @param {String} string
         * @returns {Boolean}
         */
        isAppId: function(string) {
            return u.appIdRegExp.test(string);
        }
    });
})();
