u.register({

    /**
     * Проверяет находится ли элемент в области просмотра
     * @param {jQuery} elem - элемент
     * @param {jQuery} viewport - область просмотра
     * @returns {Boolean}
     * @private
     */
    inviewport: function(elem, viewport) {
        var elemOffsetTop = elem.offset().top,
            containerOffsetTop = viewport.offset().top;

        return (elemOffsetTop >= containerOffsetTop) && // верхняя граница
            (elemOffsetTop - containerOffsetTop + elem.outerHeight() < viewport.height()); // нижняя граница
    },

    /**
     * Устанавливает скролл в области видимости, так что бы был виден элемент
     * @param {jQuery} elem - элемент
     * @param {jQuery} viewport - область просмотра
     * @param {Object} [params]
     *   @param {Number} [params.over=0] - дополнительное значение прокрутки добавляемое к скроллу
     *   @param {Number} [params.duration=400] - продолжительность анимации
     *   @param {Number} [params.easing] - эффект анимации
     * @param {Function} [callback] - обработчик окончания анимации
     */
    scrollNodeTo: function(elem, viewport, params, callback) {
        if (this.inviewport(elem, viewport)) {
            callback && callback();
            return;
        }

        var elemOffsetTop = elem.offset().top,
            viewportOffsetTop = viewport.offset().top,
            scrollTop = elemOffsetTop - viewportOffsetTop + viewport.scrollTop();

        params = u._.extend({ over: 0, duration: 400 }, params);

        // если элемент находится под нижней границей, скролим его к границе
        if (elemOffsetTop > viewportOffsetTop) {
            scrollTop += elem.outerHeight() - viewport.height() + params.over;
        } else {
            scrollTop -= params.over;
        }

        viewport.animate(
            { scrollTop: scrollTop },
            params.duration,
            params.easing,
            callback
        );
    }

});
