describe('i-utils__web-api-errors', function() {
    describe('makeErrorMapper', function() {
        var makeErrorMapper = u['web-api-errors'].makeErrorMapper;

        [

            {
                title: 'Должен вызывать path, у которого совпадает начало',
                matchers: [{
                    path: ['path'],
                    codes: [
                        'code'
                    ]
                }],
                errObj: {
                    path: 'path.inner',
                    code: 'code'
                },
                call: 0
            },
            {
                title: 'Не должен вызывать path, который включает начало',
                matchers: [
                    {
                        path: ['path', 'inner'],
                        codes: [
                            'code'
                        ]
                    },
                    {
                        path: ['path'],
                        codes: [
                            'code'
                        ]
                    }
                ],
                errObj: {
                    path: 'path',
                    code: 'code'
                },
                call: 1
            },
            {
                title: 'Должен вызывать наиболее длинный path, у которого совпадает начало',
                matchers: [
                    {
                        path: ['path'],
                        codes: [
                            'code'
                        ]
                    },
                    {
                        path: ['path', 'inner'],
                        codes: [
                            'code'
                        ]
                    }
                ],
                errObj: {
                    path: 'path.inner.inner2',
                    code: 'code'
                },
                call: 1
            },
            {
                title: 'Должен вызывать соответствующий path и code message',
                matchers: [{
                    path: ['path'],
                    codes: [
                        'code'
                    ]
                }],
                errObj: {
                    path: 'path',
                    code: 'code'
                },
                call: 0
            },
            {
                title: 'Не должен вызывать не соответствующий path и code message',
                matchers: [
                    {
                        path: ['otherpath'],
                        codes: [
                            'code'
                        ]
                    },
                    {
                        path: ['path'],
                        codes: [
                            'code'
                        ]
                    }
                ],
                errObj: {
                    path: 'path',
                    code: 'code'
                },
                call: 1
            },
            {
                title: 'Должен вызывать сообщение по умолчанию если нет подходящего path',
                matchers: [{
                    path: ['otherpath'],
                    codes: [
                        'code'
                    ]
                }],
                errObj: {
                    path: 'path',
                    code: 'code'
                },
                call: 'default'
            },
            {
                title: 'Должен вызывать сообщение по умолчанию если нет подходящего code',
                matchers: [{
                    path: ['path'],
                    codes: [
                        'other-code'
                    ]
                }],
                errObj: {
                    path: 'path',
                    code: 'code'
                },
                call: 'default'
            },
            {
                title: 'Должен уметь обрабатывать пути с индексами',
                matchers: [{
                    pathGetter: function(idx) { return ['path', idx, 'subpath']; },
                    codes: [
                        'code'
                    ]
                }],
                errObj: {
                    path: 'path[3].subpath',
                    code: 'code'
                },
                call: 0
            },
            {
                title: 'Должен уметь обрабатывать пустой путь',
                matchers: [{
                    path: [],
                    codes: [
                        'code'
                    ]
                }],
                errObj: {
                    path: '',
                    code: 'code'
                },
                call: 0
            }
        ].forEach(function(item) {
            it(item.title, function() {
                var obj = {},
                    messagesSpies = [],
                    defaultMessageSpy = sinon.spy(),
                    mapper = makeErrorMapper(function(opts) {
                        return item.matchers.map(function(m) {
                            if (m.pathGetter) {
                                m.path = m.pathGetter(opts.idx);
                            }

                            m.codes = m.codes.reduce(function(acc, next) {
                                var spy = sinon.spy();

                                messagesSpies.push(spy);
                                acc.push({
                                    code: next,
                                    message: spy
                                });

                                return acc;
                            }, []);

                            return m;
                        });
                    }, defaultMessageSpy);

                mapper({}, item.errObj);

                messagesSpies.forEach(function(spy, index) {
                    expect(spy.called).to.be.eql(index === item.call);
                });

                expect(defaultMessageSpy.called).to.be.eql(item.call === 'default');
            });

        });

        it('Должен передавать в функцию получения сообщения исходный объект и объект ошибки', function() {
            var obj = {},
                errObj = {
                    path: 'path',
                    code: 'code'
                },
                message = sinon.spy(),
                mapper = makeErrorMapper(function(opts) {
                    return [
                        {
                            path: ['path'],
                            codes: [
                                {
                                    code: 'code',
                                    message: message
                                }
                            ]
                        }
                    ];
                }, function() {});

                mapper(obj, errObj);

            expect(message.args[0]).to.be.eql([obj, errObj]);
        });

        it('Должен передавать в функцию получения сообщения по умолчанию исходный объект и объект ошибки', function() {
            var obj = {},
                errObj = {
                    path: 'path',
                    code: 'code'
                },
                defaultMessage = sinon.spy(),
                mapper = makeErrorMapper(function(opts) {
                    return [];
                }, defaultMessage);

                mapper(obj, errObj);

            expect(defaultMessage.args[0]).to.be.eql([obj, errObj]);
        });

    });
});
