BEM.decl('i-utils', {}, {});

(function(global) {
    //Создаем неймспейс для всех утилит
    if (!global.u) global.u = {};

    /**
     * Регистрирует объект в утилитах. Все поля объекта будут доступны через u.имя_поля.
     * Пока что для обратной совместимости сохраняется синтаксис BEM.blocks["i-utils"].имя_поля.
        @param obj - объект, поля которого нужно добавить в утилиты.
     */
    function register(obj) {
        function addWarnings(obj) {
            var result = {};

            for (var name in obj) {
                if (obj.hasOwnProperty(name)) {
                    var val = obj[name];

                    /*jslint -W083*/
                    (function(name, val) {
                        if (name == 'register') {
                            throw 'Cannot register object with name "register". Try another name.';
                        }
                        if (typeof val == 'function') {
                            result[name] = function() {
                                return val.apply(this, arguments);
                            };
                        } else if (typeof val == 'object') {
                            result[name] = addWarnings(val);
                        } else {
                            result[name] = val;
                        }
                    })(name, val);
                }
            }
            return result;
        }
        $.extend(global.u, obj);
        $.extend(BEM.blocks['i-utils'], addWarnings(obj));
    }

    global.u.register = register;
})(this);
