;(function() {
    /**
     * Размеры иконки
     * @type {Object}
     */
    var SIZE = {
            xs: 'size-12',
            ms: 'size-13',
            s: 'size-16',
            m: 'size-18'
        },

        /**
         *
         * @type {Object}
         */
        THEME = {
            info: 'info',
            notice: 'alert',
            alert: 'alert',
            plus: 'plus',
            'alert-white': 'alert-white'
        },

        /**
         * Создает название модификатора для иконки
         * @param size
         * @param theme
         * @returns {{}}
         */
        _createMods = function createMods(size, theme) {
            var mods = {};

            mods[SIZE[size]] = THEME[theme];

            return mods;
        };

    /**
     * @param {String} ctx.size
     * @param {String} ctx.theme
     * @param {String} ctx.text
     *
     * @namespace icon-text
     */
    block('icon-text').content()(
        function() {
            var ctx = this.ctx;

            return [
                {
                    block: 'icon',
                    mix: {
                        block: this.block,
                        elem: 'icon'
                    },
                    mods: _createMods(this.mods.size, this.mods.theme)
                },
                {
                    elem: 'text',
                    tag: 'span',
                    content: ctx.text
                }
            ];
        });
}());
