(function() {

    var HTML = BEM.HTML,
        DOM = BEM.DOM,
        DAYNAMES = [iget2('input', 'pn', 'пн'), iget2('input', 'vt', 'вт'), iget2('input', 'sr', 'ср'), iget2('input', 'cht', 'чт'), iget2('input', 'pt', 'пт'), iget2('input', 'sb', 'сб'), iget2('input', 'vs', 'вс')],
        MONTHNAMES = [
            iget2('input', 'yanvar-190', 'Январь'), iget2('input', 'fevral-191', 'Февраль'), iget2('input', 'mart-192', 'Март'), iget2('input', 'aprel-193', 'Апрель'), iget2('input', 'may-194', 'Май'), iget2('input', 'iyun-195', 'Июнь'), iget2('input', 'iyul-196', 'Июль'),
            iget2('input', 'avgust-197', 'Август'), iget2('input', 'sentyabr-198', 'Сентябрь'), iget2('input', 'oktyabr-199', 'Октябрь'),
            iget2('input', 'noyabr-200', 'Ноябрь'), iget2('input', 'dekabr-201', 'Декабрь')
        ],
        MONTHNAMESINFLECTED = [
            iget2('input', 'yanvarya', 'января'), iget2('input', 'fevralya', 'февраля'), iget2('input', 'marta', 'марта'), iget2('input', 'aprelya', 'апреля'), iget2('input', 'maya', 'мая'), iget2('input', 'iyunya', 'июня'), iget2('input', 'iyulya', 'июля'),
            iget2('input', 'avgusta', 'августа'), iget2('input', 'sentyabrya', 'сентября'),
            iget2('input', 'oktyabrya', 'октября'), iget2('input', 'noyabrya', 'ноября'), iget2('input', 'dekabrya', 'декабря')
        ];

    function compareMonths(a, b) {
        if (a.getFullYear() > b.getFullYear())
            return 1;

        if (a.getFullYear() < b.getFullYear())
            return -1;

        if (a.getMonth() > b.getMonth())
            return 1;

        if (a.getMonth() < b.getMonth())
            return -1;

        return 0;
    }

    DOM.decl({ name: 'input', modName: 'has-calendar', modVal: 'yes' }, {

        onSetMod: {

            js: function() {
                this.__base.apply(this, arguments);

               // перезатираем список месяцев и дней недели локализованными
               this.params.months && (MONTHNAMES = this.params.months);
               this.params.weekDays && (DAYNAMES = this.params.weekDays);

               this.today = new Date();

               this.today.setHours(0);
               this.today.setMinutes(0);
               this.today.setSeconds(0);
               this.today.setMilliseconds(0);

               this._month = new Date(this.today.getTime());
               this._month.setDate(1);

               this.setLimits(
                   this.parseDate(this.params.earlierLimit),
                   this.parseDate(this.params.laterLimit)
               );

               this.bindTo('hint calendar', 'pointerclick', function(e) {
                   e.preventDefault();
               });

               // всегда показывать календарь, если кликнули в поле
               this.bindTo('control', 'pointerclick.calendar', function() {
                   this.showCalendar();
               });

               this.bindTo('calendar', 'pointerclick.calendar', function(e) {
                   e.stopPropagation();
                   this._onCalendarClick();
               });

                this.__self._checkNativeDatepicker() && this._initIosNativeCalendar();

                this.elem('control').on('blur', function() {
                    this._lastActive = null;
                });
            },

            focused: function(mod, newVal, oldVal) {
                if (this.__self._checkNativeDatepicker()) {
                    this._updateHint();

                    return;
                }

                if (this._lastActive === this.elem('control')[0] && newVal === 'yes')
                    return;


                if (this.getMod('disabled') === 'yes' || newVal === oldVal) {
                    return false;
                }

                newVal === 'yes' ?
                    this.showCalendar() :
                    this.hideCalendar();
                newVal === '' && this._setDateOnBlur();

                return this.__base.apply(this, arguments);
            }
        },

        toggleCalendar: function() {
            this._getCalendarPopup().isShown() ?
                this.hideCalendar() :
                this.showCalendar();
        },

        showCalendar: function() {
            this._lastActive = document.activeElement;

            var popup = this._getCalendarPopup();

            this._selected = this.parseDate(this.val());

            if (this._selected && !this._isValidDate(this._selected))
                this._selected = null;

            if (this._selected) {
                this._month = new Date(this._selected.getTime());
                this._month.setDate(1);
            }

            this._buildCalendar();
            popup.show(this.domElem);
        },

        hideCalendar: function() {
            this._getCalendarPopup().hide();
        },

        /**
         * Обработчик клика по контролу инпута
         * @private
         */
        _onCalendarClick: function() {
            if (this.getMod('disabled') !== 'yes') {

                this.toggleCalendar();
                this.setMod('focused', 'yes');
            }
        },

        _setDateOnBlur: function() {
            this._selected = this.parseDate(this.val());

            if (!this._selected) {
                this.val('');
                return;
            }

            if (!this._getCalendarPopup().isShown()) {
                return;
            }

            var day = this._selected,
                dayVal = day.getDate(),
                monthVal = day.getMonth() + 1,
                yearVal = day.getFullYear(),
                dateVal = (dayVal < 10 ? '0' + dayVal : dayVal) + '.' +
                    (monthVal < 10 ? '0' + monthVal : monthVal) + '.' +
                    yearVal;

            this._onChoose(dateVal);
        },

        updateCalendar: function() {
            if (!this._getCalendarPopup().isShown()) {
                // parse user value and show
                this._buildCalendar();
            }
        },

        /**
         * Переопределение метода построения календарика
         * @returns {bem|*|BEM|jQuery}
         * @private
         */
        _buildCalendar: function() {
            var _this = this,
                month = _this._month ? _this._month : u.moment().startOf('month').toDate(),
                calendar,
                title,
                layout,
                controls,
                row,
                rows = [],
                content,
                earlierLimit = _this.earlierLimit,
                laterLimit = _this.laterLimit,
                prevMonth = !earlierLimit || compareMonths(month, earlierLimit) > 0,
                nextMonth = !laterLimit || compareMonths(laterLimit, month) > 0,
                prevYear = !earlierLimit || month.getFullYear() > earlierLimit.getFullYear(),
                nextYear = !laterLimit || month.getFullYear() < laterLimit.getFullYear(),
                yearSwitcher;

            yearSwitcher = [
                { elem: 'arrow-year', elemMods: { direction: 'left', disabled: prevYear ? '' : 'yes' } },
                { elem: 'arrow-year', elemMods: { direction: 'right', disabled: nextYear ? '' : 'yes' } },
                {
                    elem: 'name',
                    content: month.getFullYear()
                }
            ];

            title = {
                elem: 'title',
                content: yearSwitcher.concat([
                    { elem: 'arrow', elemMods: { direction: 'left', disabled: prevMonth ? '' : 'yes' } },
                    { elem: 'arrow', elemMods: { direction: 'right', disabled: nextMonth ? '' : 'yes' } },
                    {
                        elem: 'name',
                        content: MONTHNAMES[month.getMonth()]
                    }
                ])
            };

            controls = {
                elem: 'controls',
                content: [
                    this.getMod('has-clear') === 'yes' && {
                        elem: 'clear',
                        tag: 'a',
                        attrs: { href: '#' },
                        content: iget2('input', 'ochistit', 'Очистить')
                    },
                    {
                        elem: 'today',
                        tag: 'a',
                        attrs: { href: '#' },
                        content: iget2('input', 'segodnya', 'Сегодня')
                    }
                ]

            };

            row = [];

            $.each(DAYNAMES, function(i, name) {
                var dayname = {
                    elem: 'dayname',
                    tag: 'th',
                    content: name
                };

                if (i > 4)
                    dayname.elemMods = {
                        type: 'weekend'
                    };

                row.push(dayname);
            });

            rows.push(row);

            $.each(_this.getCalendar(month), function(i, week) {
                row = [];

                $.each(week, function(i, day) {
                    var off = !_this._isValidDate(day),
                        weekend = i > 4,
                        dayElem,
                        type,
                        state,
                        dayVal,
                        monthVal,
                        yearVal,
                        dateVal;

                    dayElem = {
                        elem: 'day',
                        elemMods: { existed: day ? 'yes' : '' },
                        tag: 'td',
                        content: {
                            elem: 'inner',
                            content: day ? day.getDate() : ''
                        }
                    };

                    if (day && !off) {
                        dayVal = day.getDate();
                        monthVal = day.getMonth() + 1;
                        yearVal = day.getFullYear();
                        dateVal = (dayVal < 10 ? '0' + dayVal : dayVal) + '.' +
                            (monthVal < 10 ? '0' + monthVal : monthVal) + '.' +
                            yearVal;

                        dayElem.attrs = {
                            'data-day': dateVal
                        };
                    }
                    if (off || weekend) {
                        type = weekend ? (off ? 'weekend-off' : 'weekend') : 'off';
                    }

                    if (day && _this._selected && day.getTime() == _this._selected.getTime())
                        state = 'current';

                    if (type || state) {
                        dayElem.elemMods = {};

                        if (type)
                            dayElem.elemMods.type = type;

                        if (state)
                            dayElem.elemMods.state = state;
                    }

                    row.push(dayElem);
                });

                rows.push(row);
            });

            content = [];

            $.each(rows, function(i, row) {
                content.push({
                    elem: 'row',
                    tag: 'tr',
                    content: row
                });
            });

            layout = {
                elem: 'layout',
                tag: 'table',
                attrs: { cellspacing: '0' },
                content: content
            };

            calendar = $(BEMHTML.apply({
                block: 'calendar',
                mods: { theme: 'normal' },
                mix: [{ block: 'input', elem: 'calendar-control' }].concat(this.params.calendarMix || []),
                content: [
                    title,
                    layout,
                    controls
                ]
            })).bem('calendar');

            ['arrow', 'arrow-year'].forEach(function(elem, elemIdx) {

                ['left', 'right'].forEach(function(direction, i) {
                    var arrow = calendar.elem(elem, 'direction', direction);

                    if (calendar.hasMod(arrow, 'disabled', 'yes') || !arrow) return;

                    calendar.bindTo(arrow, 'click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        var step = i ? 1 : -1,
                            cb = elemIdx ? '_switchYear' : 'switchMonth';

                        _this[cb](step);
                    });
                });
            });

            calendar.bindTo('day', 'click', function(e) {
                e.preventDefault();
                e.stopPropagation();

                var date = e.data.domElem.attr('data-day');

                if (date)
                    _this._onChoose(date);
            });

            calendar.bindTo('clear', 'click', function(e) {
                e.preventDefault();
                e.stopPropagation();

                _this._getCalendarPopup().hide();
                _this.val('');
                _this.trigger('choose', null);
            });

            calendar.bindTo('today', 'click', function(e) {
                e.preventDefault();
                e.stopPropagation();

                _this._onChoose(u.moment().startOf('day'));
            });

            _this._getCalendarPopup().setContent(calendar.domElem);

            return calendar;
        },

        _switchYear: function(step) {
            this._month.setFullYear(this._month.getFullYear() + step);

            this._buildCalendar();
        },

        /**
         * Парсит дату с учетом формата
         * @param {String} val дата
         * @returns {Date|null}
         */
        parseDate: function(val) {
            var mDate = u.moment(val, this.params.format);
            return mDate.isValid() ? mDate.toDate() : null;
        },

        /**
         * Обработчик, вызываемый при выборе даты пользователем
         * @param {String} date
         * @private
         */
        _onChoose: function(date) {
            this.setDate(u.moment(date, 'DD.MM.YYYY'));
            this._getCalendarPopup().hide();
        },


        /**
         * Установить дату
         * @param {Object} mDate moment объект даты
         */
        setDate: function(mDate) {
            this.val(mDate.format(this.params.format));
            this.trigger('choose', mDate.toDate());
        },

        /**
         * Возвращает JSON попапа
         *
         * @returns {Object}
         * @private
         */
        _popupBEMJSON: function() {
            var popup = {
                block: 'popup',
                mods: { theme: 'ffffff', adaptive: 'yes' },
                mix: this.params.popupMix,
                js: { directions: this._getPopupDirections() },
                content: [
                    { elem: 'tail' },
                    { elem: 'content' }
                ]
            };

            //перекрываем модификатор adaptive в настройках попапа если он задан у блока input
            popup.mods.adaptive = this.getMod('adaptive') || popup.mods.adaptive;

            return popup;
        },

        /**
         * Возвращает направления раскрытия попапа с выбором даты
         * @returns {Array|String}
         * @private
         */
        _getPopupDirections: function() {
            return this.params.popupDirections || [
                {
                    to: 'bottom',
                    axis: 'left',
                    offset: { right: 10 }
                },
                {
                    to: 'top',
                    axis: 'left',
                    offset: { right: 10 }
                },
                'right',
                'left'
            ]
        },

        destruct: function() {
            this._calendarPopup && this._calendarPopup.destruct();
            this.__prevActiveEl = null;
            this.__base.apply(this, arguments);
        },

        _initIosNativeCalendar: function() {

            this.unbindFrom('control', 'pointerclick.calendar');
            this.unbindFrom('calendar', 'pointerclick.calendar');

            this.domElem.append($('<input class="input__ios-calendar" type="date"/>'));

            // Higlight input
            this.bindTo('ios-calendar', 'focus blur', function(e) {
                this.setMod('focused', e.type === 'focus' ? 'yes' : '');
            });

            // Forwarding date to base input
            this.bindTo('ios-calendar', 'change', function() {
                var nativeVal = this.elem('ios-calendar').val();

                this.setDate(u.moment(nativeVal));
                this._updateHint();
            });
        },

        _getCalendarPopup: function() {

            var _this = this;

            if (!_this._calendarPopup) {
                _this._calendarPopup = $(BEMHTML.apply(this._popupBEMJSON())).bem('popup');

                _this._calendarPopup.bindTo('mousedown', function(e, data) {
                    if (_this._isFocusHackNeed) {
                        _this._isBlurOnCalendar = true;
                    }
                    e.preventDefault();
                });

                _this._calendarPopup.on('outside-click', function(e, domEvent) {
                    $(domEvent.target).closest(_this.domElem.add(_this._calendarPopup)).length && e.preventDefault();
                });
            }

            return _this._calendarPopup;

        },

        switchMonth: function(step) {

            this._month.setMonth(this._month.getMonth() + step);

            // Даём время на проверку клика вне попапа:
            this.afterCurrentEvent(function() {
                this._buildCalendar();
            });

        },

        getCalendar: function(month) {

            var weekDay,
                weeks = [],
                week = new Array(7),
                dateIterator = new Date(month.getTime());

            for (dateIterator.setDate(1); dateIterator.getMonth() == month.getMonth(); dateIterator.setDate(dateIterator.getDate() + 1)) {
                weekDay = (dateIterator.getDay() + 6) % 7; // Получаем 0 - пн, 1 - вт, и т.д.

                week[weekDay] = new Date(dateIterator.getTime());

                if (weekDay == 6) {
                    weeks.push(week);
                    week = new Array(7);
                }
            }

            if (weekDay != 6)
                weeks.push(week);

            return weeks;

        },

        setLimits: function(earlier, later) {

            this.earlierLimit = earlier;
            this.laterLimit = later;

            var value = this.parseDate(this.val());

            if (value && !this._isValidDate(value))
                this.val('');

            if (earlier && compareMonths(this._month, earlier) < 0)
                this._month = new Date(earlier.getTime());

            if (later && compareMonths(later, this._month) < 0)
                this._month = new Date(later.getTime());

            this._month.setDate(1);
        },

        _isValidDate: function(day) {
            return !(this.earlierLimit && day < this.earlierLimit || this.laterLimit && day > this.laterLimit);

        }
    },
    {
        _checkNativeDatepicker: function() {
            var ua = window.navigator.userAgent,
                version = 0,
                match,
                isSupport = false;

            if (typeof this._isNativeDateSupport === 'undefined') {
                try {
                    if (match = ua.match(/iPhone\sOS\s([\d_]+)/)) {
                        version = +match[1].replace(/_/g, '.');
                    } else if (match = ua.match(/iPad.*OS\s([\d_]+)/)) {
                        version = +match[1].replace(/_/g, '.');
                    }

                    isSupport = $('<input>').prop('type', 'date').prop('type') === 'date' &&
                        (version > 5);
                } catch(err) {}

                this._isNativeDateSupport = isSupport;
            }

            return this._isNativeDateSupport;
        }
    });

})();
