/**
 * @event resize-watcher#change
 * @type {Object}
 * @property {Number} width Новое значение ширины
 * @property {Number} height Новое значение высоты
 *
 * @fires resize-watcher#change Событие изменения размеров наблюдаемого блока
 */
BEM.DOM.decl('resize-watcher', {

    onSetMod: {

        js: function() {
            var timeout = this.params.timeout;

            if (!u._.isNull(timeout)) {
                this._onWindowIframeResize = $.throttle(this._onWindowIframeResize, timeout, this);
            }

            this.bindToDomElem(this._getIframeWindow(), 'resize', this._onWindowIframeResize);
        }

    },

    /**
     * Обработчик события resize на окне iframe
     * Тригерит событие change
     * @private
     */
    _onWindowIframeResize: function(e) {
        //если блок удалился, то не надо тригерить change
        if (!this.domElem) return;

        this.trigger('change', this._getWindowSizes(e.target));
    },

    /**
     * Возвращает размеры window внутри `iframe`
     * @param {HTMLElement} nativeIframeWindowDomElem
     * @returns {{width: Number, height: Number}}
     * @private
     */
    _getWindowSizes: function(nativeIframeWindowDomElem) {
        return {
            width: nativeIframeWindowDomElem.innerWidth || this.domElem.width(),
            height: nativeIframeWindowDomElem.innerHeight || this.domElem.height()
        }
    },

    destruct: function() {
        this.domElem.parent().removeData(this.__self.getName());

        this.__base.apply(this, arguments);
    },

    /**
     * Возвращает window ифрейма
     * @returns {jQuery}
     * @private
     */
    _getIframeWindow: function() {
        return $(this.domElem[0].contentWindow.window);
    }

}, {

    /**
     * Создает экземпляр блока
     * @param {Object} params Параметры
     * @param {jQuery|BEM.DOM} params.owner DOM-нода или экземляр блока, изменения размеров которого, нужно отслеживать
     * @param {Number|null} [params.timeout=100] Задержка между сообщениями об изменении размеров
     * @param {Boolean} [params.ignoreWidth=false] Флаг об игнорировании изменений ширины
     * @param {Boolean} [params.ignoreHeight=false] Флаг об игнорировании изменений высоты
     * @static
     * @returns {BEM.DOM}
     */
    getInstance: function(params) {
        // опечатка, надо исправить и удебиться, что ничего не ломается,
        // особенно b-grid в коммандере
        params = u._.assign({
            timeoout: 100,
            ignoreWidth: false,
            ignoreHeight: false
        }, params);

        if (params.owner instanceof BEM.DOM) {
            params.owner = params.owner.domElem;
        }

        if (!(params.owner instanceof $)) {
            throw new Error('Неверный формат параметра `owner`');
        }

        if (params.ignoreWidth && params.ignoreHeight) {
            throw new Error('Нельзя одновременно игнорировать изменения и высоты, и ширины');
        }

        if (!/relative|absolute/.test(params.owner.css('position'))) {
            throw new Error('Блок не будет растягиваться на ширину/высоту родителя, т.к. у родителя не верное позиционирование');
        }

        var blockName = this.getName(),
            ownerData = params.owner.data(blockName),
            watcher;

        if (ownerData && u._.isEqual(ownerData.params, params, this._customCompare)) {
            watcher = ownerData.instance;
        } else {
            watcher = this._createInstance(params);

            params.owner.data(blockName, {
                instance: watcher,
                params: params
            });
        }

        return watcher;
    },

    /**
     * Сравнивает два jQuery-объекта на равенство
     * @param {String|Number|Boolean|jQuery} elem
     * @param {String|Number|Boolean|jQuery} elem2
     * @returns {Boolean|undefined}
     * @static
     * @private
     */
    _customCompare: function(elem, elem2) {
        if (elem instanceof $) {
            return elem.is(elem2);
        }
    },

    /**
     * Добавляет iframe в переданный контекст
     * @param {jQuery} params.owner
     * @param {Number|Null} params.timeout
     * @param {Boolean} params.ignoreWidth
     * @param {Boolean} params.ignoreHeight
     * @returns {BEM}
     * @static
     * @private
     */
    _createInstance: function(params) {
        var blockName = this.getName(),
            html = $(BEMHTML.apply({
                block: blockName,
                js: { timeout: params.timeout },
                mods: params.ignoreWidth || params.ignoreHeight ?
                    { ignore: params.ignoreWidth ? 'width' : 'height' } :
                    {}
            }));

        return this.append(params.owner, html).bem(blockName);
    }

});
