describe('resize-watcher', function() {

    // Между ресайзом окна и событием ресайза iframe внутри окна происходит
    // зажержка на уровне браузера. Поэтому в тестах `tick` не помогал и был заиспользован `done()`
    // поэтому же использовать `tick` для задержек нельзя и приходится использовать `setTimeout`
    var create = function(watcherParams, ownerCss, ownerContent) {
            var ownerDomElem = $(BEMHTML.apply({
                    block: 'b-owner',
                    attrs: {
                        style: 'position: relative; width: 400px; height: 200px;'
                    },
                    content: ownerContent
                })),
                owner = ownerDomElem.css(ownerCss || {}).appendTo($('body')).bem('b-owner'),
                watcher = BEM.blocks['resize-watcher']
                    .getInstance($.extend(watcherParams || {}, { owner: owner }));

            return {
                owner: owner,
                watcher: watcher
            };
        },
        destruct = function(blocks) {
            BEM.DOM.destruct(blocks.owner.domElem);
        };

    it('Проверяем наличие сообщений и значения размеров при изменении ширины', function(done) {
        var blocks = create();

        setTimeout(function() {
            blocks.owner.domElem.width(200);
        }, 0);

        blocks.watcher.on('change', function(e, data) {
            expect(data).to.be.eql({ width: 200, height: 200 });
            destruct(blocks);
            done();
        });
    });

    describe('Проверяем корректность работы при удалении блоков из DOM', function() {
        var sandbox,
            //рандомное большое число
            timeout = 25000000;

        beforeEach(function() {
            sandbox = sinon.sandbox.create({
                useFakeTimers: true
            });
        });

        afterEach(function() {
            // должны отработать afterCurrentEvent
            sandbox.clock.tick(1);
            sandbox.restore();
        });

        it('bugfix DIRECTCLIENT-8669: Если блок удалился в процессе ожидания timeout, тригеррить change не нужно', function() {
            var blocks = create({ timeout: timeout }),
                triggerSpy = sandbox.spy(blocks.watcher, 'trigger');

            //первый обработчик на resize стригеррится сразу же
            blocks.watcher._getIframeWindow().trigger('resize');

            //асинхронное удаление блока
            setTimeout(function() {
               BEM.DOM.destruct(blocks.watcher.domElem)
            }, 1);

            //второй обработчик на resize вызовется после того как пройдет timeout
            //к этому времени блок уже удалиться
            blocks.watcher._getIframeWindow().trigger('resize');

            sandbox.clock.tick(timeout + 1);

            expect(triggerSpy.withArgs('change').callCount).to.be.equal(1);
        });
    });

    it('Проверяем наличие сообщений при добавлении контента в блок', function(done) {
        var blocks = create({}, { width: 20, height: 'auto' }, '123');

        blocks.watcher.on('change', function() {
            destruct(blocks);
            done();
        });

        setTimeout(function() {
            blocks.owner.domElem.prepend('213 123 13123 1231 31231231 13123131 313 131231231 31 13 1231231231 3123123123');
        }, 10);
    });

    it('Частота сообщений не должна быть больше чем переданный `timeout`', function(done) {
        var blocks = create({ timeout: 150 }, { width: 0 }),
            lastTime;

        for (var count = 0; count < 10; count++) {
            setTimeout(function() {
                blocks.owner.domElem.width(u._.random(100));
            }, count * 10);
        }

        blocks.watcher.on('change', function(e, data) {
            if (!lastTime) {
                lastTime = new Date().getTime();
            } else if (new Date() - lastTime >= 150) {
                destruct(blocks);
                done();
            }
        });
    });

    it('При повторном getInstance с теми же параметрами - должен использоваться существующий блок', function() {
        var watcherParams = {
                timeout: null,
                ignoreWidth: true
            },
            blocks = create(watcherParams),
            newWatcher = BEM.blocks['resize-watcher']
                .getInstance($.extend({ owner: blocks.owner.domElem }, watcherParams));

        expect(newWatcher).to.be.equal(blocks.watcher);

        destruct(blocks);
    });

    it('При повторном getInstance с теми же параметрами, но при удалении существующего - должен использоваться новосозданный блок', function() {
        var watcherParams = { timeout: null, ignoreWidth: true },
            blocks = create(watcherParams),
            newWatcher;

        blocks.watcher.destruct();

        newWatcher = BEM.blocks['resize-watcher']
            .getInstance($.extend({ owner: blocks.owner.domElem }, watcherParams));

        expect(newWatcher).to.be.not.equal(blocks.watcher);

        newWatcher.destruct();
        destruct(blocks);
    });

    it('Одновременное игнорирование изменений высоты и ширины - должна быть ошибка', function() {
        expect(function() {
            BEM.blocks['resize-watcher'].getInstance({
                owner: $('<div style="position: relative">'),
                ignoreWidth: true,
                ignoreHeight: true
            });
        }).to.throw(Error);
    });

    it('Добавление блока в элемент с `position: static` - должна быть ошибка', function() {
        expect(function() {
            BEM.blocks['resize-watcher'].getInstance({
                owner: $('<div>')
            });
        }).to.throw(Error);
    });

});
