BEM.decl('tipman', {

    onSetMod: {

        /**
         * {Object} this.params
         * {Object} [this.params.tipMods={theme: 'normal', size: 'xs', autoclosable: 'yes'}] Модификаторы блока tooltip
         * {Object|Object[]} [this.params.tipMix] mix блока tooltip
         * {String|String[]} [this.params.popupDirections] Направления раскрытия подсказки
         * {Boolean|Boolean[]} [this.params.needTail=true] Флаг о том, нужен ли хвостик
         * {Number|Number[]} [this.params.offset] Смещение тултипа
         * {Boolean} [this.params.onScrollClose=true] Флаг о том, что подсказка спрячется при скролле снаружи
         * {Object} [this.params.delay] Задержка перед открытием
         */
        js: function() {
            var params = this.params;

            this._tipMods = u._.extend(
                this.__self.getDefaultTooltipMods(),
                params.tipMods
            );
            this._tipMix = params.tipMix;
            this._popupDirections = params.popupDirections;
            this._needTail = params.needTail;
            this._offset = params.offset;
            this._delay = params.delay;
            this._showingAtOnce = u._.isUndefined(params.delay);
            this._onScrollClose = u._.isUndefined(params.onScrollClose) ? true : params.onScrollClose;
        }

    },

    /**
     * Возвращает текущий инстанс блока tooltip
     * @return {BEM.DOM}
     */
    getTip: function() {
        return this._tip;
    },

    /**
     * Отображает подсказку
     * @param {Object} params
     * @param {jQuery} params.owner К чему нужно показать тултип
     * @param {String|jQuery|Function} params.content Что нужно показать в тултипе
     */
    show: function(params) {
        if (this._showingAtOnce) {
            return this._show(params.owner, params.content);
        }

        this._timer && clearTimeout(this._timer);

        this._timer = setTimeout(function() {
            this._show(params.owner, params.content);
        }.bind(this), this._delay);
    },

    /**
     * Отображает подсказку
     * @param {jQuery} owner
     * @param {String|jQuery|Function} content
     * @private
     */
    _show: function(owner, content) {
        if (this._isShown()) {
            this._tip
                .onFirst('hide', function(e) {
                    // т.к. в popup2 нет события на закрытие - ждем пока закончится анимация
                    setTimeout(function() {
                        BEM.DOM.destruct(e.block.domElem);
                    }.bind(this), 1000);
                })
                .delMod('shown');

            this._tip = null;
        }

        var tip = this._tip || (this._tip = this._generateTip()),
            popup = this._getPopup();

        tip
            .setOwner(owner)
            .setContent(u._.isFunction(content) ? content() : content);

        popup && popup.setMod('on-scroll', this._onScrollClose ? 'close' : '');

        tip.setMod('shown', 'yes');
    },

    /**
     * Скрывает подсказку
     * @return {hide}
     */
    hide: function() {
        this._timer && clearTimeout(this._timer);

        this._tip && this._tip.delMod('shown');

        return this;
    },

    /**
     * Сообщает есть ли сейчас отображающаяся подсказка
     * @return {Boolean}
     * @private
     */
    _isShown: function() {
        var popup = this._getPopup();

        return !!popup && popup.hasMod('visible');
    },

    /**
     * Вернет инстанс попапа (если он есть)
     * @return {null|BEM.DOM}
     * @private
     */
    _getPopup: function() {
        return this._tip && this._tip.findBlockOn('popup2');
    },

    /**
     * Генерирует блок подсказки
     * @return {BEM.DOM}
     * @private
     */
    _generateTip: function() {
        return $(BEMHTML.apply({
            block: 'tooltip',
            js: {
                offset: this._offset,
                to: this._popupDirections
            },
            tail: this._needTail !== false && true,
            mods: this._tipMods,
            mix: this._tipMix
        })).bem('tooltip');
    },

    destruct: function() {
        this._timer && clearTimeout(this._timer);

        // afterCurrentEvent нужен из-за асинхронности в попапе
        this._tip && this.afterCurrentEvent(function() {
            this._tip.domElem && BEM.DOM.destruct(this._tip.domElem);
        });

        return this.__base.apply(this, arguments);
    }

}, {

    /**
     * Набор модификаторов по умолчанию на проекте
     * @static
     * @return {Object}
     */
    getDefaultTooltipMods: function() {
        return {
            theme: 'normal',
            size: 'xs',
            autoclosable: 'yes'
        };
    }

});
