SuperCalendar.prototype.locale = {
    common: function (key) {
        var i;
        this._keysets = {
            title: BEM.I18N('super-calendar', 'title'),
            selectWeek: BEM.I18N('super-calendar', 'choose-week'),
            now: BEM.I18N('super-calendar', 'today'),
            selectionError: BEM.I18N('super-calendar', 'selection-error'),
            submit: {
                show: BEM.I18N('super-calendar', 'submit-show'),
                ok: BEM.I18N('super-calendar', 'submit-ok'),
                select: BEM.I18N('super-calendar', 'submit-select'),
                apply: BEM.I18N('super-calendar', 'submit-apply')
            },
            collapse: BEM.I18N('super-calendar', 'collapse'),
            expand: BEM.I18N('super-calendar', 'expand'),
            close: BEM.I18N('super-calendar', 'close'),
            move: BEM.I18N('super-calendar', 'move'),
            months: [],
            monthsCase: [],
            monthsShort: [],
            firstLetterWeekDay: []
        };
        for (i = 0; i < 7; i++) {
            this._keysets.firstLetterWeekDay[i] = BEM.I18N('i-tanker__days', 'name', {short: true, day: i + 1}).toUpperCase();
        }
        for (i = 0; i < 12; i++) {
            this._keysets.months[i] = BEM.I18N('i-tanker__months', 'n' + (i + 1));
            this._keysets.monthsCase[i] = BEM.I18N('i-tanker__months', 'g' + (i + 1));
            this._keysets.monthsShort[i] = BEM.I18N('i-tanker__months', 'short' + (i + 1));
        }

        this.common = function (key) {
            return this._keysets[key] || key;
        };
        return this.common(key);
    }
};

