//jshint ignore: start
/*
    Супер календарь для Метрики
    версия 1.6 от 17.04.2013
    seles@yandex-team.ru

    TODO
    ----
    1. Поддержка разных форматов дат
    2. Выбор нескольких периодов
    3. Выбор одного дня
    4. Документация + примеры
    5. Перемещение периода (синей полоски)
    6. Попапы при наведении на маркированную дату
    7. Выделение даты при перемещении мышки
    8. API

    Зависимости:
    ------------
    - >= jQuery 1.8.2
    - $.browser (jQuery 2.0)
    - jquery.mousewheel.js
    - локаль к календарю - super_calendar_locale.js

    Дополнительно:
    --------------
    - база выходных по Яндекс.Календарю для ru, ua, tr
        https://svn.yandex.ru/websvn/wsvn/conv/branches/standalone/frontend/js/holidays/holidays.js

        Скрипт для генерации выходных
        https://svn.yandex.ru/websvn/wsvn/conv/branches/standalone/frontend/js/holidays/build.js


    Поддерживаемые браузеры:
    ------------------------
    - IE 9 и выше;
    - современные браузеры (Firefox, Chrome, Opera, Safari).

    Также следует не забыть подключить CSS и картинки

    Пример:
    -------
    var sc = new SuperCalendar({
        markedDate: {
            '11.09.2010': 'Hello world!',
            '12.11.2011': 'Example'
        }, // Помечать определенные даты
        mix: 'block__elem', // Строка, будет добавлена к классу календаря через пробел
        shadowMix: 'block__shadow-elem', // Строка, будет добавлена к классу паранжи через пробел
        title: 'test' // Ключ тайтла из локали для календаря, false если тайтл не нужно отображать
        disabledDates: ['30.01.2008', '01.04.2009', '02.04.2009'] // Заблокированные для выбора даты, отключает selectorWeeks и selectorMonths
        selectorWeeks: true, // Быстрый выбор недели
        selectorMonths: true, // Быстрый выбор месяца
        resize: true, // Возможность изменять размер календаря
        animation: true, // Анимация, в IE не поддерживается
        speedAnimation: 'fast' // Скорость анимации: slow, normal, fast
        minYear: 2008, // Ниже этого года дату не отображать
        maxYear: 2013, // Выше этого года дату не отображать
        minDate: '20.01.2008', // Минимальная дата, всё что младше затеняется серым текстом и не выбирается
        maxDate: '01.05.2009', // Максимальная дата, всё что старше затеняется серым текстом и не выбирается
        minGrayDate: '30.01.2008', // Всё что младше затеняется серым текстом
        maxGrayDate: '01.04.2009', // Всё что старше затеняется серым текстом
        shadow: false, // Затеняющая весь контент тень при открытии календаря
        opacityShadow: 0.2 // Прозрачность тени
        center: true, // Центровка по ширине окна браузера
        submitButton: 'show', // Название кнопки выбора даты
        mousewheel: true, // Поддержка колесика мышки для изменение даты в календаре
        buttons: {
            close: true, // Кнопка закрытия календаря
            maximize: true // Кнопка раскрытия календаря на весь экран
        },
        touch: false, // Поддержка тач-устройств (таскание окна и изменение размеров). Указывать true необходимо только для тач-устройств (iPhone, iPad, Android)
        period: period, // Выбранный период
        onSelect: onSelect, // callback, при выборе даты получает дату, нажатую кнопку и отформатированную дату
        calledElement: calledElement, // Элемент при клике, вызывающий календарь
        positionElement: positionElement // Календарь позиционируется относительно этого элемента. Если null - то по центру вьюпорта
    });

    <div class="b-super-calendar__selector g-js" onclick="return {'name': 'b-super-calendar__selector', minYear: 2008, minDate: '01.01.2008'}">Отчетный период: <button><span></span><i class="b-super-calendar__selector-i"></i></button>
        <input name="date1" type="hidden" value="" />
        <input name="date2" type="hidden" value="" />
    </div>
*/

$.fn.findAtText = function (query, text) {
    var res = $([]);
    $(query, this).each(function () {
        if (this.innerHTML === text.toString()) {
            res = $(this);
            return false;
        }
    });

    return res;
};

function SuperCalendar(prefs) {
    var namespace = 'super-calendar',
        that = this,
        buttons = '',
        template,
        bemjson,
        mix, shadowMix,
        title = '';

    that._namespace = namespace + '__';
    that._namespaceEvent = '.' + namespace;
    that._namespaceClassname = '.' + namespace + '__';

    if (!prefs) {
        return;
    }

    that._initPrefs(prefs);

    if (that.prefs.buttons.maximize) {
        buttons += '<span class="{n}max-min" title="' + that.getString('expand') + '"></span>';
    }

    if (that.prefs.buttons.close) {
        buttons += '<span class="{n}close" title="' + that.getString('close') + '"></span>';
    }

    bemjson = {
        cls: '{n}submit-dates',
        content: [
            {
                block: 'input',
                mods: {
                    size: 's',
                    theme: 'normal',
                    clear: 'no'
                },
                cls: '{n}from-block',
                content: {
                    elem: 'control',
                    cls: '{n}from',
                    attrs: {
                        maxlength: 10
                    }
                }
            },
            {
                tag: 'span',
                content: '—'
            },
            {
                block: 'input',
                mods: {
                    size: 's',
                    theme: 'normal',
                    clear: 'no'
                },
                cls: '{n}to-block',
                content: {
                    elem: 'control',
                    cls: '{n}to',
                    attrs: {
                        maxlength: 10
                    }
                }
            },
            {
                block: 'button',
                mods: {
                    size: 's',
                    theme: 'action'
                },
                cls: '{n}show',
                content: that.getString('submit')[that.prefs.submitButton]
            }

        ]
    };

    if (that.prefs.title !== false){
        title = '<span class="{n}title">' + that.getString(that.prefs.title || 'title') + '</span>';
    }
    mix = that.prefs.mix ? ' ' + that.prefs.mix : '';
    shadowMix = that.prefs.shadowMix ? ' ' + that.prefs.shadowMix : '';
    template = '<div class="' + namespace + mix + '">'
            + (that.prefs.resize ? '<div class="{n}resizer"></div>' : '')
            + '<div class="{n}head">'+ title + buttons + '</div>'
            + '<div class="{n}years"><div class="{n}years-inner">' + that._selectorYears() + '</div></div>'
            + '<div class="{n}days"><table></table></div>'
            + '<div class="{n}submit-shadow"></div>'
            + BEMHTML.apply(bemjson) +
            + '</div>';
    that.jElement = $(that._beforePaste(template)).appendTo('body');
    if (prefs.shadow) {
        that.jShadow = $(that._beforePaste('<div class="{n}shadow' + shadowMix + '"></div>')).appendTo('body');
    } else {
        that.jShadow = null;
    }

    that._cacheMonths = {
        current: null
    };

    that._cacheElements();
    that._initPeriod(prefs);
    that.updateDate();

    that._bufferEvents = [];
    that._initResizer();
    that._initDragger();
    that._events();

    that.jElement.hide();

    if ($.browser.msie) { // MSIE не рисует градиенты, делаем градиенты с помощью картинок
        that.jElement.addClass('super-calendar_browser_msie').addClass(that._namespace + 'msie');
    }

    that.jElement.addClass(that.prefs.touch ? that._namespace + 'touch' : that._namespace + 'untouch');
    that.jElement.addClass(that.prefs.single ? that._namespace + 'single' : that._namespace + 'range');
}

SuperCalendar.prototype = {
    lang: 'ru',
    locale: {},
    holidays: BEM.blocks['i-holidays'] && BEM.blocks['i-holidays'].HOLIDAYS || {},
    daysMonth: [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],
    selectedStep: 0,
    minMonth: 0,
    maxMonth: 11,
    cellWidthMonth: 4,
    cellHeightMonth: 1,
    minCellWidthMonth: 3,
    minCellHeightMonth: 1,
    maxCellWidthMonth: 30,
    maxCellHeightMonth: 20,
    WIDTH_MONTH: 10,
    WIDTH_YEAR: 120,
    MS_DAY: 3600000 * 24,
    DAYS_PADDING_BOTTOM: 30,
    getString: function (id) {
        if (this.locale[this.lang]) {
            return this.locale[this.lang][id];
        } else if (this.locale.common) {
            return this.locale.common(id);
        }

        return '';
    },

    setPeriod: function (period) {
        this.prefs.period = period;

        this._selectPeriod(period);
        this._initPeriod(this.prefs);

        if (this.selectedPeriod.from && this.selectedPeriod.to) {
            this._fineSelectedPeriod();
            this._setDraggerAtBeginDate();
            this.updateDate();
        }
    },

    _initPrefs: function (prefs) {
        var that = this,
            curYear = that._currentYear();

        that.prefs = {};
        that._prefs = prefs;

        that.positionElement = prefs.positionElement ? $(prefs.positionElement) : null;
        that.calledElement = prefs.calledElement ? $(prefs.calledElement) : null;

        that._setPrefs('speedAnimation', 'fast');

        that._setPrefs('title', 'title');
        that._setPrefs('touch', false);
        that._setPrefs('animation', false);
        that._setPrefs('submitButton', 'show');
        that._setPrefs('resize', true);
        that._setPrefs('center', true);
        that._setPrefs('onSelect', function () {});
        that._setPrefs('shadow', false);
        that._setPrefs('opacityShadow', 0.2);
        that._setPrefs('selectorWeeks', false);
        that._setPrefs('selectorMonths', true);
        that._setPrefs('markedDate', null);
        that._setPrefs('disabledDates', []);
        that._setPrefs('mix', '');
        that._setPrefs('shadowMix', '');

        if (that.prefs.disabledDates.length !== 0) {
            that.prefs.selectorWeeks = false;
            that.prefs.selectorMonths = false;
        }

        that._setPrefs('mousewheel', true);

        that.prefs.minYear = prefs.minYear || curYear - 10;
        that.prefs.maxYear = prefs.maxYear || curYear + 1;

        prefs.minDate = that._prepareMinDate(prefs.minDate || ('01.01.' + that.prefs.minYear)); // 1 января minYear
        that._setPrefs('minDate', null);

        prefs.maxDate = that._prepareMaxDate(prefs.maxDate || ('01.01.' + that.prefs.maxYear)); // 1 января maxYear
        that._setPrefs('maxDate', null);

        prefs.minGrayDate = that._prepareMinDate(prefs.minGrayDate);
        that._setPrefs('minGrayDate', null);

        prefs.maxGrayDate = that._prepareMaxDate(prefs.maxGrayDate);
        that._setPrefs('maxGrayDate', null);

        that._setPrefs('buttons', {close: true, maximize: true});

        that._setPrefs('single', false);
    },

    _prepareMinDate: function (minDate) {
        if (typeof minDate === 'string') {
            minDate  = this._textToDate(minDate);
        }

        return minDate;
    },
    _prepareMaxDate: function (maxDate) {
        if (maxDate === 'tomorrow') {
            maxDate = this._tomorrow();
        } else if (typeof maxDate === 'string') {
            maxDate  = this._textToDate(maxDate);
        }

        return maxDate;
    },
    _yesterday: function (d) {
        var date, obj;

        if (typeof d === 'undefined') {
            date = new Date();
        } else {
            date = new Date(d.year, d.month, d.day);
        }

        date.setHours(12);
        date.setTime(date.getTime() - this.MS_DAY);
        obj = {day: date.getDate(), month: date.getMonth(), year: date.getFullYear()};
        obj.text = this._dateToText(obj);

        return obj;
    },
    _tomorrow: function (d) {
        var date, obj;

        if (typeof d === 'undefined') {
            date = new Date();
        } else {
            date = new Date(d.year, d.month, d.day);
        }

        date.setHours(12);
        date.setTime(date.getTime() + this.MS_DAY);
        obj = {day: date.getDate(), month: date.getMonth(), year: date.getFullYear()};
        obj.text = this._dateToText(obj);

        return obj;
    },
    _currentYear: function () {
        return (new Date()).getFullYear();
    },
    _setPrefs: function (prop, defaultValue) {
        this.prefs[prop] = typeof this._prefs[prop] !== 'undefined' ? this._prefs[prop] : defaultValue;
    },
    _recalcDate: function (date) {
        var day, month, year, buf, obj, text = '';

        if (date.text) {
            text = date.text;
        } else if (typeof date === 'string') {
            text = date;
        }

        if (text) {
            buf = this._prepareTextDate(text).split('.');
            day = parseInt(buf[0], 10);
            month = parseInt(buf[1], 10) - 1;
            year = parseInt(buf[2], 10);
        } else {
            day = date.day;
            month = date.month;
            year = date.year;
        }

        obj = {
            day: day,
            month: month,
            year: year,
            text: text
        };

        obj.text = this._dateToText(obj);

        return obj;
    },
    _isCorrectDates: function (from, to, minDate, maxDate) {
        if (!from || !to) {
            return false;
        }

        if (minDate && this._cmpDates(minDate, to) === 1) {
            return false;
        }

        if (maxDate && this._cmpDates(from, maxDate) === 1) {
            return false;
        }

        return this._cmpDates(from, to) !== 1;


    },
    _correctMinDate: function (from, minDate) {
        from = this._recalcDate(from);
        minDate = this._recalcDate(minDate);
        if (minDate) {
            if (this._cmpDates(minDate, from) === 1) {
                from = minDate;
            }
        }

        return from;
    },
    _correctMaxDate: function (to, maxDate) {
        var bufTo = this._recalcDate(to);
        if (maxDate) {
            if (this._cmpDates(maxDate, bufTo) === -1) {
                bufTo = this._yesterday(maxDate);
            }
        }

        return bufTo;
    },
    _howManyMonths: function (period) {
        return (period.to.month + 12 * period.to.year) - (period.from.month + 12 * period.from.year);
    },
    _initPeriod: function (prefs) {
        this.selectedPeriod = {
            to: null,
            from: null
        };

        if (!prefs.period) {
            return;
        }

        if (this._isCorrectDates(prefs.period.from, prefs.period.to, this.prefs.minDate, this.prefs.maxDate)) {
            this.selectedPeriod.from = this._correctMinDate(prefs.period.from, this.prefs.minDate);
            this.selectedPeriod.to = this._correctMaxDate(prefs.period.to, this.prefs.maxDate);
            this.jFrom.val(this._dateToText(this.selectedPeriod.from));
            this.jTo.val(this._dateToText(this.selectedPeriod.to));
        }

        var from = this.selectedPeriod.from,
            d;
        if (from) {
            this._fineSelectedPeriod();
        } else {
            d = new Date();
            this.beginDate = {
                day: d.getDate(),
                month: d.getMonth(),
                year: d.getFullYear()
            };
        }

        this._oldSelectedPeriod = this.selectedPeriod;
    },
    _fineSelectedPeriod: function () { // Для удобства, смещаем выбранную дату, чтобы можно было выбрать и прошлое время
        var from = this.selectedPeriod.from,
            months = this._howManyMonths(this.selectedPeriod),
            tableMonths = this.cellHeightMonth * this.cellWidthMonth;

        if (months >= tableMonths) {
            this.beginDate = from;
        } else {
            this.beginDate = this._addMonths(from.month, from.year, -Math.floor((tableMonths - months) / 2));
        }
    },
    _cacheElements: function () {
        var context = this.jElement,
            that = this,
            _namespace = that._namespace,
            f = function (q) {
                return $('.' + _namespace + q, context);
            };

        that.jFrom = f('from');
        that.jTo = f('to');
        that.jShow = f('show');
        that.jMaxmin = f('max-min');
        that.jClose = f('close');
        that.jHead = f('head');
        that.jSubmitShadow = f('submit-shadow');
        that.jResizer = f('resizer');
        that.jDays = f('days');
        that.jYears = f('years');
        that.jSelectedStart = null;
        that.jSelectedEnd = null;
        that.jYearsSelectedPeriod = f('years-period');
        that.jYearsContainer = f('years-selector-container');
        that.jYearsSelector = f('years-selector');
        that.jYearsDragger = f('years-dragger');
    },
    _events: function () {
        var that = this,
            VK_ENTER = 13,
            VK_CURSOR_UP = 38,
            VK_CURSOR_DOWN = 40,
            oldLeft = null,
            oldTop = null,
            oldWidth = null,
            oldHeight = null,
            oldCellWidthMonth = 0;


        // Выбор года
        that.jYearsContainer.on('click', 'div' + that._namespaceClassname + 'year', function () {
            var year = parseInt($(this).html(), 10),
                res = that._addMonths(1, year, -Math.floor(that.cellHeightMonth * that.cellWidthMonth / 2)),
                buf;

            if (year === that.prefs.minYear) {
                res = {
                    month: 0,
                    year: year
                };
            }

            if (year === that.prefs.maxYear) {
                buf = that.cellHeightMonth * that.cellWidthMonth;
                if (buf > 12) {
                    buf = 12;
                }

                res = that._addMonths(1, year, -Math.floor(buf) - 1);
            }

            that.beginDate = {
                day: 1,
                month: res.month,
                year: res.year
            };

            that._setDraggerAtYear(year);
            that.updateDate();
            that._selectPeriod(that.selectedPeriod);
            that._updateSelectorDateContainer(that.prefs.animation);
        });

        // Клик на временной линии
        that.jYearsContainer.on('click', 'div' + that._namespaceClassname + 'years-line', function (e) {
            that._setDraggerAtX(e.pageX);
            that.beginDate = that._whatDraggerDate();
            that.updateDate();
            that._selectPeriod(that.selectedPeriod);
            that._updateSelectorDateContainer(that.prefs.animation);
        });

        // Выделяем весь месяц
        that.jDays.on('click', 'th' + that._namespaceClassname + 'month', function () {
            var $this = $(this);

            if ($this.hasClass(that._namespace + 'selector-month-disabled')) {
                return;
            }

            var text = $('b', this).html().split('.'),
                month = parseInt(text[0], 10),
                year = parseInt(text[1], 10),
                minDay = 0,
                maxDay = 0,
                minDate = that.prefs.minDate,
                maxDate = that.prefs.maxDate,
                period;

            if (minDate) {
                if (minDate.month === month && minDate.year === year) {
                    minDay = minDate.day;
                }
            }

            if (maxDate) {
                if (maxDate.month === month && maxDate.year === year) {
                    maxDay = maxDate.day - 1;
                }
            }

            period = {
                from: {
                    day: minDay || 1,
                    month: month,
                    year: year
                },
                to: {
                    day: maxDay || that._daysPerMonth(month, year),
                    month: month,
                    year: year
                }
            };

            that._updatePeriod(period);
        });

        // Выделяем всю неделю
        that.jDays.on('click', 'td' + that._namespaceClassname + 'selector-week', function () {
            var el = $(this),
                tr, th, td, text, month, year, period;

            if (el.hasClass(that._namespace + 'selector-week-disabled')) {
                return;
            }

            tr = el.closest('tr');
            th = el.closest('table').find('th').eq(0);
            td = tr.find('td')
                .not(that._namespaceClassname + 'selector-week')
                .not(that._namespaceClassname + 'disabled-day')
                .not(that._namespaceClassname + 'empty');

            if (td.length) {
                text = $('b', th).html().split('.');
                month = parseInt(text[0], 10);
                year = parseInt(text[1], 10);

                period = {
                    from: {
                        day: parseInt(td.eq(0).html(), 10),
                        month: month,
                        year: year
                    },
                    to: {
                        day: parseInt(td.eq(td.length - 1).html(), 10),
                        month: month,
                        year: year
                    }
                };

                that._updatePeriod(period);
            }
        });

        // Выбор дня
        that.jDays.on('click', 'td' + that._namespaceClassname + 'month-td td', function () {
            if (!this.innerHTML) {
                return;
            }

            var el = $(this),
                hasDisabledDates = false,
                date, text, from, to, period, cmp, buf,
                step0 = function() {
                    that.jFrom.val(text);
                    that.jTo.val(text);

                    if (!that.prefs.touch) {
                        that.jTo.focus();
                    }

                    that.selectedStep = 1;

                    from = that.jFrom.val().split('.');
                    period = {
                        from: {
                            day: parseInt(from[0], 10),
                            month: parseInt(from[1], 10) - 1,
                            year: parseInt(from[2], 10)
                        },
                        to: null
                    };

                    that.selectedPeriod = period;
                    that._selectPeriod(period);
                };

            if (el.hasClass(that._namespace + 'day-disabled') || el.hasClass(that._namespace + 'empty') || el.hasClass(that._namespace + 'selector-week')) {
                return;
            }

            el.addClass(that._namespace + 'selected');

            date = that._getDateFromTd(this);
            text = that._dateToText(date);

            if (that.prefs.single) {
                that.selectedStep = 0;
            }

            switch (that.selectedStep) {
            case 0:
                step0();

                break;
            case 1:
                that.jTo.val(text).blur();
                that.selectedStep = 0;

                period = {
                    from: null,
                    to: null
                };

                to = that.jTo.val().split('.');
                from = that.jFrom.val().split('.');

                period = {
                    from: {
                        day: parseInt(from[0], 10),
                        month: parseInt(from[1], 10) - 1,
                        year: parseInt(from[2], 10)
                    },
                    to: {
                        day: parseInt(to[0], 10),
                        month: parseInt(to[1], 10) - 1,
                        year: parseInt(to[2], 10)
                    }
                };

                cmp = that._cmpDates(period.from, period.to);
                if (cmp === 1) {
                    buf = period.from;
                    period.from = period.to;
                    period.to = buf;

                    buf = that.jTo.val();
                    that.jTo.val(that.jFrom.val());
                    that.jFrom.val(buf);
                }

                hasDisabledDates = that.prefs.disabledDates.some(function(date) {
                    return that._dateInPeriod(date, that.jTo.val(), that.jFrom.val()) === 0;
                });

                if (hasDisabledDates) {
                    setError(that.jTo[0], true);
                    setError(that.jFrom[0], true);
                    step0();
                    break;
                }

                that.selectedPeriod = period;
                that._selectPeriod(period);
                break;
            }

            that._updateSelectorDateSelectedPeriod(period);

            if (that.prefs.single) {
                that.jShow.click();
            }
        });

        // Двигаем колесиком мышки месяцы
        if (that.prefs.mousewheel) {
            that.jElement.on('mousewheel', function (e, delta) {
                e.preventDefault();

                var direction = delta < 0 ? 1 : -1,
                    date1 = that._whatDraggerDate(),
                    newDate = that._addMonths(date1.month, date1.year, direction),
                    date2;

                that._setDraggerAtDate(newDate.month, newDate.year);
                date2 = that._whatDraggerDate();

                if (date1.month !== date2.month || date1.year !== date2.year) {
                    that.beginDate = date2;
                    that._setDraggerAtBeginDate();
                    that.updateDate();
                    that._selectPeriod(that.selectedPeriod);
                    that._updateSelectorDateContainer(that.prefs.animation);
                }
            });
        }

        that._skipEvent = false;

        // Клик на кнопку открытия календаря
        that._addEvent(that.calledElement, 'click', function (e) {
            // Хак для конструктора, чтобы при нажатии клавиши "ENTER" в текстовом поле в форме не открывался календарь
            if (this.tagName === 'BUTTON' && !e.clientY && !e.clientX) {
                return;
            }

            that._skipEvent = true;
            that.toggle();
        });

        // По ESC закрываем календарь
        that._addEvent(document, 'keydown', function (e) {
            var VK_ESC = 27;
            if (that.jElement.is(':visible') && e.keyCode === VK_ESC) {
                that.close();
            }
        });

        // По клику не на календарь, тоже закрываем календарь
        that._addEvent(document, 'click', function (e) {
            if (!that._skipEvent && e.clientY > 0) {
                if (that.jElement.is(':visible')) {
                    that.close();
                }
            }

            that._skipEvent = false;
        });

        // При изменении размеров окна, изменяем размера календаря
        that._addEvent(window, 'resize', function () {
            if (that.jElement.is(':visible')) {
                that.resize();
            }
        });

        // Клик в поле ввода начальной даты в периоде
        that.jFrom.click(function () {
            $(that.jTo).removeClass(that._namespace + 'to-selected');
            that.selectedStep = 0;
        });

        // Клик в поле ввода конечной даты в периоде
        that.jTo.click(function () {
            $(that.jFrom).removeClass(that._namespace + 'from-selected');
            that.selectedStep = 1;
        });

        function setError(el, onlyRemove) {
            var cl = that._namespace + 'error';
            if (!that._isCorrectDate(el.value) && el.value) {
                if (!onlyRemove) {
                    $(el).closest('.input').addClass(cl);
                }
            } else {
                $(el).closest('.input').removeClass(cl);
            }

            if (!onlyRemove) {
                if (that._periodContainsDisabledDates()) {
                    that.jFrom.closest('.input').addClass(cl);
                    that.jTo.closest('.input').addClass(cl);
                }
            }
        }

        that.jFrom.focus(function () {
            $(this).addClass(that._namespace + 'from-selected');
            that.jTo.removeClass(that._namespace + 'to-selected');
        }).blur(function () {
            setError(this);
            $(this).removeClass(that._namespace + 'from-selected');
        });

        that.jTo.focus(function () {
            $(this).addClass(that._namespace + 'to-selected');
            that.jFrom.removeClass(that._namespace + 'from-selected');
        }).blur(function () {
            setError(this);
            $(this).removeClass(that._namespace + 'to-selected');
        });

        that.jTo.add(that.jFrom).keyup(function (e) {
            var el, sel, from, to, isFrom, isTo, period, bufFrom, bufTo;

            // Возможность в текстовых полях менять день, месяц, год c помощью курсоров вверх и вниз
            if ($.browser.mozilla && !that.isMacOS()) { // TODO: сделать для всех браузеров
                el = $(this);

                if (e.keyCode === VK_CURSOR_DOWN) {
                    sel = that._selectedDateField(el, -1);
                    if (sel) {
                        that._cursorAddDate(el, sel);
                    }
                } else if (e.keyCode === VK_CURSOR_UP) {
                    sel = that._selectedDateField(el, 1);
                    if (sel) {
                        that._cursorAddDate(el, sel);
                    }
                }
            }

            from = that.jFrom.val();
            to = that.jTo.val();
            isFrom = that._isCorrectDate(from);
            isTo = that._isCorrectDate(to);
            period = {from: null, to: null};

            if (isFrom && isTo && !that._periodContainsDisabledDates()) {
                bufFrom = that._textToDate(from);
                bufTo = that._textToDate(to);

                if (that._cmpDates(bufFrom, bufTo) === 1) {
                    period.from = bufTo;
                    period.to = bufFrom;
                } else {
                    period.from = bufFrom;
                    period.to = bufTo;
                }

                that.selectedPeriod = period;

                if (!that._isEqualPeriods(that._lastSelectedPeriod, period)) {
                    that._deselectPeriod();
                    that._selectPeriod(period);
                }
            } else {
                that._deselectPeriod();
                that.selectedPeriod = {from: null, to: null};
            }

            that._updateSelectorDateSelectedPeriod(period);

            if (isFrom) {
                setError(that.jFrom[0], true);
            }

            if (isTo) {
                setError(that.jTo[0], true);
            }

            that._updateShowButton();

            if (e.keyCode === VK_ENTER) {
                that.jShow.click();
            }
        });

        that.jShow.click(function () {
            if (that.jShow.hasClass(that._namespace + 'disabled')) {
                that.jElement.find(that._namespaceClassname + 'error input').focus();
                return;
            }

            var bufFrom = that._textToDate(that.jFrom.val()),
               bufTo = that._textToDate(that.jTo.val()),
               from,
               to;

            if (that._cmpDates(bufFrom, bufTo) === 1) {
                from = bufTo;
                to = bufFrom;
            } else {
                from = bufFrom;
                to = bufTo;
            }

            from.text = that._dateToText(from);
            from.reverseText = that._dateToReverseText(from);
            to.text = that._dateToText(to);
            to.reverseText = that._dateToReverseText(to);
            that.selectedPeriod = {from: from, to: to};
            that._oldSelectedPeriod = that.selectedPeriod;

            that.hide();

            that.prefs.onSelect(from, to, that.finePeriod(from, to), that.prefs.submitButton);
            $(document).trigger('selectDate' + that._namespaceEvent);
        });

        that.jClose.click(function () {
            that.close();
        });

        that.jHead.on('dblclick', function () {
            that.jMaxmin.click();
        });

        that.jMaxmin.click(function () {
            var obj, collapse = false,
                f = function () {
                    that.resize();
                    if (collapse && that.selectedPeriod && that.selectedPeriod.from) {
                        that._fineSelectedPeriod();
                        that._setDraggerAtBeginDate();
                        that._manualUpdateDragger(true);
                    }
                };

            if (that.jElement.hasClass(that._namespace + 'maximize')) {
                that.jElement.removeClass(that._namespace + 'maximize');
                obj = {left: oldLeft, top: oldTop, width: oldWidth, height: oldHeight};
                that.jMaxmin.attr('title', that.getString('expand'));
                collapse = true;
            } else {
                oldLeft = that.jElement.css('left');
                oldTop = that.jElement.css('top');
                oldWidth = that.jElement.width();
                oldHeight = that.jElement.height();
                oldCellWidthMonth = that.cellWidthMonth;
                obj = {left: '0', top: '0', width: '100%', height: '100%'};
                that.jElement.addClass(that._namespace + 'maximize');
                that.jMaxmin.attr('title', that.getString('collapse'));
            }

            if (that.prefs.animation) {
                that.jElement.animate(obj, that.prefs.speedAnimation, f);
            } else {
                that.jElement.css(obj);
                f();
            }
        });

        $(that.jElement).click(function () {
            return false;
        });
    },

    /**
     * @returns {boolean}
     * @private
     */
    _periodContainsDisabledDates: function() {
        var fromVal = this.jFrom.val(),
            toVal = this.jTo.val(),
            cmpDates,
            fromDateObj,
            toDateObj,
            fromDate,
            toDate,
            tmpDate;

        if (this.prefs.disabledDates.length === 0) {
            return false;
        }

        if (fromVal && toVal && this._isCorrectDate(fromVal) && this._isCorrectDate(toVal)) {
            cmpDates = this._cmpDates(fromVal, toVal);
            fromDateObj = this._textToDate(fromVal);
            toDateObj = this._textToDate(toVal);
            fromDate = new Date(fromDateObj.year, fromDateObj.month, fromDateObj.day);
            toDate = new Date(toDateObj.year, toDateObj.month, toDateObj.day);

            if (cmpDates === 1) {
                tmpDate = toDate;
                toDate = fromDate;
                fromDate = tmpDate;
            }

            return this.prefs.disabledDates.some(function(textDate) {
                var objDate = this._textToDate(textDate),
                    date = new Date(objDate.year, objDate.month, objDate.day);
                return fromDate <= date && date <= toDate;
            }, this);

        }
        return false;
    },

    _cursorAddDate: function (el, date) {
        var val = el.val(),
            buf = this._textToDate(val),
            maxDay;

        buf.day += date.day;
        buf.month += date.month;
        buf.year += date.year;

        if (buf.month > this.maxMonth) {
            buf.month = this.minMonth;
        }

        if (buf.month < this.minMonth) {
            buf.month = this.maxMonth;
        }

        if (buf.year > this.prefs.maxYear) {
            buf.year = this.prefs.maxYear;
        }

        if (buf.year < this.prefs.minYear) {
            buf.year = this.prefs.minYear;
        }

        maxDay = this._daysPerMonth(buf.month, buf.year);
        if (buf.day < 1) {
            buf.day = maxDay;
        }

        if (buf.day > maxDay) {
            if (date.day !== 0) {
                buf.day = 1;
            } else {
                buf.day = maxDay;
            }
        }

        el.val(this._dateToText(buf))[0].setSelectionRange(date.selectionStart, date.selectionEnd);
    },
    _selectedDateField: function (el, direction) {
        var selStart = el.get(0).selectionStart,
            val = el.val(),
            step = 0,
            obj = {
                day: 0,
                month: 0,
                year: 0
            },
            i;

        if (!this._isCorrectDate(val, true)) {
            return false;
        }

        for (i = 0; i < val.length && i < selStart; i++) {
            if (val.charAt(i) === '.') {
                step++;
            }
        }

        switch (step) {
        case 0:
            obj.day = direction;
            obj.selectionStart = 0;
            obj.selectionEnd = obj.selectionStart + 2;
            break;
        case 1:
            obj.month = direction;
            obj.selectionStart = 3;
            obj.selectionEnd = obj.selectionStart + 2;
            break;
        case 2:
            obj.year = direction;
            obj.selectionStart = 6;
            obj.selectionEnd = obj.selectionStart + 4;
            break;
        }

        return obj;
    },
    _updateShowButton: function () {
        var isCorrectDates = this._isCorrectDate(this.jFrom.val()) && this._isCorrectDate(this.jTo.val()) ;
        this.jShow.toggleClass(this._namespace + 'disabled', !isCorrectDates || this._periodContainsDisabledDates());
    },
    _addEvent: function (el, t, func) {
        this._bufferEvents.push({el: el, t: t, func: func});
        $(el).on(t, func);
    },
    _removeEvents: function () {
        var i, b;

        for (i = 0; i < this._bufferEvents.length; i++) {
            b = this._bufferEvents[i];
            $(b.el).off(b.t, b.func);
        }
    },
    _removeSelectedStartEnd: function () {
        if (this.jSelectedStart) {
            this.jSelectedStart.removeClass(this._namespace + 'selected-start');
            this.jSelectedStart = null;
        }

        if (this.jSelectedEnd) {
            this.jSelectedEnd.removeClass(this._namespace + 'selected-end');
            this.jSelectedEnd = null;
        }
    },
    _setSelectedStart: function (start) {
        var cl = this._namespace + 'selected-start';
        if (this.jSelectedStart) {
            this.jSelectedStart.removeClass(cl);
        }

        start.addClass(cl);
        this.jSelectedStart = start;
    },
    _setSelectedEnd: function (end) {
        var cl = this._namespace + 'selected-end';
        if (this.jSelectedEnd) {
            this.jSelectedEnd.removeClass(cl);
        }

        end.addClass(cl);
        this.jSelectedEnd = end;
    },
    _getDateFromTd: function (td) {
        td = $(td);
        var day = parseInt(td.html(), 10),
            my = td.closest('table').find('th b').html().split(/\./),
            month = parseInt(my[0], 10),
            year = parseInt(my[1], 10);

        return {day: day, month: month, year: year};
    },
    _leadZero: function (n) {
        return (n < 10) ? ('0' + n) : ('' + n);
    },
    _addMonths: function (month, year, count) {
        var MONTHS_AT_YEAR = 12,
            months = year * MONTHS_AT_YEAR + month + count;
        return {month: months % MONTHS_AT_YEAR, year: Math.floor(months / MONTHS_AT_YEAR)};
    },
    _whatDraggerDate: function () {
        var left = this.jYearsDragger.position().left,
            year = this.prefs.minYear + Math.floor(left / this.WIDTH_YEAR),
            month = Math.floor((left - (year - this.prefs.minYear) * this.WIDTH_YEAR) / this.WIDTH_MONTH);

        return {day: 1, month: month, year: year};
    },
    _manualUpdateDragger: function (force) {
        var newBeginDate = this._whatDraggerDate();
        if (force || (newBeginDate.month !== this.beginDate.month || newBeginDate.year !== this.beginDate.year)) {
            this.beginDate = newBeginDate;
            this.updateDate();
        }

        this._selectPeriod(this.selectedPeriod);
    },
    _setDraggerAtBeginDate: function () {
        var left = (this.beginDate.year - this.prefs.minYear) * this.WIDTH_YEAR + this.beginDate.month * this.WIDTH_MONTH;
        this.jYearsDragger.css('left', left + 'px');
    },
    _dateToText: function (date) {
        return this._leadZero(date.day) + '.' + this._leadZero(date.month + 1) + '.' + date.year;
    },
    _dateToReverseText: function (date) {
        return date.year + this._leadZero(date.month + 1) + this._leadZero(date.day);
    },
    _textToDate: function (text) {
        var buf = text.split(/\./);
        return  {
            day: parseInt(buf[0], 10),
            month: parseInt(buf[1], 10) - 1,
            year: parseInt(buf[2], 10)
        };
    },
    _reverseTextToDate: function (date) {
        var year = date.substr(0, 4),
            month = date.substr(4, 2),
            day = date.substr(6, 2);

        return  {
            day: parseInt(day, 10),
            month: parseInt(month, 10) - 1,
            year: parseInt(year, 10)
        };
    },
    _prepareTextDate: function (text) {
        if (text.search(/\./) !== -1) {
            return text;
        }

        var year = text.substr(0, 4),
            month = text.substr(4, 2),
            day = text.substr(6, 2);

        return day + '.' + month + '.' + year;
    },
    _daysPerMonth: function (month, year) {
        var FEBRARY = 1;
        if (this.isLeapYear(year) && month === FEBRARY) {
            return 29;
        }

        return this.daysMonth[month];
    },
    _updatePeriod: function (period) {
        var that = this;
        that.jFrom.val(that._dateToText(period.from));
        that.jTo.val(that._dateToText(period.to));
        that.selectedPeriod = period;
        that._selectPeriod(period);
        that._updateSelectorDateSelectedPeriod(period);
    },
    _updateSelectorDateContainer: function (animation) {
        var wYear = this.jYears.width(),
            wContainer = this.jYearsContainer.width(),
            wDragger = this.jYearsDragger.width(),
            left;

        if (wContainer < wYear) {
            left = (wYear - wContainer) / 2;
        } else {
            left = -this.jYearsDragger.position().left + (wYear - wDragger) / 2;
            if (left > 0) {
                left = 0;
            }

            if (left + wContainer < wYear) {
                left = wYear - wContainer;
            }
        }

        if (animation) {
            this.jYearsContainer.stop().animate({left: left + 'px'}, this.prefs.speedAnimation);
        } else {
            this.jYearsContainer.css('left', left + 'px');
        }
    },
    _updateSelectorDateSelectedPeriod: function (period) {
        var minWidth = 1,
            MONTH = 1000 * 60 * 60 * 24 * 30,
            from, to, wMonths, wContainer, left;

        if (!period.from || !period.to) {
            this.jYearsSelectedPeriod.hide().width(minWidth);
            return;
        } else {
            this.jYearsSelectedPeriod.show();
        }

        from = new Date(period.from.year, period.from.month, period.from.day);
        to = new Date(period.to.year, period.to.month, period.to.day);

        wMonths = ((to.getTime() - from.getTime()) / MONTH * this.WIDTH_MONTH) || minWidth;
        wContainer = this.jYearsContainer.width();
        if (wMonths > wContainer) {
            wMonths = wContainer;
        }

        left = (period.from.year - this.prefs.minYear) * this.WIDTH_YEAR + period.from.month * this.WIDTH_MONTH + period.from.day / 30 * this.WIDTH_MONTH;

        this.jYearsSelectedPeriod.css({width: wMonths + 'px', left: left + 'px'});
    },
    _updateSelectorDateDragger: function () {
        var that = this,
            wDragger = that.cellWidthMonth * that.cellHeightMonth * that.WIDTH_MONTH,
            wContainer = that.jYearsContainer.width(),
            position = that.jYearsDragger.position(),
            lDragger = position.left;

        if (lDragger < 0) {
            lDragger = 0;
            that.jYearsDragger.css('left', lDragger);
        }

        if (wDragger > wContainer) {
            wDragger = wContainer;
        }

        if (wDragger + lDragger > wContainer) {
            that.jYearsDragger.css('left', (wContainer - wDragger) + 'px');
        }

        that.jYearsDragger.css('width', wDragger + 'px');
    },
    _setDraggerAtYear: function (year) {
        var wDragger = this.jYearsDragger.width(),
            wContainer = this.jYearsContainer.width(),
            left = this.WIDTH_YEAR * (year - this.prefs.minYear) - wDragger / 2;

        if (left < 0) {
            left = 0;
        }

        if (left + wDragger > wContainer) {
            left = wContainer - wDragger;
        }

        this.jYearsDragger.css('left', left + 'px');
    },
    _setDraggerAtDate: function (month, year) {
        var wDragger = this.jYearsDragger.width(),
            wContainer = this.jYearsContainer.width(),
            left = this.WIDTH_YEAR * (year - this.prefs.minYear) + this.WIDTH_MONTH * month;

        if (left < 0) {
            left = 0;
        }

        if (left + wDragger > wContainer) {
            left = wContainer - wDragger;
        }

        this.jYearsDragger.css('left', left + 'px');
    },
    _setDraggerAtX: function (x) {
        var wDragger = this.jYearsDragger.width(),
            wContainer = this.jYearsContainer.width(),
            left = x - this.jYearsSelector.offset().left - this.jYearsContainer.position().left - wDragger / 2;

        if (left < 0) {
            left = 0;
        }

        if (left + wDragger > wContainer) {
            left = wContainer - wDragger;
        }

        this.jYearsDragger.css('left', left + 'px');
    },
    _selectPeriod: function (period) {
        this._lastSelectedPeriod = period;

        var that = this;

        $('table table', this.jDays).each(function () {
            $(this).closest('td').removeClass(that._namespace + 'selected').removeClass(that._namespace + 'partially-selected');
        });

        if (!period.from) {
            return;
        }

        if (!period.to) {
            this._selectDay(period.from);
        } else {
            switch (this._cmpDates(period.from, period.to)) {
            case 0:
                this._selectDay(period.from);
                break;
            default:
                this._selectOnlyPeriod(period.from, period.to);
                break;
            }

            this._removeClassError();
        }

        this._updateShowButton();
    },
    _removeClassError: function () {
        this.jTo.add(this.jFrom).removeClass(this._namespace + 'error');
    },
    _deselectPeriod: function () {
        var that = this;
        this._lastSelectedPeriod = null;
        this._removeSelectedStartEnd();
        $('td', this.jDays).each(function () {
            $(this).removeClass(that._namespace + 'selected').removeClass(that._namespace + 'partially-selected');
        });
    },
    _selectOnlyPeriod: function (from, to) {
        var that = this,
            f = function (table, date, type) {
                table.closest('td').addClass(notcl).removeClass(cl);
                table.find('td').each(function () {
                    var val = parseInt(this.innerHTML, 10),
                        td;
                    if (!isNaN(val)) {
                        td = $(this);
                        if ((type === 'to' && val <= date.day) || (val >= date.day && type === 'from')) {
                            if (type === 'from' && val === date.day) {
                                that._setSelectedStart(td);
                            }
                            if (type === 'to' && val === date.day) {
                                that._setSelectedEnd(td);
                            }

                            td.addClass(cl);
                        } else {
                            td.removeClass(cl);
                        }
                    }
                });
            },
            textFrom, textTo, cl, notcl, table;

        this._removeSelectedStartEnd();

        textFrom = this._leadZero(from.year) + this._leadZero(from.month);
        textTo = this._leadZero(to.year) + this._leadZero(to.month);
        that = this;
        cl = this._namespace + 'selected';
        notcl = this._namespace + 'partially-selected';
        if (textFrom === textTo) {
            table = this.jDays.findAtText('table table th b',  from.month + '.' + from.year).closest('table');
            table.closest('td').addClass(notcl).removeClass(cl);
            table.find('td').each(function () {
                var val = parseInt(this.innerHTML, 10),
                    td;

                if (!isNaN(val)) {
                    td = $(this);
                    if (val >= from.day && val <= to.day) {
                        if (val === from.day) {
                            that._setSelectedStart(td);
                        }
                        if (val === to.day) {
                            that._setSelectedEnd(td);
                        }

                        td.addClass(cl);
                    } else {
                        td.removeClass(cl);
                    }
                }
            });
        } else {
            this.jDays.find('table table th b').each(function () {
                var table = $(this).closest('table'),
                    td = table.closest('td'),
                    fr = from.month + '.' + from.year,
                    t = to.month + '.' + to.year;

                if (this.innerHTML === fr) {
                    f.call(that, table, from, 'from');
                    return;
                }

                if (this.innerHTML === t) {
                    f.call(that, table, to, 'to');
                    return;
                }

                if (that._dateInPeriodWithoutDay(this.innerHTML, fr, t) === 0) {
                    td.removeClass(notcl).addClass(cl);
                } else {
                    td.removeClass(notcl).removeClass(cl);
                }
            });
        }
    },
    _selectDay: function (date) {
        this._removeSelectedStartEnd();
        var text = date.month + '.' + date.year,
            table = this.jDays.findAtText('table table th b', text).closest('table'),
            cl = this._namespace + 'selected';

        table.closest('td').removeClass(cl).addClass(this._namespace + 'partially-selected');
        table.find('td').removeClass(cl);
        table.findAtText('td', date.day).addClass(cl);
    },
    _prepareDate: function (d) {
        if (typeof d !== 'string') {
            d = d.text || this._dateToText(d);
        }

        return parseInt(d.split('.').reverse().join(''), 10);
    },
    _cmpDates: function (date1, date2) {
        var d1 = this._prepareDate(date1),
            d2 = this._prepareDate(date2);

        if (d1 === d2) {
            return 0;
        }

        if (d1 > d2) {
            return 1;
        }

        return -1;
    },
    _isEqualPeriods: function (period1, period2) {
        function cmp(prop) {
            var p1 = period1[prop],
                p2 = period2[prop];

            if (p1 === p2 && p2 === null) {
                return true;
            } else if (p1 === null || p2 === null) {
                return false;
            } else if (p1.day !== p2.day || p1.month !== p2.month || p1.year !== p2.year) {
                return false;
            }

            return true;
        }

        if (!period1 || !period2) {
            return false;
        }

        return cmp('to') && cmp('from');
    },
    _dateInPeriod: function (date, to, from) {
        var d = this._prepareDate(date),
            dTo = this._prepareDate(to),
            dFrom = this._prepareDate(from);

        if (d > dTo) {
            return -1;
        }

        if (d < dFrom) {
            return 1;
        }

        return 0;
    },
    _weekOfYear: function (date) {
        // adapted from http://www.merlyn.demon.co.uk/weekcalc.htm
        var ms7d = 7 * this.MS_DAY, // milliseconds in a week
            DC3 = Date.UTC(date.getFullYear(), date.getMonth(), date.getDate() + 3) / this.MS_DAY, // milliseconds in a day; // an Absolute Day Number
            AWN = Math.floor(DC3 / 7), // an Absolute Week Number
            Wyr = new Date(AWN * ms7d).getUTCFullYear();

        return AWN - Math.floor(Date.UTC(Wyr, 0, 7) / ms7d) + 1;
    },
    _dateInPeriodWithoutDay: function (str, strFrom, strTo) {
        var f = function (str) {
                var res = str.split('.');
                res[0] = this._leadZero(parseInt(res[0], 10));
                return parseInt(res.reverse().join(''), 10);
            },
            d = f.call(this, str),
            dTo = f.call(this, strTo),
            dFrom = f.call(this, strFrom);

        if (d > dTo) {
            return 1;
        }

        if (d < dFrom) {
            return -1;
        }

        return 0;
    },
    _initDragger: function () {
        var isDrag = false,
            container = this.jYearsDragger,
            currentDragger = null,
            startX,
            offsetX,
            that = this;

        function draggerMouseDown(e) {
            isDrag = true;

            var offset = $(container).position();
            offsetX = offset.left;
            startX = that._getPageX(e);
            currentDragger = $(this);

            e.preventDefault();
        }

        function draggerMouseUp(e) {
            if (isDrag && !that.prefs.touch) {
                draggerMove(e);
            }

            isDrag = false;
            currentDragger = null;

            that._updateSelectorDateContainer(that.prefs.animation);
        }

        function draggerMove(e) {
            if (isDrag) {
                var x = that._getPageX(e) - (startX - offsetX),
                    wContainer, wYContainer;

                if (x < 0) {
                    x = 0;
                }

                wContainer = container.width();
                wYContainer = that.jYearsContainer.width() - wContainer;
                if (x > wYContainer) {
                    x = wYContainer;
                }

                $(container).css({left: x + 'px'});
                that._manualUpdateDragger();
            }
        }

        if (that.prefs.touch) {
            this._addEvent(document, 'touchmove', draggerMove);
            this._addEvent(document, 'touchcancel touchend', draggerMouseUp);
            container.on('touchstart', draggerMouseDown);
        } else {
            this._addEvent(document, 'mousemove', draggerMove);
            this._addEvent(document, 'mouseup', draggerMouseUp);
            container.on('mousedown', draggerMouseDown);
        }
    },
    _initResizer: function () {
        var isDrag = false,
            isResize = false,
            that = this,
            container = that.jElement,
            dragger = that.jHead,
            resizer = that.jResizer,
            currentDragger = null,
            currentResizer = null,
            startX,
            startY,
            minWidth,
            minHeight,
            offsetX,
            offsetY,
            actionEvent = 'mousemove',
            startEvent = 'mousedown',
            endEvent = 'mouseup';

        function draggerMouseDown(e) {
            if (that.jElement.hasClass(that._namespace + 'maximize')) {
                isDrag = false;
                return;
            }

            isDrag = true;

            var offset = $(container).offset();
            offsetX = offset.left;
            offsetY = offset.top;

            startX = that._getPageX(e);
            startY = that._getPageY(e);

            currentDragger = $(this);

            e.preventDefault();
        }

        function draggerMouseUp(e) {
            if (isDrag && !that.prefs.touch) {
                draggerMove(e);
            }

            isDrag = false;
            currentDragger = null;
        }

        function draggerMove(e) {
            if (isDrag) {
                var x = that._getPageX(e) - (startX - offsetX),
                    y = that._getPageY(e) - (startY - offsetY);
                if (y < 0) {
                    y = 0;
                }

                $(container).css({left: x + 'px', top: y + 'px'});

                e.preventDefault();
            }
        }

        function resizerMouseDown(e) {
            isResize = true;

            var offset = $(container).offset(),
                el, elHeader;

            offsetX = offset.left;
            offsetY = offset.top;

            startX = that._getPageX(e);
            startY = that._getPageY(e);

            el = $('> table > table', that.jDays);
            elHeader = that.jHead;

            minWidth = el.outerWidth();
            minHeight = el.outerHeight() + elHeader.outerHeight();

            currentResizer = $(this);

            e.preventDefault();
        }

        function resizerMouseUp(e) {
            if (isResize && !that.prefs.touch) {
                resizerMove(e);
            }

            isResize = false;
            currentResizer = null;
        }

        function resizerMove(e) {
            if (isResize) {
                var x = that._getPageX(e) - offsetX,
                    y = that._getPageY(e) - offsetY;

                if (x < minWidth) {
                    x = minWidth;
                }

                if (y < minHeight) {
                    y = minHeight;
                }

                if (currentResizer.hasClass(that._namespace + 'resizer')) {
                    $(container).css({width: x + 'px', height: y + 'px'});
                    that.resize();
                }

                e.preventDefault();
            }
        }

        if (this.prefs.touch) {
            actionEvent = 'touchmove';
            startEvent = 'touchstart';
            endEvent = 'touchcancel touchend';
        }

        this._addEvent(document, actionEvent, resizerMove);
        this._addEvent(document, actionEvent, draggerMove);
        this._addEvent(document, endEvent, resizerMouseUp);
        this._addEvent(document, endEvent, draggerMouseUp);

        resizer.on(startEvent, resizerMouseDown);
        dragger.on(startEvent, draggerMouseDown);
    },
    _getPageX: function (e) {
        if (this.prefs.touch && e.type.match('touch')) {
            return e.originalEvent.touches[0].pageX;
        }

        return e.pageX;
    },
    _getPageY: function (e) {
        if (this.prefs.touch && e.type.match('touch')) {
            return e.originalEvent.touches[0].pageY;
        }

        return e.pageY;
    },
    _beforePaste: function (template) {
        return template.replace(/\{n\}/g, this._namespace);
    },
    _selectorYears: function () {
        var w = this.WIDTH_YEAR * (this.prefs.maxYear - this.prefs.minYear),
            text = [],
            n = 0,
            i;

        text.push('<div class="{n}years-selector"><div class="{n}years-selector-container" style="width:' + w + 'px"><div class="{n}years-dragger" title="' + this.getString('move') + '"></div><div class="{n}years-period"></div>');
        for (i = this.prefs.minYear; i <= this.prefs.maxYear; i++) {
            text.push('<div class="{n}year" style="left:' + (this.WIDTH_YEAR * n) + 'px">' + i + '</div>');
            n++;
        }

        text.push('</div></div>');

        return text.join('');
    },
    _pasteDays: function (d, m, y) {
        function getTextFirstLetters() {
            if (that._cacheFirstLetters) {
                return that._cacheFirstLetters;
            }

            var firstLetterWeekDay = that.getString('firstLetterWeekDay'),
                buf = [],
                SUNDAY = 6,
                SATURDAY = 5,
                i;

            buf.push('<td class="' + that._namespace + 'first-letters-td"><table class="' + that._namespace + 'first-letters-table"><tr>');
            if (that.prefs.selectorWeeks) {
                buf.push('<th class="{n}selector-week-cap"><span class="{n}selector-week-cap"></span></th>');
            }

            for (i = 0; i < firstLetterWeekDay.length; i++) {
                buf.push('<th' + ((i === SUNDAY || i === SATURDAY) ? ' class="{n}holiday"' : '') + '>' + firstLetterWeekDay[i] + '</th>');
            }
            buf.push('</tr></table></td>');
            that._cacheFirstLetters = buf.join('');

            return that._cacheFirstLetters;
        }

        var that = this,
            j = 0,
            text = [],
            textYear = '',
            oldYear = y,
            n, x, h, className;

        text.push('<table><tr class="' + this._namespace + 'first-letters-tr">');
        for (n = 0; n < this.cellWidthMonth; n++) {
            text.push(getTextFirstLetters());
        }
        text.push('</tr>');

        for (x = 0; x < this.cellHeightMonth; x++) {
            text.push('<tr class="' + this._namespace + 'month-tr">');
            for (h = 0; h < this.cellWidthMonth; h++) {
                if (!x && !h) {
                    textYear = y;
                } else {
                    textYear = '';
                    if (y !== oldYear) {
                        textYear = oldYear = y;
                    }
                }

                className = this._namespace + 'month' + m + ' ' + this._namespace + 'month-td ' + this._namespace + (y % 2 ? 'even-year' : 'odd-year');
                if (y >= this.prefs.minYear && y < this.prefs.maxYear) {
                    text.push('<td class="' + className + '">' + this._cacheBuildDays(d, m, y, textYear) + '</td>');
                } else {
                    text.push('<td>&nbsp;</td>');
                }

                m++;
                if (m > this.maxMonth) {
                    m = this.minMonth;
                    y++;
                }

                j++;
            }
            text.push('</tr>');
        }

        text.push('</table>');

        $('> table', this.jDays).remove();

        this.jDays.html(this._beforePaste(text.join('')));
    },
    _setMinSize: function () {
        if (this._minSize) {
            return;
        }

        this._minSize = true;

        var w = this.jDays.find(this._namespaceClassname + 'first-letters-td:eq(0)').outerWidth(true),
            minWidth = w * this.minCellWidthMonth + parseInt(this.jElement.css('padding-right'), 10) + parseInt(this.jElement.css('padding-left'), 10),
            maxHeightTd = 0,
            minHeight;

        this._maxWidthTd = w;

        this.jDays.find(this._namespaceClassname + 'month-td').each(function () {
            maxHeightTd = Math.max(maxHeightTd, $(this).outerHeight(true));
        });

        this._maxHeightTd = maxHeightTd;

        minHeight = this.jHead.outerHeight(true) + this.minCellHeightMonth * maxHeightTd + this.jYears.outerHeight(true) + this.jDays.find('tr' + this._namespaceClassname + 'first-letters-tr').outerHeight(true) + this.jSubmitShadow.outerHeight(true) + this.DAYS_PADDING_BOTTOM;

        this.jElement.css({
            minWidth: minWidth + 'px',
            minHeight: minHeight + 'px'
        });
    },
    _calcNewSize: function () {
        var that = this,
            x = Math.floor((that.jElement.outerWidth() - parseInt(that.jElement.css('padding-right'), 10)) / that._maxWidthTd),
            y = Math.floor((that.jElement.outerHeight() - that.jHead.outerHeight(true) - that.jYears.outerHeight(true) - that.jDays.find('tr' + that._namespaceClassname + 'first-letters-tr').outerHeight(true) - that.jSubmitShadow.outerHeight(true) - that.DAYS_PADDING_BOTTOM) / that._maxHeightTd);

        if (x < that.minCellWidthMonth) {
            x = that.minCellWidthMonth;
        }

        if (x > that.maxCellWidthMonth) {
            x = that.maxCellWidthMonth;
        }

        if (y < that.minCellHeightMonth) {
            y = that.minCellHeightMonth;
        }

        if (y > that.maxCellHeightMonth) {
            y = that.maxCellHeightMonth;
        }

        if (x === that.cellWidthMonth && y === that.cellHeightMonth) {
            return;
        } else {
            that.cellWidthMonth = x;
            that.cellHeightMonth = y;
            that.updateDate();
        }
    },
    _isCorrectDate: function (text, light) {
        if (!text) {
            return false;
        }

        var buf = text.split(/\./),
            day, month, year, txt, prefs;

        if (buf.length !== 3) {
            return false;
        }

        day = parseInt(buf[0], 10);
        month = parseInt(buf[1], 10);
        year = parseInt(buf[2], 10);
        txt = this._dateToText({day: day, month: month - 1, year: year});

        if (isNaN(day) || isNaN(month) || isNaN(year)) {
            return false;
        }

        if (year < 1900 || year < this.prefs.minYear) {
            return false;
        }

        if (year > this.prefs.maxYear) {
            return false;
        }

        if (month < (this.minMonth + 1) || month > (this.maxMonth + 1)) {
            return false;
        }

        month -= 1;

        if (light) {
            return true;
        }

        if (day < 1 || day > this._daysPerMonth(month, year)) {
            return false;
        }

        prefs = this.prefs;
        if (prefs.minDate && this._cmpDates(txt, this._dateToText(prefs.minDate)) === -1) {
            return false;
        }

        return !(prefs.maxDate && this._cmpDates(txt, this._dateToText(prefs.maxDate)) !== -1);
    },
    _cacheBuildDays: function (d, m, y, textYear) {
        var key = m + '.' + y,
            data = this._cacheMonths[key];

        // TODO: Кеширование создания HTML для месяца
        /*if (data) {
            return data;
        }*/

        //this._cacheMonths[key] = res;

        return this._buildDays(d, m, y, textYear);
    },
    _getDateObj: function (date) {
        return date ? new Date(date.year, date.month, date.day, 0, 0, 0) : date;
    },
    _buildDays: function (d, m, y, textYear) {
        var currentDate = new Date(),
            currentDay = currentDate.getDate(),
            currentMonth = currentDate.getMonth(),
            currentYear = currentDate.getFullYear(),
            that = this,
            minDate = that._getDateObj(that.prefs.minDate),
            maxDate = that._getDateObj(that.prefs.maxDate),
            minGrayDate = that._getDateObj(that.prefs.minGrayDate),
            maxGrayDate = that._getDateObj(that.prefs.maxGrayDate),
            FEBRARY = 1,
            SATURDAY = 5,
            SUNDAY = 6,
            date, month, text, weekday, outsideBuf, grayBuf, i, n, day,
            className, title, textDate, isoDate, v, str,
            allDaysDisabled;

        function isNow(d, m, y) {
            return d === currentDay && m === currentMonth && y === currentYear;
        }

        function whatDay(date) {
            if (minDate && date.valueOf() < minDate.valueOf()) {
                return -1;
            }

            if (maxDate && date.valueOf() >= maxDate.valueOf()) {
                return 1;
            }

            return 0;
        }

        function grayDay(date) {
            if (minGrayDate && date.valueOf() < minGrayDate.valueOf()) {
                return -1;
            }

            if (maxGrayDate && date.valueOf() >= maxGrayDate.valueOf()) {
                return 1;
            }

            return 0;
        }

        function templateSelectWeek(outsideBuf, weekday, day, week) {
            var disabled = true,
                i, len;

            for (i = day, len = outsideBuf.length; weekday <= SUNDAY && i <= len; i++) {
                if (outsideBuf[i] === false) {
                    disabled = false;
                    break;
                }

                weekday++;
            }

            return '<td class="{n}selector-week' + (disabled ? ' {n}selector-week-disabled"' : '" title="' + that.getString('selectWeek') + ' ' + week + '"') + '><span class="{n}selector-week"></span></td>';
        }

        date = new Date(y, m, 1, 0, 0, 0);
        if (that.isLeapYear(y)) {
            that.daysMonth[FEBRARY] = 29;
        } else {
            that.daysMonth[FEBRARY] = 28;
        }

        month = that.getString('months')[m];
        text = [];
        weekday = date.getDay() - 1;

        if (weekday === -1) {
            weekday = SUNDAY;
        }

        outsideBuf = [];
        grayBuf = [];
        for (i = 1; i <= that.daysMonth[m]; i++) {
            date.setDate(i);
            outsideBuf[i] = whatDay(date) !== 0;
            grayBuf[i] = grayDay(date) !== 0;
        }

        allDaysDisabled = that._isMonthDisabled(m, y, outsideBuf);
        text.push('<table><tr><th class="{n}month' +
            (allDaysDisabled ? ' {n}selector-month-gray' : '') +
            (that.prefs.single || !that.prefs.selectorMonths || allDaysDisabled ? ' {n}selector-month-disabled' : '') +
            '" colspan="' + (that.prefs.selectorWeeks ? 8 : 7) + '" title="' + month + ' ' + y + '">' + month + '&nbsp;' + (m === 0 || m === 11 ? y : textYear) + '<b>' + m + '.' + y + '</b></th></tr>');

        n = 0;
        for (i = 0; i < weekday; i++) {
            if (!n) {
                text.push('<tr>');
                if (that.prefs.selectorWeeks) {
                    date.setDate(1);
                    text.push(templateSelectWeek(outsideBuf, i, 1, that._weekOfYear(date)));
                }
            }

            text.push('<td class="{n}empty">&nbsp;</td>');
            n++;
        }

        for (day = 1; day <= that.daysMonth[m]; day++) {
            date.setDate(day);
            weekday = date.getDay() - 1;
            if (!n) {
                text.push('<tr>');
                if (that.prefs.selectorWeeks) {
                    text.push(templateSelectWeek(outsideBuf, weekday, day, that._weekOfYear(date)));
                }
            }

            if (weekday === -1) {
                weekday = SUNDAY;
            }

            className = '';
            title = '';
            textDate = that._leadZero(day) + '.' + that._leadZero(m + 1) + '.' + y;
            isoDate = y + '-' + that._leadZero(m + 1) + '-' + that._leadZero(day);

            if (weekday !== SUNDAY && weekday !== SATURDAY) {
                className = '{n}weekday';
            } else {
                className = '{n}holiday';
            }

            // Проверяем, если день является праздником по базе Яндекс.Календаря
            if (that.holidays && that.holidays[that.lang]) {
                v = that.holidays[that.lang][isoDate];
                if (v === 1) {
                    className = '{n}holiday';
                } else if (v === 0) {
                    className = '{n}weekday';
                }
            }

            if (day === that.day && m === that.month && y === that.year) {
                className += ' {n}selected';
            }

            if (outsideBuf[day]) {
                className += ' {n}day-disabled';
            }

            if (grayBuf[day]) {
                className += ' {n}gray-period';
            }

            if (isNow(day, m, y)) {
                className += ' {n}now';
                title += that.getString('now');
            }

            if (that.prefs.markedDate) {
                str = that.prefs.markedDate[textDate];
                if (str) {
                    className += ' {n}marked';
                    if (title) {
                        title += ', ';
                    }

                    title += str;
                }
            }

            if (that.prefs.disabledDates.length !== 0) {
                if (that.prefs.disabledDates.indexOf(textDate) !== -1) {
                    className += ' {n}day-disabled';
                }
            }

            text.push('<td class="' + className + '"' + (title ? ' title="' + title + '"' : '') +  '>' + day + '</td>');

            if (n === SUNDAY) {
                text.push('</tr>');
                n = -1;
            }
            n++;
        }

        if (n) {
            text.push('</tr>');
        }

        text.push('</table>');

        return text.join('');
    },

    /**
     *
     * @param {number} m
     * @param {number} y
     * @param {Array<boolean>} outsideBuf буфер с сохраненными индексами дней, находящихся до minDate или после maxDate
     * @returns {boolean}
     * @private
     */
    _isMonthDisabled: function(m, y, outsideBuf) {
        var period = parseInt(String(y) + this._leadZero(m), 10),
            isMin = true, isMax = true,
            prefs = this.prefs,
            minPeriod, maxPeriod, date;

        if (prefs.minDate) {
            minPeriod = parseInt(String(prefs.minDate.year) + this._leadZero(prefs.minDate.month), 10);
            isMin = (period >= minPeriod);
        }

        if (prefs.maxDate) {
            maxPeriod = parseInt(String(prefs.maxDate.year) + this._leadZero(prefs.maxDate.month), 10);
            isMax = (period <= maxPeriod);
        }

        if (!isMin || !isMax) {
            return true;
        }

        if (this.prefs.disabledDates.length !== 0) {

            for (var day = 1; day <= this.daysMonth[m]; day++) {
                date = this._leadZero(day) + '.' + this._leadZero(m + 1) + '.' + y;
                if (prefs.disabledDates.indexOf(date) === -1 && !outsideBuf[day]) {
                    return false;
                }
            }
            return true;
        }

        return false;
    },

    isLeapYear: function (y) {
        return ((y % 4 === 0) && (y % 100 !== 0)) || (y % 400 === 0);
    },
    resize: function () {
        this._setMinSize();
        this._calcNewSize();
        this._updateSelectorDateContainer();
        this._updateSelectorDateDragger();

        this._manualUpdateDragger();
    },
    updateDate: function () {
        var b = this.beginDate;
        this._pasteDays(b.day, b.month, b.year);
    },
    _animationShow: function (el) {
        el.css({marginTop: '-150px', opacity: '0'});
        el.stop().animate({opacity: '1', marginTop: '0'}, this.prefs.speedAnimation);
    },
    _animationHide: function (el) {
        el.css({marginTop: '0', opacity: '1'});
        el.stop().animate({opacity: '0', marginTop: '-150px'}, {duration: this.prefs.speedAnimation, complete: function () {
            el.hide();
        }});
    },
    _plugins: [],
    _initPlugins: function () {
        for (var i = 0; i < this._plugins.length; i++) {
            this._plugins[i].call(this);
        }
    },
    addPlugin: function (p) {
        if (p) {
            this._plugins.push(p);
        }
    },
    _firstShow: true,

    _getShowCoords: function () {
        var that = this,
            offset, viewportInfo;

        if (that.positionElement && that._firstShow) {
            offset = that.positionElement.offset();
            return {
                left: offset.left,
                top: offset.top + that.positionElement.outerHeight()
            };
        } else if (!that.positionElement) {
            viewportInfo = that._getViewportInfo();
            return {
                left: viewportInfo.left + (viewportInfo.width - that.jElement.width()) / 2,
                top: viewportInfo.top + (viewportInfo.height - that.jElement.height()) / 2
            };
        }
    },

    _getViewportInfo: function () {
        return {
            width: window.innerWidth,
            height: window.innerHeight,
            top: window.pageYOffset,
            left: window.pageXOffset
        };
    },

    show: function () {
        var f = function () {
                if (that._firstShow) {
                    that._setDraggerAtBeginDate();
                    that._initPlugins();
                }

                that.resize();
                that._updateSelectorDateSelectedPeriod(that.selectedPeriod);

                that._updateSelectorDateContainer(that.prefs.animation);

                if (that._firstShow && that.prefs.center) {
                    that.jElement.css('left', (($(window).width() - that.jElement.width()) / 2) + 'px');
                }

                that._firstShow = false;
                if (!that.jFrom.val() || !that.jTo.val()) {
                    that.jShow.addClass(that._namespace + 'disabled');
                }

                that.jFrom.addClass(that._namespace + 'from-selected');
                if (!that.prefs.touch) {
                    that.jFrom.focus();
                }

                $(document).trigger('show' + that._namespaceEvent);
            },
            that = this,
            showCoords = that._getShowCoords();

        that._ignoreResize = true;

        if (showCoords) {
            that.jElement.css(showCoords);
        }

        if (that.prefs.animation) {
            that.jElement.css({opacity: 0, visibility: 'hidden'}).show().css({visibility: 'visible'});
            f();
            that.jElement.css({visibility: 'visible'});
            that._animationShow(that.jElement);
            if (that.prefs.shadow) {
                that.jShadow.css({opacity: 0}).show();
                that.jShadow.stop().animate({opacity: that.prefs.opacityShadow}, that.prefs.speedAnimation);
            }
        } else {
            that.jElement.show();
            if (that.prefs.shadow) {
                that.jShadow.show();
            }
            f();
        }
    },
    close: function () {
        if (!this.prefs.single) {
            this.selectedPeriod = this._oldSelectedPeriod;
        }
        this.hide();
    },
    hide: function () {
        if (this.selectedPeriod && this.selectedPeriod.from && this.selectedPeriod.to)  {
            this._fineSelectedPeriod();
            this._setDraggerAtBeginDate();
        }

        this.selectedStep = 0;

        this.updateDate();

        if (this.prefs.animation) {
            this._animationHide(this.jElement);
        } else {
            this.jElement.hide();
        }

        if (this.prefs.shadow) {
            if (this.prefs.animation) {
                var that = this;
                this.jShadow.stop().animate({opacity: '0'}, {duration: this.prefs.speedAnimation, complete: function () {
                    that.jShadow.hide();
                }});
            } else {
                this.jShadow.hide();
            }
        }

        if (this.selectedPeriod.from && this.selectedPeriod.to) {
            this.jFrom.val(this._dateToText(this.selectedPeriod.from));
            this.jTo.val(this._dateToText(this.selectedPeriod.to));
        }

        $(document).trigger('hide' + this._namespaceEvent);
    },
    toggle: function () {
        if (this.jElement.is(':visible')) {
            this.hide();
        } else {
            this.show();
        }
    },
    remove: function () {
        this.jElement.remove();

        if (this.prefs.shadow) {
            this.jShadow.remove();
        }

        this._removeEvents();
    },

    /**
     *
     * @param {String} from
     * @param {String} to
     * @param {Object} settings
     * @prop {String} settings.dash
     * @prop {Boolean}
     * @returns {String}
     */
    finePeriod: function (from, to, settings) {
        if (!from) {
            return this.getString('selectionError');
        }

        var that = this,
            dash, text, fromMonth, fromMonthShort, toMonthShort, fromMonthCase, toMonthCase;
        settings = settings || {};
        function isFullMonth(fromDay, toDay, month, year) {
            return !!((fromDay === 1 && toDay === that._daysPerMonth(month, year)));
        }

        dash = settings.dash || '<span class="super-calendar__selector-dash">&mdash;</span>';
        from = this._recalcDate(from);
        to = this._recalcDate(to);

        text = '';
        fromMonthShort = this.getString('monthsShort')[from.month];
        toMonthShort = this.getString('monthsShort')[to.month];
        fromMonth = (settings.shortMonth ? fromMonthShort : this.getString('months')[from.month]);
        fromMonthCase = (settings.shortMonth ? fromMonthShort : this.getString('monthsCase')[from.month]);
        toMonthCase = (settings.shortMonth ? toMonthShort : this.getString('monthsCase')[to.month]);
        if (!this._cmpDates(from, to)) {
            return [from.day, fromMonthCase, from.year].join(' ');
        }

        if (from.year === to.year) {
            if (from.month === to.month) {
                if (isFullMonth(from.day, to.day, from.month, from.year)) {
                    text = [fromMonth.toLowerCase(), from.year];
                } else {
                    text = [from.day + dash + to.day, fromMonthCase, from.year];
                }
            } else {
                text = [from.day, fromMonthCase + dash + to.day, toMonthCase, from.year];
            }
        } else {
            text = [from.day, fromMonthCase, from.year + dash + to.day, toMonthCase, to.year];
        }

        return text.join(' ');
    },
    isMacOS: function () {
        var ua = ('' + navigator.userAgent).toLowerCase();
        return ua.search('mac os x') !== -1;
    },
    correctPeriodForMinMaxDate: function (period, minDate, maxDate) {
        period.from = this._recalcDate(period.from);
        period.to = this._recalcDate(period.to);
        minDate = this._recalcDate(this._prepareMinDate(minDate));
        maxDate = this._recalcDate(this._prepareMaxDate(maxDate));

        if (this._isCorrectDates(period.from, period.to, minDate, maxDate)) {
            period.from = this._correctMinDate(period.from, minDate);
            period.to = this._correctMaxDate(period.to, maxDate);
        } else {
            return false;
        }

        return period;
    }
};
//jshint ignore: end
